; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='cgscc(inline)' %s -S -pass-remarks-missed=inline 2>&1 | FileCheck --check-prefixes=CHECK,CHECK-INLINE %s
; RUN: opt -passes=always-inline -o - -S %s | FileCheck %s

; CHECK-INLINE: ssp not inlined into nossp_caller because it should never be inlined (cost=never): stack protected callee but caller requested no stack protector
; CHECK-INLINE: nossp not inlined into ssp_caller because it should never be inlined (cost=never): stack protected caller but callee requested no stack protector

; Not interesting to test.
define i32 @nossp() { ret i32 41 }
define i32 @ssp() sspstrong { ret i32 42 }
define i32 @nossp_alwaysinline() alwaysinline { ret i32 43 }
define i32 @ssp_alwaysinline() sspstrong alwaysinline { ret i32 44 }

; @ssp should not be inlined due to mismatch stack protector.
; @ssp_alwaysinline should be inlined due to alwaysinline.
define i32 @nossp_caller() {
; CHECK-LABEL: @nossp_caller(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @ssp()
; CHECK-NEXT:    ret i32 44
;
  call i32 @ssp()
  %2 = call i32 @ssp_alwaysinline()
  ret i32 %2
}
; @nossp should not be inlined due to mismatch stack protector.
; @nossp_alwaysinline should be inlined due to alwaysinline.
define i32 @ssp_caller() sspstrong {
; CHECK-LABEL: @ssp_caller(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @nossp()
; CHECK-NEXT:    ret i32 43
;
  call i32 @nossp()
  %2 = call i32 @nossp_alwaysinline()
  ret i32 %2
}

; The alwaysinline attribute can also appear on the CallBase (ie. the call
; site), ie. when __attribute__((flatten)) is used on the caller. Treat this
; the same as if the caller had the fn attr alwaysinline and permit inline
; substitution, despite the mismatch between caller and callee on ssp attrs.
;
; Curiously, the always_inline attribute on a CallInst is only expanded by the
; inline pass, but not always_inline pass!
define i32 @nossp_alwaysinline_caller() {
; CHECK-INLINE-LABEL: @nossp_alwaysinline_caller(
; CHECK-INLINE-NEXT:    ret i32 42
;
  %1 = call i32 @ssp() alwaysinline
  ret i32 %1
}
