enable_language(CXX)

set(CMAKE_XCODE_GENERATE_SCHEME ON)

function(create_scheme_for_variable variable)
  set(CMAKE_XCODE_SCHEME_${variable} ON)
  add_executable(${variable} main.cpp)
endfunction()

create_scheme_for_variable(ADDRESS_SANITIZER)
create_scheme_for_variable(ADDRESS_SANITIZER_USE_AFTER_RETURN)
create_scheme_for_variable(THREAD_SANITIZER)
create_scheme_for_variable(THREAD_SANITIZER_STOP)
create_scheme_for_variable(UNDEFINED_BEHAVIOUR_SANITIZER)
create_scheme_for_variable(UNDEFINED_BEHAVIOUR_SANITIZER_STOP)
create_scheme_for_variable(DISABLE_MAIN_THREAD_CHECKER)
create_scheme_for_variable(MAIN_THREAD_CHECKER_STOP)

create_scheme_for_variable(MALLOC_SCRIBBLE)
create_scheme_for_variable(MALLOC_GUARD_EDGES)
create_scheme_for_variable(GUARD_MALLOC)
create_scheme_for_variable(ZOMBIE_OBJECTS)
create_scheme_for_variable(MALLOC_STACK)
create_scheme_for_variable(DYNAMIC_LINKER_API_USAGE)
create_scheme_for_variable(DYNAMIC_LIBRARY_LOADS)

function(create_scheme_for_property scheme property value)
  set(XCODE_SCHEME_${property} ON)
  add_executable(${scheme} main.cpp)
  set_target_properties(${scheme} PROPERTIES XCODE_SCHEME_${property} "${value}")
endfunction()

create_scheme_for_property(DISABLE_XCODE_SCHEME_ENABLE_GPU_API_VALIDATION ENABLE_GPU_API_VALIDATION OFF)
create_scheme_for_property(ENABLE_XCODE_SCHEME_ENABLE_GPU_SHADER_VALIDATION ENABLE_GPU_SHADER_VALIDATION ON)
create_scheme_for_property(ENABLE_GPU_FRAME_CAPTURE_MODE_1 ENABLE_GPU_FRAME_CAPTURE_MODE 1)
create_scheme_for_property(ENABLE_GPU_FRAME_CAPTURE_MODE_3 ENABLE_GPU_FRAME_CAPTURE_MODE 3)
create_scheme_for_property(ENABLE_GPU_FRAME_CAPTURE_MODE_DISABLED ENABLE_GPU_FRAME_CAPTURE_MODE Disabled)
create_scheme_for_property(ENABLE_GPU_FRAME_CAPTURE_MODE_METAL ENABLE_GPU_FRAME_CAPTURE_MODE Metal)
create_scheme_for_property(ENABLE_GPU_FRAME_CAPTURE_MODE_DISABLED_MIXED_CASE ENABLE_GPU_FRAME_CAPTURE_MODE DISAbled)
create_scheme_for_property(ENABLE_GPU_FRAME_CAPTURE_MODE_METAL_MIXED_CASE ENABLE_GPU_FRAME_CAPTURE_MODE METal)
create_scheme_for_property(LAUNCH_MODE_AUTO LAUNCH_MODE AUTO)
create_scheme_for_property(LAUNCH_MODE_WAIT LAUNCH_MODE WAIT)
create_scheme_for_property(EXECUTABLE EXECUTABLE myExecutable)
create_scheme_for_property(ARGUMENTS ARGUMENTS "--foo;--bar=baz")
create_scheme_for_property(ENVIRONMENT ENVIRONMENT "FOO=foo;BAR=bar")
create_scheme_for_property(WORKING_DIRECTORY WORKING_DIRECTORY "/working/dir")

add_executable(NoSchema main.cpp)
set_target_properties(NoSchema PROPERTIES XCODE_GENERATE_SCHEME OFF)

add_custom_target(CustomTarget)
