/*
 * (os_if.c)- Defines interface to linux-specific system-level functions
 *
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 

#define OS_IF_C

#include <asm/ptrace.h>
#include <linux/string.h>
#include <linux/posix_types.h>
#include <linux/interrupt.h>
#include <linux/timer.h>
#include <linux/sched.h>
#include <net/cm_types.h>
#include <net/cm_mm.h>
#include <net/cm_frame.h>
#include <net/os_if.h>
#include <net/llc_dbg.h>

#ifdef OS_IF_DBG
  #define  DBG_MSG(body) { printk body; }
#else
  #define  DBG_MSG(body)  ;
#endif


typedef struct timer_list os_timer_t;

typedef void (*os_callback_t)(void);

/*
 * Function: os_tmr_create
 *
 * Description:
 *  Creates a new timer and return its pointer in "timer".
 *
 * Parameters:
 *  mph_t mph : This argument points to memory pool which this timer must be 
 *  	get its memory from it.
 *  void **timer : Pointer of created timer returns in this argument.
 *
 * Returns:
 *  0 : success
 *  1 : failure
 */
 
us16 
os_tmr_create (mph_t mph, void **timer)
{
	os_timer_t *tmr;

	tmr = (os_timer_t *) mm_malloc (mph, sizeof(os_timer_t));
	if (tmr) {
		memset (tmr, 0, sizeof (os_timer_t));
	}

	*timer = (void *) tmr;

	return (*timer ? 0 : 1);
}


/*
 * Function: os_tmr_set
 *
 * Description:
 *  This routine sets value of given timer.
 *
 * Parameters:
 *  void * tmr : This argument points to given timer structure.
 *  us32 ticks : This argument is value of timer that must be set.
 *
 * Returns:
 *  0 : success
 *  1 : failure
 */

us16 
os_tmr_set (void * tmr, us32 ticks )
{
	us16 rc = 1;
	os_timer_t *timer = (os_timer_t *) tmr;

	if (timer) {
		timer->expires = jiffies + ticks ;
		rc = 0;
	}

	return (rc);
}


/*
 * Function: os_tmr_start
 *
 * Description:
 *  This routine adds given timer to timers of the system.
 *
 * Parameters:
 *  void *tmr : This argument points to given timer.
 *  timer_callback_t timer_func : This argument is callback function of given
 * 	 timer, this function is called when given timer expires.
 *  void *tmr_data : This argument points to parameters of callback function.
 *
 * Returns:
 *  0 : success
 *  1 : failure
 */

us16 
os_tmr_start (void *tmr, timer_callback_t timer_func, void *tmr_data)
{
	us16 rc = 1;
	os_timer_t *timer = (os_timer_t *) tmr;

	if (timer) {
		timer->data = (us32) tmr_data;
		timer->function = timer_func;
		add_timer (timer);
		rc = 0;
	}

	return (rc);
}



/*
 * Function: os_tmr_stop
 *
 * Description:
 *  This routine delete given timer from timers of the system.
 *
 * Parameters:
 *  void *timer : This argument points to given timer. 
 *
 * Returns:
 *  0 : success
 *  1 : failure
 */

us16 
os_tmr_stop (void *timer)
{
	us16 rc = 1;

	if (timer) {
		if (del_timer ((os_timer_t *) timer)) {
			rc = 0;
		}
	}

	return (rc);
}


