/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Doubly-linked list manager 
 */

#ifndef CM_DLL_H
#define CM_DLL_H


/* Remember which lists frame is a member of (max. #) */
#define LISTS                  5

#define NBR_LISTS_ATTACHED     2

#define DLL_WHERE_HEAD         1
#define DLL_WHERE_TAIL         2


/* List matching options */
#define DLL_MATCH_DELETE       0x01
#define DLL_MATCH_PEEK         0x02    /* can only peek one, not all */
#define DLL_MATCH_ONE          0x04    /* stop on first one */
#define DLL_MATCH_ALL          0x08


/* Each entry in a list */
typedef struct _dll_entry_t            /* 12-byte overhead per list entry */
{
   struct _dll_entry_t *   next;       /* next in list */
   struct _dll_entry_t *   prev;       /* previous in list */
   void *                  this;       /* data for this link */
#if 0
   void *                  lists [NBR_LISTS_ATTACHED];
#endif
} dll_entry_t;


/* Head of a list */   
typedef struct
{
   dll_entry_t *           head;
   dll_entry_t *           tail;
   us16                    size;       /* number entries in the list */
} dll_t;


#ifndef CM_DLL_C
#define EXTRN extern
#else
#define EXTRN
#endif /* CM_DLL_C */


/* Function prototypes for module interface */
                   
EXTRN us16         dll_init (void);
EXTRN us16         dll_exit (void);
EXTRN us16         dll_initialize (dll_t * list);
EXTRN us16         dll_add (dll_t * list, void * member, us8 where);
EXTRN us16         dll_match (dll_t * list, 
                     us16 (*match_func)(void * this, void * match_value),
                               void * match_value, void ** return_this, 
                                                               us8 options);
EXTRN us16         dll_remove (dll_t * list, void ** member, us8 where);
EXTRN us16         dll_query (dll_t * list);
EXTRN us16         dll_remove_this (dll_t * list, void * member);
EXTRN us16         dll_move (dll_t * src_list, dll_t * dest_list,
                                              void * member, us8 dest_where);
EXTRN us16         dll_peek (dll_t * list, void ** member, us8 where);


#ifdef TESTING
EXTRN us16         dll_inquire (dll_t * list);
#endif


#undef EXTRN
#endif /* CM_DLL_H */


