/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * SAP component actions 
 */

#ifndef LLC_S_AC_H
#define LLC_S_AC_H


#define SAP_ACT_UNITDATA_INDICATION        1
#define SAP_ACT_SEND_UI                    2
#define SAP_ACT_SEND_XID_C                 3
#define SAP_ACT_SEND_XID_R                 4
#define SAP_ACT_SEND_TEST_C                5
#define SAP_ACT_SEND_TEST_R                6
#define SAP_ACT_REPORT_STATUS              7
#define SAP_ACT_XID_INDICATION             8
#define SAP_ACT_TEST_INDICATION            9


/* All action functions must look like this */
typedef us16       (*sap_action_t)(sap_t * sap, sap_state_event_t * event);


#ifdef LLC_S_AC_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_S_AC_C */

EXTRN us16     sap_action_unitdata_indication (sap_t * sap,
                                                sap_state_event_t * event);
EXTRN us16     sap_action_send_ui (sap_t * sap, sap_state_event_t * event);
EXTRN us16     sap_action_send_xid_c (sap_t * sap,
                                                sap_state_event_t * event);
EXTRN us16     sap_action_send_xid_r (sap_t * sap,
                                                sap_state_event_t * event);
EXTRN us16     sap_action_send_test_c (sap_t * sap,
                                                sap_state_event_t * event);
EXTRN us16     sap_action_send_test_r (sap_t * sap,
                                                sap_state_event_t * event);
EXTRN us16     sap_action_report_status (sap_t * sap,
                                                sap_state_event_t * event);
EXTRN us16     sap_action_xid_indication (sap_t * sap,
                                                sap_state_event_t * event);
EXTRN us16     sap_action_test_indication (sap_t * sap,
                                                sap_state_event_t * event);


#undef EXTRN
#endif /* LLC_S_AC_H */

