/* SPDX-License-Identifier: GPL-2.0-only */
/* Copyright (c) 2022 Linaro. All rights reserved.
 * Author: Caleb Connolly <caleb.connolly@linaro.org>
 */

#ifndef __QCOM_SPMI_PMIC_H__
#define __QCOM_SPMI_PMIC_H__

#include <linux/device.h>

#define COMMON_SUBTYPE		0x00
#define PM8941_SUBTYPE		0x01
#define PM8841_SUBTYPE		0x02
#define PM8019_SUBTYPE		0x03
#define PM8226_SUBTYPE		0x04
#define PM8110_SUBTYPE		0x05
#define PMA8084_SUBTYPE		0x06
#define PMI8962_SUBTYPE		0x07
#define PMD9635_SUBTYPE		0x08
#define PM8994_SUBTYPE		0x09
#define PMI8994_SUBTYPE		0x0a
#define PM8916_SUBTYPE		0x0b
#define PM8004_SUBTYPE		0x0c
#define PM8909_SUBTYPE		0x0d
#define PM8028_SUBTYPE		0x0e
#define PM8901_SUBTYPE		0x0f
#define PM8950_SUBTYPE		0x10
#define PMI8950_SUBTYPE		0x11
#define PM8998_SUBTYPE		0x14
#define PMI8998_SUBTYPE		0x15
#define PM8005_SUBTYPE		0x18
#define PM660L_SUBTYPE		0x1A
#define PM660_SUBTYPE		0x1B
#define PM8150_SUBTYPE		0x1E
#define PM8150L_SUBTYPE		0x1f
#define PM8150B_SUBTYPE		0x20
#define PMK8002_SUBTYPE		0x21
#define PM8009_SUBTYPE		0x24
#define PM8150C_SUBTYPE		0x26
#define SMB2351_SUBTYPE		0x29

#define PMI8998_FAB_ID_SMIC	0x11
#define PMI8998_FAB_ID_GF	0x30

#define PM660_FAB_ID_GF		0x0
#define PM660_FAB_ID_TSMC	0x2
#define PM660_FAB_ID_MX		0x3

struct qcom_spmi_pmic {
	unsigned int type;
	unsigned int subtype;
	unsigned int major;
	unsigned int minor;
	unsigned int rev2;
	unsigned int fab_id;
	const char *name;
};

const struct qcom_spmi_pmic *qcom_pmic_get(struct device *dev);

#endif /* __QCOM_SPMI_PMIC_H__ */
