info = {
    "name": "bn",
    "date_order": "DMY",
    "january": [
        "জানুয়ারী",
        "জানু",
        "জানুয়ারি"
    ],
    "february": [
        "ফেব্রুয়ারী",
        "ফেব",
        "ফেব্রুয়ারি"
    ],
    "march": [
        "মার্চ"
    ],
    "april": [
        "এপ্রিল"
    ],
    "may": [
        "মে"
    ],
    "june": [
        "জুন"
    ],
    "july": [
        "জুলাই"
    ],
    "august": [
        "আগস্ট"
    ],
    "september": [
        "সেপ্টেম্বর"
    ],
    "october": [
        "অক্টোবর"
    ],
    "november": [
        "নভেম্বর"
    ],
    "december": [
        "ডিসেম্বর"
    ],
    "monday": [
        "সোমবার",
        "সোম"
    ],
    "tuesday": [
        "মঙ্গলবার",
        "মঙ্গল"
    ],
    "wednesday": [
        "বুধবার",
        "বুধ"
    ],
    "thursday": [
        "বৃহষ্পতিবার",
        "বৃহস্পতি",
        "বৃহস্পতিবার"
    ],
    "friday": [
        "শুক্রবার",
        "শুক্র"
    ],
    "saturday": [
        "শনিবার",
        "শনি"
    ],
    "sunday": [
        "রবিবার",
        "রবি"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "বছর",
        "বৎসর",
        "সাল"
    ],
    "month": [
        "মাস"
    ],
    "week": [
        "সপ্তাহ"
    ],
    "day": [
        "দিন"
    ],
    "hour": [
        "ঘন্টা"
    ],
    "minute": [
        "মিনিট"
    ],
    "second": [
        "সেকেন্ড"
    ],
    "relative-type": {
        "1 year ago": [
            "গত বছর"
        ],
        "0 year ago": [
            "এই বছর"
        ],
        "in 1 year": [
            "পরের বছর",
            "আগামী বছর"
        ],
        "1 month ago": [
            "গত মাস"
        ],
        "0 month ago": [
            "এই মাস"
        ],
        "in 1 month": [
            "পরের মাস",
            "আগামী মাস"
        ],
        "1 week ago": [
            "গত সপ্তাহ"
        ],
        "0 week ago": [
            "এই সপ্তাহ"
        ],
        "in 1 week": [
            "পরের সপ্তাহ",
            "আগামী সপ্তাহ"
        ],
        "1 day ago": [
            "গতকাল"
        ],
        "0 day ago": [
            "আজ"
        ],
        "in 1 day": [
            "আগামীকাল"
        ],
        "0 hour ago": [
            "এই ঘণ্টায়"
        ],
        "0 minute ago": [
            "এই মিনিট"
        ],
        "0 second ago": [
            "এখন"
        ],
        "2 day ago": [
            "গত পরশু"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) বছরে"
        ],
        "\\1 year ago": [
            "(\\d+) বছর পূর্বে"
        ],
        "in \\1 month": [
            "(\\d+) মাসে"
        ],
        "\\1 month ago": [
            "(\\d+) মাস আগে"
        ],
        "in \\1 week": [
            "(\\d+) সপ্তাহে"
        ],
        "\\1 week ago": [
            "(\\d+) সপ্তাহ আগে"
        ],
        "in \\1 day": [
            "(\\d+) দিনের মধ্যে"
        ],
        "\\1 day ago": [
            "(\\d+) দিন আগে"
        ],
        "in \\1 hour": [
            "(\\d+) ঘন্টায়"
        ],
        "\\1 hour ago": [
            "(\\d+) ঘন্টা আগে"
        ],
        "in \\1 minute": [
            "(\\d+) মিনিটে"
        ],
        "\\1 minute ago": [
            "(\\d+) মিনিট আগে",
            "(\\d+) মিনিট পূর্বে"
        ],
        "in \\1 second": [
            "(\\d+) সেকেন্ডে"
        ],
        "\\1 second ago": [
            "(\\d+) সেকেন্ড পূর্বে",
            "(\\d+) সেকেন্ড আগে"
        ]
    },
    "locale_specific": {
        "bn-IN": {
            "name": "bn-IN"
        }
    },
    "skip": [
        "টা",
        "লা",
        "শে",
        "ই",
        "প্রায়",
        "এবং",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 3,
    "ago": [
        "আগে"
    ],
    "in": [
        "মধ্যে"
    ],
    "simplifications": [
        {
            "মধ্যাহ্ন": "12:00"
        },
        {
            "মধ্যরাত": "00:00"
        }
    ]
}
