/* fmt_scan.h -- format string interpretation
 *
 * This code is Copyright (c) 2017, by the authors of nmh.  See the
 * COPYRIGHT file in the root directory of the nmh distribution for
 * complete copyright information.
 *
 * This is the engine that processes the format instructions created by
 * fmt_compile (found in fmt_compile.c). */

/*
 * These are the definitions used by the callbacks for fmt_scan()
 */
typedef char *(*formataddr_cb)(char *, char *);
typedef char *(*concataddr_cb)(char *, char *);
typedef void (*trace_cb)(void *, struct format *, int, char *, const char *);

struct fmt_callbacks {
    formataddr_cb	formataddr;
    concataddr_cb	concataddr;
    trace_cb		trace_func;
    void *		trace_context;
};

/*
 * Interpret a sequence of compiled format instructions.  Arguments are:
 *
 * format	- Array of format instructions generated by fmt_compile()
 * scanl	- Passed-in charstring_t object (created with
 *		  charstring_create() and later destroyed with
 *		  charstring_free()) that will contain the output of the
 *		  format instructions.  Is always terminated with a
 *		  newline (\n).
 * width	- Maximum number of displayed characters.  Does not include
 *		  characters marked as non-printing or (depending on the
 *		  encoding) bytes in a multibyte encoding that exceed the
 *		  character's column width.
 * dat		- An integer array that contains data used by certain format
 *		  functions.  Currently the following instructions use
 *		  dat[]:
 *
 *		dat[0] - %(msg), %(dat)
 *		dat[1] - %(cur)
 *		dat[2] - %(size)
 *		dat[3] - %(width)
 *		dat[4] - %(unseen)
 *
 * callbacks	- A set of a callback functions used by the format engine.
 *		  Can be NULL.  If structure elements are NULL, a default
 *		  function will be used.  Callback structure elements are:
 *
 *		formataddr	- A callback for the %(formataddr) instruction
 *		concataddr	- A callback for the %(concataddr) instruction
 *		trace		- Called for every format instruction executed
 *
 * The return value is a pointer to the next format instruction to
 * execute, which is currently always NULL.
 */
struct format *fmt_scan(struct format *, charstring_t, int, int *, struct fmt_callbacks *);

extern struct mailname fmt_mnull;
