import parseDataUrl from "../src/parse-data-url";

const dataUrls = [
  "data://test/,X",
  "http://domain.com",
  "data://test:test/,X",
  "data:,X",
  "data:text/html",
  "data:text/html    ;charset=x   ",
  "data:,",
  "data:,X#X",
  "data:,%FF",
  "data:text/plain,X",
  "data:text/plain ,X",
  "data:text/plain%20,X",
  "data:text/plain\f,X",
  "data:text/plain%0C,X",
  "data:text/plain;,X",
  "data:;x=x;charset=x,X",
  "data:;x=x,X",
  "data:text/plain;charset=windows-1252,%C2%B1",
  "data:text/plain;Charset=UTF-8,%C2%B1",
  "data:image/gif,%C2%B1",
  "data:IMAGE/gif,%C2%B1",
  "data:IMAGE/gif;hi=x,%C2%B1",
  "data:IMAGE/gif;CHARSET=x,%C2%B1",
  "data: ,%FF",
  "data:%20,%FF",
  "data:\f,%FF",
  "data:%1F,%FF",
  "data:\u0000,%FF",
  "data:%00,%FF",
  "data:text/html  ,X",
  "data:text / html,X",
  "data:†,X",
  "data:†/†,X",
  "data:X,X",
  "data:image/png,X X",
  "data:application/javascript,X X",
  "data:application/xml,X X",
  "data:text/javascript,X X",
  "data:text/plain,X X",
  "data:unknown/unknown,X X",
  'data:text/plain;a=",",X',
  "data:text/plain;a=%2C,X",
  "data:;base64;base64,WA",
  "data:x/x;base64;base64,WA",
  "data:x/x;base64;charset=x,WA",
  "data:x/x;base64;charset=x;base64,WA",
  "data:x/x;base64;base64x,WA",
  "data:;base64,W%20A",
  "data:;base64,W%0CA",
  "data:x;base64x,WA",
  "data:x;base64;x,WA",
  "data:x;base64=x,WA",
  "data:; base64,WA",
  "data:;  base64,WA",
  "data:  ;charset=x   ;  base64,WA",
  "data:;base64;,WA",
  "data:;base64 ,WA",
  "data:;base64   ,WA",
  "data:;base 64,WA",
  "data:;BASe64,WA",
  "data:;%62ase64,WA",
  "data:%3Bbase64,WA",
  "data:;charset=x,X",
  "data:; charset=x,X",
  "data:;charset =x,X",
  "data:;charset= x,X",
  "data:;charset=,X",
  "data:;charset,X",
  'data:;charset="x",X',
  'data:;CHARSET="X",X',
  'no-data:;CHARSET="X",X',
  "data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==",
  "DATA:IMAGE/GIF;BASE64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==",
  "data:,Hello%2C%20World!",
  "data:,%%%",
  "data:,%%a",
  "data:,%%1",
  "data:,%1%",
  "data:,a",
  "data:, a",
  "data:,a ",
  "data:, a ",
  "data:,a\tb",
  "data:,a\nb",
  "data:,a\fb",
  "data:,a\rb",
  "data:,a b",
  "data:,ab\\u00a0cd",
  "data:,ab\\t\\n\\f\\r cd",
  "data:, \\t\\n\\f\\r ab\\t\\n\\f\\r cd\\t\\n\\f\\r ",
  "data:, ab\\t\\n\\f\\r =\\t\\n\\f\\r =\\t\\n\\f\\r  ",
  "data:,/",
  "data:,/A",
  "data:text/plain;base64,abcd",
  "data:text/plain;base64, abcd",
  "data:text/plain;base64,abcd ",
  "data:text/plain;base64, abcd===",
  "data:text/plain;base64,abcd=== ",
  "data:text/plain;base64,abcd ===",
  "data:text/plain;base64,a",
  "data:text/plain;base64,ab",
  "data:text/plain;base64,abc",
  "data:text/plain;base64,abcde",
  "data:text/plain;base64,\uD800\uDC00",
  "data:text/plain;base64,=",
  "data:text/plain;base64,==",
  "data:text/plain;base64,===",
  "data:text/plain;base64,====",
  "data:text/plain;base64,=====",
  "data:text/plain;base64,a=",
  "data:text/plain;base64,a==",
  "data:text/plain;base64,a===",
  "data:text/plain;base64,a====",
  "data:text/plain;base64,a=====",
  "data:text/plain;base64,ab=",
  "data:text/plain;base64,ab==",
  "data:text/plain;base64,ab===",
  "data:text/plain;base64,ab====",
  "data:text/plain;base64,ab=====",
  "data:text/plain;base64,abc=",
  "data:text/plain;base64,abc==",
  "data:text/plain;base64,abc===",
  "data:text/plain;base64,abc====",
  "data:text/plain;base64,abc=====",
  "data:text/plain;base64,abcd=",
  "data:text/plain;base64,abcd==",
  "data:text/plain;base64,abcd===",
  "data:text/plain;base64,abcd====",
  "data:text/plain;base64,abcd=====",
  "data:text/plain;base64,abcde=",
  "data:text/plain;base64,abcde==",
  "data:text/plain;base64,abcde===",
  "data:text/plain;base64,abcde====",
  "data:text/plain;base64,abcde=====",
  "data:text/plain;base64,=a",
  "data:text/plain;base64,=a=",
  "data:text/plain;base64,a=b",
  "data:text/plain;base64,a=b=",
  "data:text/plain;base64,ab=c",
  "data:text/plain;base64,ab=c=",
  "data:text/plain;base64,abc=d",
  "data:text/plain;base64,abc=d=",
  "data:text/plain;base64,ab\tcd",
  "data:text/plain;base64,ab\ncd",
  "data:text/plain;base64,ab\fcd",
  "data:text/plain;base64,ab\rcd",
  "data:text/plain;base64,ab cd",
  "data:text/plain;base64,ab\u00a0cd",
  "data:text/plain;base64,ab\t\n\f\r cd",
  "data:text/plain;base64, \t\n\f\r ab\t\n\f\r cd\t\n\f\r ",
  "data:text/plain;base64,ab\t\n\f\r =\t\n\f\r =\t\n\f\r ",
  "data:text/plain;base64,A",
  "data:text/plain;base64,/A",
  "data:text/plain;base64,//A",
  "data:text/plain;base64,///A",
  "data:text/plain;base64,////A",
  "data:text/plain;base64,/",
  "data:text/plain;base64,A/",
  "data:text/plain;base64,AA/",
  "data:text/plain;base64,AAAA/",
  "data:text/plain;base64,AAA/",
  "data:text/plain;base64,\\0nonsense",
  "data:text/plain;base64,abcd\\0nonsense",
  "data:,Hello%2C%20World!",
  "data:,Привет%2C%20Мир!",
  "data:text/plain;base64,SGVsbG8sIFdvcmxkIQ==",
  "data:text/html,%3Ch1%3EHello%2C%20World!%3C%2Fh1%3E",
  "data:text/html,<script>alert('hi');</script>\n",
  "data:,а",
  "data:,a",
  "data:text/plain;,hello",
  "data:text;,hello",
  "data:text/0000;,hello",
  "data:text/   ;,hello",
  "data:text/html;charset=foo,<h1>%D0%9F%D1%80%D0%B8%D0%B2%D0%B5%D1%82%2C%20World!<%2Fh1>",
  "data:text/html;charset=utf-8;charset=foo,<h1>%D0%9F%D1%80%D0%B8%D0%B2%D0%B5%D1%82%2C%20World!<%2Fh1>",
  "data:text/html;charset=utf-8;foo=bar,<h1>%D0%9F%D1%80%D0%B8%D0%B2%D0%B5%D1%82%2C%20World!<%2Fh1>",
  "data:text/html;charset=utf-8;foo=bar;foo=baz,<h1>%D0%9F%D1%80%D0%B8%D0%B2%D0%B5%D1%82%2C%20World!<%2Fh1>",
  "data:application/json;charset=utf-8;base64,eyJmb28iOiJiYXIifQ==",
  "data:application/json;base64,eyJmb28iOiJiYXIifQ==",
  "data:application/zzz;base64,eyJmb28iOiJiYXIifQ==",
  "data:,test",
];
describe("parse-data-url", () => {
  dataUrls.forEach((dataUrl, index) => {
    it(`should work with url by "${index}" index`, async () => {
      const parsed = parseDataUrl(dataUrl);

      expect({ original: dataUrl, parsed }).toMatchSnapshot();
    });
  });
});
