# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AssetKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of the asset of the project."""

    QNAS = "qnas"
    """Question and Answers."""
    SYNONYMS = "synonyms"
    """Synonyms."""


class ErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    """Invalid request error"""
    INVALID_ARGUMENT = "InvalidArgument"
    """Invalid argument error"""
    UNAUTHORIZED = "Unauthorized"
    """Unauthorized access error"""
    FORBIDDEN = "Forbidden"
    """Forbidden access error"""
    NOT_FOUND = "NotFound"
    """Not found error"""
    PROJECT_NOT_FOUND = "ProjectNotFound"
    """Project not found error"""
    OPERATION_NOT_FOUND = "OperationNotFound"
    """Operation not found error"""
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    """Azure Cognitive Search not found error"""
    AZURE_COGNITIVE_SEARCH_INDEX_NOT_FOUND = "AzureCognitiveSearchIndexNotFound"
    """Azure Cognitive Search index not found error"""
    TOO_MANY_REQUESTS = "TooManyRequests"
    """Too many requests error"""
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    """Azure Cognitive Search throttling error"""
    AZURE_COGNITIVE_SEARCH_INDEX_LIMIT_REACHED = "AzureCognitiveSearchIndexLimitReached"
    """Azure Cognitive Search index limit reached error"""
    INTERNAL_SERVER_ERROR = "InternalServerError"
    """Internal server error"""
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    """Service unavailable error"""
    TIMEOUT = "Timeout"
    """Timeout error"""
    QUOTA_EXCEEDED = "QuotaExceeded"
    """Quota exceeded error"""
    CONFLICT = "Conflict"
    """Conflict error"""
    WARNING = "Warning"
    """Warning error"""


class Format(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Knowledge base Import or Export format."""

    JSON = "json"
    """Export or Import QnA assets in JSON format."""
    TSV = "tsv"
    """Export or Import knowledge base replica including all assets and metadata in
    Excel format."""
    EXCEL = "excel"
    """Export or Import knowledge base replica including all assets and metadata in
    Tsv format."""


class InnerErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    """Invalid request error"""
    INVALID_PARAMETER_VALUE = "InvalidParameterValue"
    """Invalid parameter value error"""
    KNOWLEDGE_BASE_NOT_FOUND = "KnowledgeBaseNotFound"
    """Knowledge base not found error"""
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    """Azure Cognitive Search not found error"""
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    """Azure Cognitive Search throttling error"""
    EXTRACTION_FAILURE = "ExtractionFailure"
    """Extraction failure error"""
    INVALID_REQUEST_BODY_FORMAT = "InvalidRequestBodyFormat"
    """Invalid request body format error"""
    EMPTY_REQUEST = "EmptyRequest"
    """Empty request error"""
    MISSING_INPUT_DOCUMENTS = "MissingInputDocuments"
    """Missing input documents error"""
    INVALID_DOCUMENT = "InvalidDocument"
    """Invalid document error"""
    MODEL_VERSION_INCORRECT = "ModelVersionIncorrect"
    """Model version incorrect error"""
    INVALID_DOCUMENT_BATCH = "InvalidDocumentBatch"
    """Invalid document batch error"""
    UNSUPPORTED_LANGUAGE_CODE = "UnsupportedLanguageCode"
    """Unsupported language code error"""
    INVALID_COUNTRY_HINT = "InvalidCountryHint"
    """Invalid country hint error"""


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Job Status."""

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    CANCELLED = "cancelled"
    CANCELLING = "cancelling"
    PARTIALLY_COMPLETED = "partiallyCompleted"


class SourceContentStructureKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Content structure type for sources."""

    UNSTRUCTURED = "unstructured"
    """Unstructured."""


class SourceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported source types."""

    FILE = "file"
    """File Source."""
    URL = "url"
    """URI Source."""


class UpdateOperationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Update operation type for assets."""

    ADD = "add"
    """Add operation."""
    DELETE = "delete"
    """Delete operation."""
    REPLACE = "replace"
    """Replace operation."""
