# illustration of issue 258

import ete3
import unittest


class testIssue258(unittest.TestCase):
    """ demonstrates a problem with ete3 using windows on python 3.5.2
    
    See:
    https://github.com/etetoolkit/ete/issues/258
    
    """
    
    def runTest(self):
        
        smallTreeText="(A:0.1,B:0.2,(C:0.3,D:0.4):0.5);"
        mediumTreeText="(9e411a0c-d4c8-4eb5-ad00-9fa28b9a132d:0.0000000247,(((((((((((((((((((((((((3b01012b-9f51-481e-a873-c394739a830e:0.0000000247,((((((((((((((((((((((((((((((((((((((((8689a922-13cd-428c-8164-8667593d98e6:0.0000000247,(((((((((((((((((((((((((((((69301637-bcdc-4912-b12b-7cff618dee2d:0.0000000247,((((((((((((((((06bd6b85-1f6f-4e6a-bdc2-3ecd00ce74ed:0.0000000000,d2a0bda9-7a02-4bb7-8eca-0309073048ad:0.0000000000):0.000000011,(((41ef71f3-8ebb-4a97-9b20-e3318b0aec38:0.0000000000,8e3b009b-cc78-4e8e-96d7-4b3acfdc6630:0.0000000000):0.000000025,(8beb2f00-7af6-43a4-a1cc-589c4a0b7cb7:0.0000000247,b7680e66-f7b1-490e-b643-b13efac24dcf:0.0000000247):0.000000024):0.000000021,b0ca25a2-882e-4108-906d-5aa16a2f7ffd:0.0000000247):0.000000011):0.000000024,6ae2ef45-7947-41d8-a47d-d63c21b92258:0.0000000247):0.000000244,((((e7f737c3-6d7b-4026-b14b-fdb92acf674e:0.0000000222,((3d56188f-f498-4884-9cfd-cce9fcc8d12d:0.0000000203,(f3634e80-845f-4110-a6c3-f689b1098458:0.0000000218,1ad39ee8-aeb1-4891-8c24-ce4103037f5c:0.0000000232):0.000000025):0.000000724,(eac342d0-66ca-460f-87a1-7fd1c221e981:0.0000000246,76fef173-6f46-467d-99ba-eb72c8298e4e:0.0000000247):0.000000011):0.000000020):0.000000175,7e94fa47-0047-492e-a9ec-841b113ed76e:0.0000000246):0.000000026,7f9a9e70-ac70-41d1-8374-93e37f05bd0f:0.0000000202):0.000000022,cf9b67ec-0dc0-46b1-876f-528610ccc90d:0.0000002468):0.000000012):0.000000489,(5bfe4cf9-6204-42bd-9206-278e8c200255:0.0000000226,3e4cad8c-fe67-4ffa-8ab7-18f5643f393c:0.0000000227):0.000001222):0.000000736,(((1faf27ed-199e-488a-bea7-84e43e814f07:0.0000009784,(a2fbbecc-c8c9-4430-addd-bde74ec51ed6:0.0000000215,07e55d5b-c66f-4e10-92c1-55ad0fd9dbd9:0.0000000210):0.000000021):0.000001472,1347ed4c-2e9a-4be6-99f3-40eb507b0804:0.0004341575):0.000000237,d445efdd-2f57-45b4-a02c-92bae74e37fd:0.0000014718):0.000000490):0.000000021,d0485f61-461a-4698-853d-0fd237d79190:0.0000000247):0.000000025,7b9d3a40-4d80-46eb-9743-aad5b7dac67a:0.0000000247):0.000000020,5df62ab7-a2a7-4089-ac5f-2b8a039a6cfd:0.0000000247):0.000000025,ef950d42-793e-435b-b574-a477461b3133:0.0000000247):0.000000023,0da2ab33-f0a6-4fc7-9b66-961546c3a672:0.0000000247):0.000000025,d45d3207-75b3-4a3e-bf28-e94c73c6e150:0.0000000218):0.000000023,b9809f87-32d4-4a97-8fec-2e0a0c45cd61:0.0000000247):0.000000025,1d16519e-dbd7-4aa8-aafb-c3fb71835016:0.0000000247):0.000000025,60089b6a-c05b-4fd7-ab51-9fe389ca2245:0.0000000247):0.000000025,c1fcd122-db9d-4c02-8cef-e916d4f6269f:0.0000000247):0.000000025):0.000000025,3a90e7a1-51e7-4cdf-bea0-f95f1226ae75:0.0000000247):0.000000025,411f2890-81b3-4728-8450-d5ef61e9ebd3:0.0000000247):0.000000025,c03e809c-3309-4dd8-a763-a2051977775f:0.0000000247):0.000000025,3fa556f8-6c96-4762-a402-cdf9f5fc8883:0.0000000247):0.000000025,7bc031b0-52e5-485b-a080-963df92a9e9c:0.0000000247):0.000000025,7c221b8f-558c-4f38-bcf7-ef8ce54904e6:0.0000000247):0.000000025,bbe1d2b7-8515-41d7-b864-caabedb4bc5d:0.0000000247):0.000000025,1419fd19-2d1b-4954-a13a-38e043cb150b:0.0000000247):0.000000025,a5b7a082-00d3-4b26-acdf-a46e53691c0e:0.0000000247):0.000000025,830b0d18-38dd-49e0-9cb8-e69d818bb2e0:0.0000000247):0.000000025,d001fbbf-4177-42f1-b08b-25a2766fe409:0.0000000247):0.000000025,cc4bf7b7-64b6-42ac-900e-824a818879e5:0.0000000247):0.000000025,8829793b-b4f5-49ac-88a4-42c2e45cfff4:0.0000000247):0.000000025,efe55ce5-f5e0-4f82-bf16-0bc49e738801:0.0000000247):0.000000025,d82e023e-d341-4877-a927-500c599dd333:0.0000000247):0.000000025,481c3430-25fe-437b-82b5-914b7a3327b7:0.0000000247):0.000000025,f3344114-46f9-4be9-80f4-b8d9395402b9:0.0000000247):0.000000025,7914ab4e-7097-4cff-816b-c93bc3bb2fb3:0.0000000247):0.000000025,924fe674-f18a-4716-97de-b06040f5aab0:0.0000000247):0.000000025,a3ce51f0-870d-457e-9e4c-f6dc7a802727:0.0000000247):0.000000025,af1a01ad-cee0-451c-a0a0-7e561cf5954e:0.0000000247):0.000000025,edcde028-8680-48c4-b13d-1285b0945eff:0.0000000247):0.000000025,735bbe5a-b1cd-4c92-98d6-ed4d37dc7565:0.0000000247):0.000000025,8d99acbb-5f48-47ae-8ca0-1db60bbba21f:0.0000000247):0.000000025,1376fdc0-a7ee-48b4-b8c2-2d54fa4641c2:0.0000000247):0.000000025,70a9d331-313f-4c1f-8496-88a51b5931d5:0.0000000247):0.000000025,92db9085-4b40-4db4-a4da-7330466f5f97:0.0000000247):0.000000025,a80958c1-8dc8-45d4-9c87-acee1fc25ad3:0.0000000247):0.000000025):0.000000025,c84aa452-a35d-4124-a976-d9b3796a5fff:0.0000000247):0.000000025,023c03bb-ff94-490e-a1fe-13cd4013b6f8:0.0000000247):0.000000025,353e78b5-a8e3-4929-aa81-dcee0f79e36d:0.0000000247):0.000000025,a90b64a9-2df9-4391-bfc0-3a75092e646a:0.0000000247):0.000000025,df9b8175-cb9c-44d1-b5d4-ec0f6e7192f8:0.0000000247):0.000000025,88079c83-d743-48b5-a4dc-33584b31ed4c:0.0000000247):0.000000025,8cb676b8-75f0-44d6-872f-f0cf9f9c0b63:0.0000000247):0.000000025,339a8f35-e896-4c18-be89-96acbe2eb090:0.0000000247):0.000000025,dccc3bae-da64-45ed-8231-126bdd4e2e0d:0.0000000247):0.000000025,93a97ede-3e63-4d19-8da1-d798280305e2:0.0000000247):0.000000025,5cf22c14-bd3c-427d-9970-2ba63cd2ee59:0.0000000247):0.000000025,02ee4aba-4c0e-4b70-8d31-6c3339339c73:0.0000000247):0.000000025,883aaf85-abdd-4609-8aca-70b21f65ea4b:0.0000000247):0.000000025,272c79ea-dadf-4693-a7e1-60455c223675:0.0000000247):0.000000025,2ee9cfa3-443b-4b25-a5d4-901c22cbae77:0.0000000247):0.000000025,898a1f16-e910-4276-89cb-8ad9782cc5ec:0.0000000247):0.000000025,f5dd3bad-b387-4e42-96cc-f53c0ed4b378:0.0000000247):0.000000025,3e5244e0-3e5f-4aee-b81c-dcd0c8d865e2:0.0000000247):0.000000025,47da627f-1c1f-4f59-b080-0cf7eb10467a:0.0000000247):0.000000025,c6d7779a-5478-408f-bb6a-81739f5758ae:0.0000000247):0.000000025,8849302f-aa5f-485b-8a79-532b70cafd3e:0.0000000247):0.000000025,0dd3fa72-1c86-4fa1-97ca-c05c22535b35:0.0000000247):0.000000025,9e84dbbf-39e7-475f-8664-1ba40220bfa6:0.0000000247):0.000000025,39f0af3b-1439-45cd-9679-150fbaa75150:0.0000000247):0.000000025,6c9c0300-3079-4195-815e-df1af020f69c:0.0000000247):0.000000025,9cc940c4-6aea-4cf2-9e11-430b28e7ad19:0.0000000247):0.000000025,44528a7b-b7c3-4d99-9f2e-8885b7fe2041:0.0000000247):0.000000025,a740369c-6d93-489f-aa61-9e6135d5ebe3:0.0000000247):0.000000025,c7ffb54f-ee5d-4cf7-9a58-0e6a19e448bf:0.0000000247):0.000000025,5a8cf7bd-6a5a-4c26-8c69-ba1ec1ab444b:0.0000000247):0.000000025,8e32ac42-d8ee-4e86-b906-2b2d0d1d4118:0.0000000247):0.000000025,4b30b072-a005-4c76-a5b3-882f28ec0c42:0.0000000247):0.000000025,f91b3f00-c19b-46af-9928-5c364aaa3f4e:0.0000000247):0.000000025,2bff3c9f-0a47-44bb-94f7-95bbde9e395f:0.0000000247):0.000000025,d2d67fd7-b7fe-429f-9385-dc03d455c9eb:0.0000000247):0.000000025,131cad40-6b31-4a8a-be34-4059a6a6d230:0.0000000247):0.000000025,b93c8295-e413-4469-b33d-6da091bb2160:0.0000000247):0.000000025,e3b5aa5a-1aa1-45d2-95e7-bc724c7b933b:0.0000000247):0.000000025,7a6ab6d7-2f18-4c5d-a48d-8f7eee81e28f:0.0000000247):0.000000025):0.000000025,beb0d9d0-d047-498d-9e66-4d1ebdf7cbf7:0.0000000247):0.000000025,88bc49d9-f348-4ff9-bc16-566508bb3ec5:0.0000000247):0.000000025,6ebbceef-a7a1-4c90-95b1-2b0748ae4a79:0.0000000247):0.000000025,cd8c045b-e1ec-4763-a617-c8a79286cf55:0.0000000247):0.000000025,fbb45933-2ce3-408a-bb65-9cef09863878:0.0000000247):0.000000025,269f27e1-51de-4c2c-934c-1f18f6982465:0.0000000247):0.000000025,ca153cc6-c71d-4b3c-9dd4-d9142e7fd061:0.0000000247):0.000000025,303f6c21-0b3b-4d5d-bac8-3afad0eb5ad5:0.0000000247):0.000000025,b80b6eb8-3c42-49c2-a02a-629bd0e34822:0.0000000247):0.000000025,1ad77076-9ed6-4b81-935f-11840ec15908:0.0000000247):0.000000025,e2fb5450-610e-4351-9764-82ec7335669a:0.0000000247):0.000000025,cfaf42a0-b1ff-4bb8-a194-034f84c410c6:0.0000000247):0.000000025,113f3459-ed51-4101-97e8-44897f65f358:0.0000000247):0.000000025,781d1e31-7ae2-4527-ba24-e06329cac178:0.0000000247):0.000000025,cbe11525-6f9d-4020-ae1b-3e14f8fe15e3:0.0000000247):0.000000025,c1d74b88-afb7-4cac-b049-311db440c4ef:0.0000000247):0.000000025,b79431cc-ca30-437a-9834-e1296dcd487b:0.0000000247):0.000000025,e831d64e-0095-4c7d-a5a4-63c7459b74b3:0.0000000247):0.000000025,bfe20bdb-a324-42c7-b69c-368d1359d4d4:0.0000000247):0.000000025,acc29b52-468e-4c67-8bc5-edc9d136244f:0.0000000247):0.000000025,(((25b85ccc-0a93-49d5-b543-3008b906340e:0.0000000247,1aa38c2b-392b-4afc-a814-a14ff2ef532f:0.0000000247):0.000000025,(f7c81b37-17e7-497c-b8ce-4ef4bf28250d:0.0000000247,(3b9a4eb7-5506-4e5a-bca6-b16739e77612:0.0000000000,6b61bc5e-40cc-4fd4-b7b8-41ccc2fdd07e:0.0000000000):0.000000025):0.000000025):0.000001221,e51b09a8-6338-48fd-ad91-0bfc0d5d0840:0.0000000147):0.000000024):0.000000020,649e3f31-1783-4bb3-b28f-8983385b3028:0.0000000247):0.000000025,f0890608-a6e3-485b-b4d2-699241b21d18:0.0000000247):0.000000025,85ab247b-95cf-4ee9-9a4d-81b39a6b2aba:0.0000000247):0.000000023,((((((((((((((((((746bc39e-f7dd-450f-b3cc-d1e121b406e3:0.0000000247,(((((((((((((((((ce255d60-a130-4178-be7c-9378cd2cbd53:0.0000000247,((((((((((((((((((((((((((((((((((((((((((((((((((((((((9d8bdc36-4fa5-4bcd-935e-5a312999cebd:0.0000000247,(((((((((bf98bc1e-6026-47b5-bd2c-626a88392c6a:0.0000000247,(e417871d-fbda-48a7-9a67-411462e37229:0.0000000247,(2167a6a7-d68f-4783-98e2-e1373cc2be91:0.0000000247,(8d08ed69-dbcf-4fc9-91a2-0abac0990620:0.0000011245,ccfd8ef1-ca96-4ea4-bd2a-cc0d9ce0f6d4:0.0000000247):0.000000025):0.000000025):0.000000025):0.000000025,68b29bd5-31de-4433-a0e9-69f1ea946532:0.0000000247):0.000000025,492b0169-1065-4b7d-b891-87800262040c:0.0000000247):0.000000025,d51f2fe3-056c-4c62-8942-c8421e0d71f9:0.0000000247):0.000000025,250808ce-59cb-4f7b-854f-8749a3ba37c2:0.0000000247):0.000000025,714a3450-0840-4c21-88b5-2f17401e62e6:0.0000000247):0.000000025,1f0cc274-1342-41d6-bbb3-ca69ae45e1eb:0.0000000247):0.000000025,dc84434f-9d62-44b4-838c-58f0eedf2152:0.0000000247):0.000000025,834af840-b4b5-441c-802e-b3bdbda8d330:0.0000000247):0.000000025):0.000000025,56203e25-adab-47d3-9688-9b4fd33e15d3:0.0000000247):0.000000025,da0f5dad-3b64-4b9d-9baf-b96218176052:0.0000000247):0.000000025,1b6b0452-33d2-46ec-8857-29ce9449c0ee:0.0000000247):0.000000025,51fbe3ac-4e01-4e31-83f9-60c26c3b6613:0.0000000247):0.000000025,50446796-ce3a-40ac-aa89-c40d3bb98309:0.0000000247):0.000000025,11ca0b96-da1d-4c54-b7f1-2bd6febb5266:0.0000000247):0.000000025,a724a068-6b7b-4305-90a1-4583c4e6aad3:0.0000000247):0.000000025,bcc9039c-369f-4e66-ab00-fc713c1abb3d:0.0000000247):0.000000025,fe2336da-313f-4836-a646-0f0a24604210:0.0000000247):0.000000025,979d544c-0b99-4316-9e30-c456982104c8:0.0000000247):0.000000025,63875925-c4c1-4be9-b305-70da9252a89f:0.0000000247):0.000000025,408a0c58-de75-4b96-9ac1-6766f88aaf8c:0.0000000247):0.000000025,6e51b400-fa9b-4988-80ec-338fcc799e27:0.0000000247):0.000000025,5af1883f-0842-4c3a-98a4-040cdc99e6cc:0.0000000247):0.000000025,24d64c89-e305-48b8-89e1-286f73e68e74:0.0000000247):0.000000025,8fe221b7-dae8-4b13-8e35-0eee975a4b68:0.0000000247):0.000000025,ae5359d1-b4f9-4d76-94be-12f162d34224:0.0000000247):0.000000025,34a7e8dc-48db-4f07-bcdb-9767890d4c28:0.0000000247):0.000000025,b164994e-0b98-40e3-994e-27ac3a762d4d:0.0000000247):0.000000025,72fb597d-9d11-48ef-bd3b-b82bac390d25:0.0000000247):0.000000025,4de2eaf4-5c62-4665-8f51-5f78771570c9:0.0000000247):0.000000025,5338d0a3-5000-4a11-972a-1bfe9f7b0750:0.0000000247):0.000000025,c7a419c5-7833-4bc7-b5e1-bef000ee99d1:0.0000000247):0.000000025,2f677617-997b-4ecb-9de7-4ae60c7e28f4:0.0000000247):0.000000025,186dd603-5f5f-4fb8-bbb7-fc9c65efb1cb:0.0000000247):0.000000025,070cdf82-46d7-474a-a23c-0df43c2c8f5a:0.0000000247):0.000000025,9d7eeaec-875a-48c1-bb7b-e7ba70490717:0.0000000247):0.000000013,2b455b9e-6a13-4744-9097-3e587fbc5d8e:0.0000000247):0.000000025,98024fde-7b4a-4c88-a5e0-246ddd29a241:0.0000000247):0.000000025,9bbe7d32-619a-4c09-9971-b06763647fea:0.0000000247):0.000000025,747ff85f-a4c9-4aaa-b1f1-c1f1580c91be:0.0000000247):0.000000025,d2ba0f45-fa2f-4cf4-824e-2a5fea039ab4:0.0000000247):0.000000025,b3bfa7e7-c05d-4487-85fb-311ebe75639e:0.0000000247):0.000000025,01191b06-9d2f-4d86-9d8f-dbc7af6b0d02:0.0000000247):0.000000025,36913f3b-82f8-429d-ba42-b082c1eca225:0.0000000247):0.000000025,715e9e20-312a-46d8-9631-9caa4ac6068d:0.0000000247):0.000000025,8b671731-06c7-4480-84e2-3fe0a40cc2e7:0.0000000247):0.000000025,2a78c1ad-df11-48d3-8de1-0327f4c273b0:0.0000000247):0.000000025,dbf12224-ebb1-46f8-869f-e44090b806b1:0.0000000247):0.000000025,07c90ee9-a404-4639-953c-735fa43adc4a:0.0000000247):0.000000025,1be09c5e-bb39-4178-8f41-dccbfb87edae:0.0000000247):0.000000025,5066fe8d-e4f5-47e6-9ef8-87766f279385:0.0000000247):0.000000025,1fae9632-62f0-4517-9322-d0ed8b27c848:0.0000000247):0.000000025,428197ac-047a-44b6-af1b-fe7306643f77:0.0000000247):0.000000025,4c4fee84-3c27-4131-869a-ea31c5d0a567:0.0000000247):0.000000025,36c4983c-2489-4ec7-9ae4-c6d3cf918cda:0.0000000247):0.000000025,2fb80602-bae2-4ac0-8a12-175960c02494:0.0000000247):0.000000025,598c24f5-f095-4493-821f-34e6d4ae3db6:0.0000000247):0.000000025,06d13339-57ae-410e-b9dc-ba34b9049fc9:0.0000000247):0.000000025,9248b95a-f4c0-44bc-8ca6-e0fd870872ff:0.0000000247):0.000000025,e49f5c92-b595-43cd-8d6d-4d666f806950:0.0000000247):0.000000029,7aad22d3-d6b5-4045-b8a2-556173c20bfa:0.0000000247):0.000000025,facd27fd-134c-4aa9-87fa-a48774525e39:0.0000000247):0.000000025,696087f5-77e7-4266-bc2f-b2e28d60e5fb:0.0000000247):0.000000025,eb30f7c2-27b2-4917-8b52-8b360c466db4:0.0000000247):0.000000025):0.000000029,60a134a3-8b21-4660-a687-ddfc1d6c4f8c:0.0000000247):0.000000021,7aa1348a-b26f-4982-a42c-9aacaee71bb8:0.0000000247):0.000000025,52412a46-9d93-4d0b-945b-89240e2c5e97:0.0000000247):0.000000025,479616d1-c276-4a54-a07b-08a45d8a3d86:0.0000000247):0.000000025,698ac8da-76b8-4a83-89e9-0bc52225372d:0.0000000247):0.000000025,981b9e63-e139-46bc-9736-a14731d34da9:0.0000000247):0.000000025,d057e21d-2a4d-48ee-bbbe-98c7ecba2305:0.0000000247):0.000000025,0a80af99-3024-4a4c-9496-c063a0e34057:0.0000000247):0.000000025,92ed610f-44ed-4c27-8f22-a12d66172f72:0.0000000247):0.000000025,499d8f31-4b1f-499f-bc62-7243a3ad3a99:0.0000000247):0.000000025,e98577ab-584d-4d1a-afee-bec3ae260c75:0.0000000247):0.000000025,97b0d7ac-6a49-4f24-ba49-5ae454f98bfa:0.0000000247):0.000000025,2d3075c8-393c-4bd8-a3ac-8b69691203e8:0.0000000247):0.000000025,fcc042f3-bc63-465d-a025-65f456510635:0.0000000247):0.000000025,30708265-b3e5-4048-96dd-8e4eb3c2bb4b:0.0000000247):0.000000025,545b41ba-e033-4f03-85b7-f4c4bc659f0c:0.0000000247):0.000000025):0.000000025,10718890-be31-4a88-8631-fc6edbaa4e79:0.0000000247):0.000000025,9415d3fa-4595-47cc-8108-77b4290a2ccf:0.0000000247):0.000000025,63feb209-d22d-446d-af86-7d96c3abe97b:0.0000000247):0.000000025,d8459a05-0bf6-4b87-a92a-926b74bdab4f:0.0000000247):0.000000025,8fe5f272-17ed-41e6-b557-4832608b1d2d:0.0000000247):0.000000025,ffd8e146-1fb1-4611-9f24-813447e0868f:0.0000000247):0.000000025,811fe25d-0676-440d-a025-010903f2a402:0.0000000247):0.000000025,d70e0fc3-cd28-4c2b-b4cd-731fe3085626:0.0000000247):0.000000025,795dbbde-843b-4c4d-8c35-9cd587cdbd67:0.0000000247):0.000000025,46b8ec8d-be3b-490d-aea3-29e0c1b96163:0.0000000247):0.000000025,5f2f2ede-c098-46c5-9d6a-de102e912c10:0.0000000247):0.000000025,b5491cb8-fa68-4de4-b749-a088e187cecc:0.0000000247):0.000000025,31fd2230-467b-44bf-a0b3-8e1d4f955412:0.0000000247):0.000000025,24acebb9-7dd7-4785-9e57-9017b33437db:0.0000000247):0.000000025,d7e4c868-37e3-4d90-8dde-8d4e52caef8e:0.0000000247):0.000000020,f515c200-2a49-48b7-a770-9580af0e2834:0.0000000247):0.000000020,b5e52c2d-cdfd-45f5-9d6b-641f5ece04fe:0.0000000247):0.000000025);"
        largeTreeText="""((ffb41874-4aeb-4e46-b056-d506c28cdaaa:0,(ff84b194-2d77-4ce5-81c9-8c123a5b6886:0,(((((((((((((((((((((((((((((ff6788c4-afa0-4a5e-9fb0-2df4fb341365:0,(feccbe03-4a1d-4408-a90c-010dc2fe7a62:0,((((((((((((((fd672f18-adef-4047-80a5-0593fcfa0ad7:0,(f5a9ee34-194c-43a7-b295-395dc65026d1:0,((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((f58992a0-67ea-4b39-98b6-83048012bacf:0,(d7a8f474-77ee-4673-87bc-12d34d43ceeb:0,((((cb1d7e53-92a1-4255-969b-4378f4470d59:0,(c4609696-5244-4543-b2f9-2a143e0b883b:0,a4db7e1d-7b58-48e0-bb5b-1d468d744d55:0):0):6.44565e-07,c9b1101e-a97d-4394-a7ec-0cfb1593788a:0):3.20331e-07,a1199666-6767-46b0-aeae-06160bf4f3e8:0):1.60605e-07,a55a21ca-adc2-4f28-a42c-c50f33d9368a:0):8.03576e-08):4.0206e-08):2.01345e-08,c76546ca-0a04-45bf-b918-74488cc654ab:0):1.00695e-08,052ab4a7-484d-4f77-aa75-48a61a6ee554:0):5.0368e-09,0a61ae86-214b-4a82-b46a-626d35ff0692:0):2.51976e-09,10be06af-fe82-4fd0-9ad5-3154cd890e44:0):6.06139e-10,((((((((e8d33126-3d40-4df1-9598-472be6ad6bc6:0,((dbe090ee-d209-42e5-bb87-c63d34cc326f:0,(d3440ec2-a5bb-4c09-afee-2c10c6c28ba1:0,(ba0fba67-2d96-4d0e-902d-4de5078a060d:0,(992f060f-2a68-45bd-8c08-221a4dbd4c94:0,(6f974b1a-572c-4640-847c-9711e2444349:0,(694de116-f249-4733-afa4-11353d7d7984:0,(43e33f4c-e50b-48c9-b5fa-c4310775f9b1:0,(28bda08b-229b-4f6c-8491-736e03f0010c:0,(0bf3455e-cd5c-4ddd-bc25-7889632903b0:0,(054a1db2-138b-4af8-a73d-761026f8a470:0,0397cddc-26ef-47f1-9227-4c8e7440443e:0):0):0):0):0):0):0):0):0):0):1.41447e-10,89163447-1439-4641-931b-a2676b576939:0):9.02181e-11):1.60184e-07,e55ed4a1-0ecd-4d22-9146-7f63b18259db:0):8.0178e-08,05d5f6b2-8e3f-4dc6-9836-ef8e4ea1c73f:0):4.00913e-08,3a2db685-dba6-4064-863f-790304e075e5:0):2.00583e-08,008e5b58-1905-4fee-bbdc-b1315903636c:0):1.00373e-08,009af140-3632-4966-9ddc-e2287ccc9f25:0):5.02365e-09,024ca4dc-175f-417b-8610-d0a3b567d0b3:0):2.51477e-09,00f68707-6213-4328-a09a-0a254c05e1b3:0):6.04325e-10):6.61902e-10,1ec06ccd-15a0-4e02-baff-b3d705f7c81d:0):6.13166e-10,23279725-670f-484d-8807-ee6ad44dafcb:0):6.15432e-10,2993a650-ba49-4d8c-bf55-b5455563f750:0):6.19059e-10,304f5a53-5d4f-43ef-8fd3-18274dfc0bb7:0):6.20193e-10,47dd7c6f-50da-4070-a224-ac892f1aa665:0):6.20873e-10,4e19bde6-d072-49af-9393-5907b75bf793:0):6.21553e-10,530ad688-1f88-4fb7-8634-da8564bbbbd2:0):6.22459e-10,554fe668-1bb3-42bf-ac8b-d54a61bce644:0):6.22686e-10,6e17fd4a-b7f0-4ec4-bb90-ec9884d6b51e:0):6.23593e-10,73c70704-91a6-476f-ae24-925418078b9a:0):6.24273e-10,760b6e11-73b0-4774-9685-1af267c38ddb:0):6.23366e-10,9caf630b-78ee-4464-b5bf-f55b8d66890f:0):6.24273e-10,a165564c-2064-4a91-b059-b4c74fed3a9d:0):6.2518e-10,a7af7886-53ad-4bf3-9b90-44886765f398:0):6.2586e-10,a8f76999-cf27-49be-8062-eeff46114345:0):6.26993e-10,a9bb14c1-f184-4802-bb51-279d5daf2b03:0):6.279e-10,ac5e8077-d7be-4b0b-a922-4e71aa832382:0):6.28807e-10,af59bb39-03c9-460a-a0c0-682bf22ff6f0:0):6.29713e-10,c0e386ea-df69-4bdc-940d-96c167e3761c:0):6.30167e-10,d28b2ea9-3d1c-431e-a6be-a324f5af1b95:0):6.313e-10,d92c6328-c22a-4691-9e7b-15867636fe80:0):6.31527e-10,e5284c37-d0d9-4c95-8dbc-a8828ca2342e:0):6.32207e-10,e5a8c34f-0ac7-46a9-975c-f9688e7f5b52:0):6.3334e-10,e71c0d84-592e-4dd0-b896-1a5612999788:0):6.34247e-10,eb74261c-9dfa-484e-b6cb-d142a3bc21d0:0):6.35154e-10,ec282198-f04a-4893-8674-c4e536cf15f7:0):6.35834e-10,ecbe16af-b6ef-41bd-87bc-9b9656efff0a:0):6.3674e-10,f3008347-964e-40d0-9037-685f35539ce7:0):7.97229e-10,bccb19a5-0998-4a21-b83d-e4750524364c:0):7.61867e-10,be3b858d-64f3-4970-9bde-7cdbb55d8d0a:0):5.51736e-10,07203ed7-1b82-4824-8222-703f2d650813:0):5.39268e-10,09c28cc9-c18a-4631-bb28-19e15c099ef6:0):5.39948e-10,114381b7-836f-4aff-9696-ad04648a046a:0):5.40402e-10,151b2e37-d5bd-479b-9471-8c3ad5b1c51a:0):5.40402e-10,1a3880cf-960b-44f7-8342-02f48dc3468a:0):5.39495e-10,20c6add7-19b7-40fa-8421-0c3f1a3c87fb:0):5.41989e-10,33ab7354-d6f5-4237-b796-e9af6ba094f9:0):5.40855e-10,350f57d8-7953-4680-9891-589895f73b21:0):5.41762e-10,3fbea978-e670-4c30-b8e5-b8d7519af408:0):5.42215e-10,4017128d-ca36-43d5-818b-00489416c589:0):5.43122e-10,52d03c49-cee7-40e9-8565-76595e3e9502:0):5.44029e-10,535c2e92-e808-41da-8067-566d582857fe:0):5.44709e-10,565adc90-0745-4aad-89bf-5e6a68f12272:0):5.45389e-10,6dbf82a7-b203-4ccd-bfa0-b699d2d5a01a:0):5.46069e-10,7619a892-9761-4b3a-94a0-6ad6b5cbc1b5:0):5.47202e-10,7b52df1e-05a3-44f5-9686-33cc5cbe47a2:0):5.47656e-10,82ee25a5-c2de-47fd-ab6c-b6cf7a44e458:0):5.48336e-10,8533a5f9-60c9-44d0-92eb-40d3a89c522d:0):5.48562e-10,9e2d3599-6ec4-4f31-9bbe-2d5c32154e59:0):5.49469e-10,9f460962-4dae-495b-95b2-f04fe2aff361:0):5.50149e-10,c3e860b0-ab10-47b0-9ce0-f28cc14c45de:0):5.50829e-10,c6d5721f-c2fe-4251-a47c-4f3acd0e55d7:0):5.51736e-10,d261733f-1233-4921-8dbc-da97c93e7a79:0):5.52189e-10,da587e2b-7c9d-42c0-9119-b6e0fa827949:0):5.53096e-10,e1bc8175-9db2-491a-870e-020cf8a240fc:0):5.53323e-10,f3f0cf8b-29ec-40bb-8894-be77b7de9b98:0):5.44255e-10):5.55363e-10):7.21518e-10,09f0d2f2-b051-485d-9f5f-504b02e29fa4:0):6.03645e-10,1fc0a92a-1f61-46c2-b35f-49523e71d48f:0):6.12032e-10,9fbb495d-0f93-4e56-9fc7-61681ef38c5b:0):4.46784e-10,02cc4c5c-26fb-4ad5-b09c-8164735b58b1:0):1.04045e-10,((((((((((((((((((fb2ff8bf-2f67-4fba-a1cf-6866a0dd13b3:0,(e7305d74-72f8-4a4e-a6bf-ba82eb25fded:0,(((ac844dc9-ec3f-4036-a22f-520d096b8fc8:0,(946842ee-3d88-430d-9713-77603aadcad6:0,(8e872d11-d568-4ef1-b1fd-da5d050a7c5b:0,(89fa5fb6-e6cb-484c-abd9-63bee6c8eac4:0,(70d1c8a0-ce16-4e42-a135-b76b3f841f3f:0,(528a5ccf-956c-47f4-9c9c-512bf4799ea9:0,(4c648735-81cc-4bd1-ba3a-4fb2eb0148f7:0,(43b1030e-c77e-4331-981f-e5fdadbed989:0,(382dc1d3-60d7-4b80-a451-847b3b129c7f:0,(2ccdf7ad-37f8-4002-9ce0-b26db1d59c20:3.9525e-07,0aec2174-fc0c-431a-963a-1d1c10a5a20a:0):1.9766e-07):9.88963e-08):4.94812e-08):2.47547e-08):1.23857e-08):6.19694e-09):3.10051e-09):1.55139e-09):7.75921e-10):2.02424e-10,088ee36b-9f5e-4932-9ce3-29a49a7f3185:0):0,(9df5cb7e-bd4f-47da-9a7f-a10b4d5a8f87:0,(83399852-6330-45f6-86e3-7ac47a21be0a:0,(70916a3b-772a-4c09-91ca-ededc028ca92:0,(69a7e788-148d-45dc-98d3-4f7a5093459f:0,(656afadb-51e9-4883-a88b-53da8dde61a7:0,566a7d1b-7951-4166-ae8e-8935350aa64c:0):0):0):0):0):0):0):0):1.53688e-10,01a91df4-307a-4644-8e02-90f23fdb5c1e:0):7.70707e-11,d659d01c-826a-496e-ba3d-dc453629de59:0):3.85354e-11,f3e6c338-dd78-4583-b526-6f0351da0851:0):1.86965e-09,5ea70d08-7972-40d0-9e54-5d643018627d:0):1.54732e-07,177006a4-bd61-4784-8f29-0559bc060729:0):7.75731e-08,b276bb56-b6eb-4765-a585-5601b1aa9585:0):3.89556e-08,1c19dfb1-17ad-4092-9b30-ac6e17502626:0):1.94912e-08,a613f7e2-0817-425a-8276-0734478f6c67:0):9.75217e-09,acfc8e26-d3cc-440f-b9f6-c16a304f26c4:0):1.60792e-07,0b0d56e4-d0d6-406d-b266-27c5365fa637:0):8.05271e-08,12dc5789-561d-4309-aca1-5df649f09038:0):4.0327e-08,1740732f-b7a6-4c22-9a55-d1479b2e3ed2:0):2.01993e-08,1ddc1ce0-c62c-4d1d-b963-fbcd8ed7b275:0):1.01185e-08,2041b311-e7fc-4f76-a420-325cd1b5b364:0):5.06944e-09,60535aaa-c1c0-4511-8451-425967a7ebf6:0):2.52429e-09,6b373f06-74ae-46be-bac3-4cd93d46ae29:0):1.25127e-09,77596db1-d600-4279-9ef6-28b89bdb3d56:0):3.16897e-10):3.24604e-10,02ee2a96-f233-46f0-b091-01e602b92c44:0):1.61849e-10,03bdb156-0cb3-4616-b0d2-2b7a551019b8:0):9.74718e-11,04c9b9fa-bac1-4c51-9750-6cb6b784efbc:0):4.85092e-11,05b6c7ac-eedb-4677-ab71-44398f2dc36a:0):1.22406e-11,0682496d-efd2-49a0-b196-6930e8313434:0):3.1735e-12,079a3bd4-c875-4ab8-9679-7f2e387b17b1:0):9.06714e-13,08c60e1b-d583-4366-b9cf-4460b7f588b4:0):0,(fd03d759-29c8-4b68-a331-d64998da4d5c:0,(fc8dd81b-2d5d-4888-901a-0778d7ce41f2:0,(fbf06e6a-6ff8-418a-9d27-ddcd78b2a940:0,(f9879c61-d1b3-4583-8dc7-f7a4e9ce88b3:0,(f92f6cf5-a79d-41a5-9d83-e2dd9d97d16d:0,(f91ec9d6-9e7b-4c4a-9787-c57a13e69c4e:0,(f8500eac-c970-4da9-9511-b3a3203b8366:0,(f7fd96f2-bc8a-42ce-bf1b-5849c8d13cd9:0,(f7e252cd-5f5b-4c72-b77c-c3337f0ae6c5:0,(f782ee0a-352f-40aa-8d76-9b588116cd69:0,(f6d09b13-0827-4e4e-91b7-4d640343383d:0,(f665eaeb-1fc6-4606-986c-09db79546b09:0,(f5ec50f7-b74a-4161-bad5-1eedb76c616b:0,(f494838b-db6e-443f-b93b-63fa7b1dd8f4:0,(f4601c94-3852-4857-98a2-c514b9fe96eb:0,(f3d8e9b1-fe5d-4479-8802-9f8225af9fa8:0,(f314b4d8-75bf-4960-a6ea-0cccf67e9ee0:0,(f30859be-4205-4456-8ff5-10edded6003a:0,(f2e55865-2c55-4f02-8525-8b4576beb5b3:0,(f211e4c2-ea0b-4036-96bb-ea2bc141e301:0,(f073c5f7-4652-4d81-ad52-953ce3795737:0,(ef2ca0bb-8289-4abe-bea1-4ca6083d367c:0,(edc18112-85ae-45a5-849d-eea378ba6b1a:0,(ed6b093e-feae-474f-96af-c7bd6606b2b2:0,(ed4a26cc-4500-46f6-82ba-ba61b796b059:0,(ed1d06e1-6e0b-4066-b4dc-5ab0c65dbe53:0,(ecef222e-1d7e-4528-a8c4-fcb060edcdca:0,(ecc1ecd0-c644-4b38-adc5-56863ccaf372:0,(ec82d89d-deec-46f7-9a00-a043e8829d7b:0,(ec0d9561-4763-4a61-9477-3bd343626716:0,(ebe154db-e0fe-4575-b1c5-f645a31a8daf:0,(ead99bdc-2b4d-427f-aa1d-8736162ab44e:0,(e9f056c2-6e65-4d6e-b244-fe0933505517:0,(e933ead7-1240-407b-9823-2a5646be44ca:0,(e8297bda-038d-420d-877a-b5feee135881:0,(e7d3e959-6b8f-49e9-81ff-bc6c2bf2d7d3:0,(e6feb18e-3a11-4a18-b95d-9aa0b3d84c26:0,(e67618a4-abf8-4d94-afd5-d6d7dab1b7cf:0,(e4f485eb-f389-4bf6-9aed-ac828de7869a:0,(e39c862e-e074-42b5-acd6-efb9edb8e3bf:0,(e2b5c7ff-f854-4f52-ab35-74a221f8bee0:0,(e29875b1-732f-4cf6-91d0-5a1ba213d590:0,(e179e755-08fc-491a-9a85-90cf8f503756:0,(e13b432a-e741-4c2b-bcfe-3010715328d9:0,(dd8bfe3c-0acf-440f-92ca-7f88980a158e:0,(dd50ae25-bd97-472f-ae68-2a45850e52a1:0,(dcc503b4-16e2-40fb-b293-811f95f75cf0:0,(dca59ff9-9904-41b6-8fd4-2411874143c8:0,(dc56f740-e5f9-4aec-b0c3-1b9a7c1137ab:0,(dc3ae070-fd46-48cb-9b3d-38ea7fd1f321:0,(db656f85-98e7-4b24-bce7-cd49de25739c:0,(db43adc9-7091-4a07-bb49-9c1da47a667c:0,(dadf81ad-0b65-465d-a796-9d002bd1f6e6:0,(d991c892-0d6d-4f76-931c-4a7b842ef905:0,(d94ae9c2-a1e8-407c-8278-e081f893cf1c:0,(d7f425d6-bbbe-43df-a7e9-17fcfcba159c:0,(d74f1097-1e09-4175-87bb-3bf4a4fe3e1e:0,(d6749bdc-5e85-480f-aea3-f85f5a02c228:0,(d5a1d5df-a58c-444a-b107-6df86571957d:0,(d3b85caa-081f-4969-b731-92d50703f839:0,(d33130bf-74e1-488b-bb35-1c4dc0b3a01e:0,(d0b4b862-2183-4204-9f87-dfda6c831b62:0,(d099497c-a700-4ed7-b2c0-b02e4467b5eb:0,(d011a294-75b4-48c4-b5eb-95fa1aa419e3:0,(cdd19cd9-b3ec-495f-b18e-db461c77aa9b:0,(cd9ad8e4-f136-41b7-8dc2-df9e7eaab44d:0,(cc47765f-4afe-48e9-9d4f-69903c107ab9:0,(cc100013-4278-431a-bdb8-1d7103d063f2:0,(cb865eeb-89ed-4ac6-bfd0-fca152ae8b06:0,(cb5a5788-18bd-4c8d-8d4d-97b11c2fc33b:0,(ca57bf32-5a90-45d3-ac2e-c29993a771df:0,(c88cfb80-9f0c-4116-8706-c8986da49819:0,(c7dc80d6-5c73-4f8e-a3e0-a08fb9898ef4:0,(c5e9d1ca-d2a5-40ae-a556-99cd35b33da4:0,(c559823b-2aec-4fb6-8c2e-fb1c0f7c79b9:0,(c4fcb2e8-c6e3-46ce-8a33-bc5b91e8385e:0,(c4daa8c3-1f4a-410d-8481-cdd908e141a7:0,(c4b9cb44-ad2d-4c8b-8bd7-5e3dfeed9b74:0,(c1c78fb2-c580-43a3-a0f2-b066f1a428c5:0,(c1846aac-3626-41d8-ad53-331a9c1c4a3d:0,(c1063803-a697-411f-b3e8-a2d2c1c2b090:0,(c0a8252f-3d35-4e68-898a-9e72e1d2713d:0,(c0a33101-ba51-4878-92b4-7182150710b9:0,(bfbe5524-76d0-4bd9-b0a4-835fb5da0910:0,(bf062311-5e07-43c1-8063-4dc44cf14121:0,(bd576f71-950f-4f2a-a9dd-3d2cee0a85f1:0,(bcfef884-b056-49be-b5ec-a80b164f24a0:0,(bca7c1ea-60eb-4d1b-9822-4b47bc35ef87:0,(bc16fe6b-dc26-4a59-a49a-ea25bca3a857:0,(bbfa595c-b1fe-4727-8a47-ee573d737adc:0,(bbd37eeb-59bb-42ab-aad3-3b1179e505d1:0,(bb60076d-6160-4497-b7f3-506e55496f51:0,(ba0fd607-bcdb-4920-8221-a8dfbbd4dd2b:0,(ba075539-c36d-4ac4-ac33-38fb81d2f0f7:0,(b9cc5efd-4e9d-4e29-bdf0-31c0655e2bef:0,(b907b17b-bd61-4cc3-b1c8-2722a1ad09e5:0,(b789b0b8-7717-4572-9ec0-21d609c2deb6:0,(b747ec21-315b-4428-b3c6-a2203a3dddd3:0,(b7135e0e-3e1e-4e19-82ce-915474daf0e8:0,(b6db9772-abe7-453b-9fd1-6a9fcada1fa6:0,(b6bc33db-a777-433b-b4d2-b33b90b0a072:0,(b3f1b96f-30fc-4c1c-950c-2028cf594430:0,(b3f0e99c-4e2b-4106-b7be-9c5148ef2753:0,(b3b2fb2c-3862-4f54-997d-8976f169c39c:0,(b05b1226-06bb-4f08-b737-0fb0cf6b93d2:0,(af90aeff-9926-4e16-88d3-f22cb8be74bd:0,(af109d81-27e1-4e72-8b78-839498325013:0,(aea7dd43-401f-48aa-8ceb-5248b9e9205f:0,(ad559ce8-a6e2-4fb2-98a8-0033055a63d2:0,(ac588029-3818-48c3-ab93-1877fdfe255e:0,(ac1f11b9-c8ef-4829-aa72-4d445b2d6c9c:0,(abc3f965-5e9d-4780-9773-9801b1692218:0,(ab327b68-e589-41df-9651-99dc9ba6c771:0,(a9954f93-9aa1-4e02-857f-f8ae30d6de5a:0,(a9079e6c-dd3d-44a9-88d5-0fd90a385293:0,(a812d2bb-2265-4dbb-ae24-b88dcb182167:0,(a7a06e22-bb5f-4e05-98c6-3e40496b03bd:0,(a4e2c6d8-cb8a-4269-94f1-31884d57f001:0,(a39a4d9f-bd98-487d-ba5d-1c0f5cfd3821:0,(a36f38ca-76d8-4c1a-8585-f3ab8e20a551:0,(a36e28f3-981e-43ca-b0ed-971e03b0a713:0,(a33342b1-2a9b-48d9-88eb-7b3323b64998:0,(a1d055cf-3fe4-4f4d-9a05-d911fe99583d:0,(9f154237-4a4b-4bef-9920-8f558ec79692:0,(9f139358-5e69-49cb-bbec-140c04cb4de6:0,(9ec350f6-c1f0-45c3-9fdc-8abd8bdfebb0:0,(9eb0b1c2-fbec-4c08-954b-e64dd66a0d4e:0,(9e97d27a-886c-439b-ad76-edaadeec9d1a:0,(9ca2cb57-c285-4e15-9f6a-f5aa65a6d9e4:0,(9c09a996-6021-4b2c-9229-aa39961e0532:0,(9b09f107-d2cc-407d-9f0a-b9dd9abc4ff9:0,(99bdbd1c-4f0e-4979-a8af-e42e4c705fc5:0,(990b749b-ae5b-4c4e-965b-33009eb93881:0,(98883fab-9ea8-4347-92d0-f5f9178aee28:0,(97709dd3-a0e3-4220-a68a-3d248d99ba5b:0,(9757ef89-6cf8-4afe-986d-5a03091e0cf2:0,(96d0c929-c37b-47e6-96d2-17b98e8329c3:0,(943948aa-1f3f-4055-a211-88eba299d377:0,(932c352c-6311-4ebe-82f5-7292325db023:0,(92785b13-a434-4bac-ae4e-e481410d0f58:0,(91c1698b-d8ab-443c-b6f2-1758ceafe003:0,(91bff33f-5ca3-4a7e-9ec2-05fceed0f10d:0,(90b0c2b9-bf69-439f-ab56-2bd9d2a83cf7:0,(9088e0f2-78d1-4561-9940-4eec7679b5e3:0,(8f6df8c1-2487-4522-8749-830b49dc9843:0,(8e8aafbb-f86a-4c1f-b170-221802e5074e:0,(8deaa443-0613-4913-af45-f1a45c6140dc:0,(8d19e578-0930-4c4e-902e-e98ab17a2b5c:0,(8c17db82-bc3f-40cc-bbd2-f6111a48bd5a:0,(8becefbf-1612-421d-9d6d-939f0d998815:0,(8ae5fe8f-ee67-4cff-a67a-dbc358a091f0:0,(89d438c6-1342-4f28-adc0-7cde4d25ab2d:0,(8736664d-87a3-4f1c-9738-1a6aabbf260a:0,(86f68aa8-1775-4cc7-8950-4dbc2d882757:0,(86dc6b9d-f26c-41f3-a4da-4624709a7fd7:0,(8599a709-02fa-40a2-a03e-8c63171c448d:0,(836e4754-27cd-4c06-8d18-e64cec39bfdf:0,(835c71f5-5098-45aa-81b0-cc382437b84d:0,(834f3b1f-f793-41aa-aa67-2885ebf692dc:0,(832c7e15-11be-46ee-94a4-edbf1993d021:0,(83150090-ab6e-4552-b2cd-3b72938752c1:0,(82648b82-c0fb-40db-bea3-5a0a828c9cba:0,(822d9530-80b0-41b4-870c-b65c6073b331:0,(81047d73-0a62-4b6d-afdc-0602ba6d1245:0,(80eb782b-88be-40e3-8a25-c5c8357ab499:0,(802e67aa-1d15-409b-aaba-c9efd33506d1:0,(7fd9d02f-26ee-4bd5-96a1-39eb3acc4d83:0,(7fa96b33-73b4-43f2-af13-d8ff2b5bf335:0,(7e791aa6-ab8d-456c-8741-60abdb9ccdf3:0,(7d48206c-4132-43d1-98fe-3bdd7487d7ab:0,(7d47814b-fd74-4d87-8e70-05d26ff54252:0,(7cb6fbea-b7a8-4723-b25b-47cf219f7d51:0,(7c8c4cde-f0c9-4767-80a6-d1a23c0b3c61:0,(7c42c0e1-9678-4a5d-ae8a-4cd9f3e85b5f:0,(7b0c1dee-2e4a-43b1-937b-4178d1409a80:0,(79ffe6c6-f697-43cc-8d3b-5c49086d914c:0,(792a9a84-0ad0-43c1-b277-61843a394395:0,(785bb3fc-9ceb-4028-946e-97cf4554a235:0,(7583347c-ab6c-47ba-b5e4-57a01126bfa8:0,(750f3539-762e-4b93-a289-4991235c7b94:0,(74c8ec7c-8f0b-4deb-b11e-ea9672d657dd:0,(7456f711-12b9-46c9-8094-e874ba10b8fa:0,(73aff78a-dc28-4089-99c4-23d2050c526c:0,(73a449e4-4bcc-468a-b0f6-d9e84cb8b477:0,(725e5f5f-aa69-43a0-89a3-9a80c5ad022a:0,(715e9b5b-231e-43e5-a0bc-3cabf8680efe:0,(70e58bcb-498d-42d3-9ab0-2c1edde339f4:0,(70ba92ef-5209-4319-95be-1b8f430cfe28:0,(6d0cc0bd-f2ce-4f03-916c-85d94f41152f:0,(6ca159be-efdf-4dc4-9090-9df0e7524edc:0,(6c6ba0a4-7c9e-47b9-8318-aa711e626b34:0,(6b6e7189-7f8a-468b-b170-5838fe37668d:0,(6b499a78-12cc-469e-8b81-5b2703704a0e:0,(6b0b807a-79ee-46dd-b6ec-8cfa7976080e:0,(69b18ee9-171b-4162-967e-085ca249cc37:0,(68815215-ab81-4f26-a1f1-6f04dacfc4b1:0,(687cc71a-7a10-4b72-865f-fd8c20b696dd:0,(66b98302-c820-4a7e-9235-89cb83b51b8a:0,(658aa5ac-210c-4016-b144-ebadc1350a6b:0,(6499ce22-2850-463d-b5a7-b46b1082300d:0,(6447ebd3-488a-43b0-8664-3abc06714cef:0,(6445160e-0aff-40bd-9e53-d5fac7c8384a:0,(6427489a-1276-4af6-98be-78b986cdf502:0,(6405ab0b-aa49-4dab-8bc3-98dc51d58b77:0,(632f6adc-4642-4674-bdb9-0414cc2abc01:0,(61ef598c-a268-4560-9455-9eb650234f6a:0,(60df0e70-4cec-4199-9f3a-5e47ad94f2e2:0,(5f63722e-ebe3-4206-8f62-597cea999368:0,(5efccfe7-a82b-4b1c-8868-ff5f203444a2:0,(5eb40381-5610-48e8-adb9-8728926e56f3:0,(5dc2a09f-f9e0-41ca-a954-b939d02544cd:0,(5c9d919c-a95a-46d0-a919-7e5b3d3ee6ea:0,(5c397511-1866-46a6-9a18-c8b4af0841b1:0,(5b2f7cb5-4635-40a1-98cf-9e6baa14ae90:0,(5b2c6c85-50e8-4135-a2c1-28f1ed34302f:0,(594e7129-70da-438e-8584-e8f9a8b3a2b7:0,(585ac4cc-bdd5-4286-9f90-ef747c2fcd64:0,(57b9257d-44f9-4c2f-a16b-cdfacca8362b:0,(56a6d5bf-891f-44de-ba66-3c7bc7abff36:0,(555aa581-74ce-45b6-9701-b870fb089abf:0,(54392078-0953-442e-a2eb-9b879b229c43:0,(52c88763-8111-444d-afd3-6963e8807419:0,(52683303-cc54-41f4-8e50-b09f5a724dda:0,(510e235f-1a69-4941-adcc-2e605de26d5e:0,(50063541-4c33-44dc-8b89-b62b732a6564:0,(4fa1b552-c35c-4cd8-a51a-c483c69e1432:0,(4f9c12fe-ce9d-42c8-b209-0cb7bba9d4e0:0,(4df7eb0d-192f-456c-9262-fa495760849c:0,(4d2db49e-4410-4ce7-9032-6b32453325a4:0,(4d14fd33-3682-470f-9a59-33e5e86e8a93:0,(4b42ab02-f072-4c2f-a68b-e44fda4a20a3:0,(4b2183b7-28e0-4ea7-a7a6-1a88964ec1da:0,(49c6b451-4b59-44e2-9af7-712e4db8eafd:0,(48e84183-a3c2-4e7a-884d-3047dc3fa7bc:0,(4783b558-656f-4bc0-a84c-27151ab837f1:0,(47493ea5-cdc6-4a15-be19-7cbc53f2eea7:0,(470e4488-adcd-470b-b271-5800696b4f6e:0,(45917f37-81d1-4cf1-b4bb-cc5b7b45539f:0,(45798832-d7b9-49f6-9313-2aadc7e49c61:0,(45263840-fdfe-44b2-8726-35469894b20b:0,(43f3b923-50cd-44a1-a24f-c9d5ec922efd:0,(42e15662-d675-465b-abe5-2deed4b3842b:0,(4231b05c-1f2e-4855-8632-a8b826757e7e:0,(41abe26d-db51-49c4-b88a-861eaae4bb65:0,(418a4e6a-c0c3-4f2a-81ad-1024bbdab890:0,(4155bb41-da8d-43eb-a55d-303f3298c15a:0,(3fe60d4f-a5d5-483d-8df0-f79a5c4224e3:0,(3fa77693-c773-46d0-90d9-aabad8f25eab:0,(3f8ea32d-088a-48a6-b2e7-6cff44537430:0,(3eccad1a-46c9-4008-94f5-4c9edb9e8cfe:0,(3d7c3bc5-f016-4a67-a801-56a6d8eec112:0,(3cf98273-e13d-4503-8d28-54224fad798f:0,(39777b7c-20b8-4665-bc19-1bf99b0d227e:0,(3949dfc3-bb35-48a5-bbc6-7c8853f53d2a:0,(385e8688-767d-4835-8163-50013980d47c:0,(36b4914b-5038-4a77-861c-efd73dfbb3d2:0,(36240a94-63cb-4fc8-8003-70e888f0be72:0,(35e925b5-f773-4d08-b6ba-400382444918:0,(35e0daf8-1d06-4405-ae70-165807544e00:0,(352bad07-2ab6-4cdc-9f96-d383168a9a2c:0,(3517fd28-008c-49a2-9212-a2558215f431:0,(349465b1-b466-4568-8f0b-066a87371917:0,(342ef56b-f46f-4878-8b2d-75fe4259c655:0,(33eb790f-0106-4717-80c0-eec422abd59b:0,(33b426bc-5904-416a-a6d5-c189e97af64e:0,(33412b6e-4c75-4367-8a16-ff814ad0ab53:0,(3187d0f7-af94-47c8-ac5c-4d2de8f45dcd:0,(30751acd-c852-47a8-94bd-309ace326fe3:0,(302c1bad-cf54-47d1-93f8-a0622287718e:0,(2fa17788-cbae-40bc-ab54-3f651f394947:0,(2f8ed25a-159b-4342-ae2b-4f66df758176:0,(2eb9ee22-f2d2-4577-88ce-9c51a8743cea:0,(2e9b072f-d37f-42e3-a88b-28f329c1e9c7:0,(2e3be85e-487f-4100-a6a7-bb6f10c59944:0,(2e338457-491a-4586-ade1-7a2d70e6e5b6:0,(2ccab418-00a4-440c-997e-06f889e15760:0,(2bd5311d-9fe4-47e0-b810-6d413e668095:0,(2bcf0b45-04d6-4a4b-9404-8ea72e0e558b:0,(2a613717-1c17-42f6-b759-ee04e9c86a81:0,(29ba8996-7a6b-4cb4-bc53-134c0c212dd5:0,(29a45d37-d2b1-4b82-b904-b268f4c6f9c1:0,(2981d09c-2a63-4197-ad75-d54c7b9c4f61:0,(2796e668-9170-4cf1-a9a1-2e4e26b6aeaa:0,(25d5d685-7ede-4b9b-beef-fe8e16632450:0,(25345097-9e2f-41d2-90ba-65444ebd3347:0,(24d7f6d9-b1bc-45ba-9713-9fa1183f34c4:0,(23ab50d8-2113-4bc8-979d-5f96bb27c798:0,(23796780-5d59-4222-a041-133f8805eb89:0,(2233caa6-0cad-43eb-96f2-66cec65c7f3d:0,(207e7c54-6159-43b6-b1b0-63c0b3044928:0,(1edaee25-5c9b-4436-914a-9afaf707b813:0,(1daef941-b46f-41b6-bac5-12ac753c928c:0,(1d5ab9b7-ea9b-4d3e-b997-d555b0522548:0,(1d1e9944-d2d1-4e42-93bc-cacd0362535a:0,(1ccc1dac-c30b-4090-94c3-b81fa1a03e36:0,(1cc84ba6-0fa0-4a40-9962-77dded2bb707:0,(1c0406ed-6e77-46a7-92bb-5d4c41fa5389:0,(1b94ede0-7f19-4a76-8e08-ffc031ea6180:0,(1ae8a58e-7e09-4820-b90d-021123d0710e:0,(1aa19224-9e8d-4762-ab71-671b2f609524:0,(1a99e364-6311-448e-b17b-8be18db12005:0,(196ef291-a592-4921-b48d-a9e0aa23cd39:0,(190f8865-26d4-4ada-8c12-93f967f1129a:0,(18a6bf2e-c96d-4d93-88b8-c60e764caa89:0,(1897ce93-715a-4cad-90c4-e6044d28e755:0,(184dc5d2-0bbd-418c-9e34-a869ecab5702:0,(18429941-bc86-4fdc-b2db-145c3ea8621a:0,(177081ce-a844-4368-9846-46af5323868e:0,(163699fb-933d-448b-96b3-56ba9d9679c2:0,(14de8590-03f2-4cd5-8658-649c84c180ec:0,(110948f4-65f4-4446-ad5d-af1a191328ed:0,(1022a2a2-1680-480a-aa09-b8bb58cb6801:0,(0f759136-5e48-4409-90d0-947d0fc6185c:0,(0efd996b-394e-4e4a-bcf7-5ac84f92eec5:0,(0e4f994b-3345-4dda-8be5-1e0b926c9a52:0,(0e34799e-417a-49d7-b9b2-f04bfda802c5:0,(0dab4f8d-cb67-42f9-ace3-671c0e67e70e:0,(0cd7c272-87ea-4942-bb81-537445d8ec7a:0,(0b3756dc-e0fd-41df-94b2-a932fb587bf9:0,0ae8f66d-205e-4525-b02e-5c1d04558d67:0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):-0):0):0):4.4429e-11,11780721-7c25-4da6-ac3e-7cf480af7eba:0):2.22145e-11,1e7bac56-019a-437c-b859-fc30d57ee196:0):1.13339e-11,cd2de1af-9fc4-4204-9824-7a333cf9b00e:0):5.44029e-12,f22a96b7-62fe-4c1b-ac5f-dc697ff8625a:0):6.57368e-12,((9f1c2399-0b08-4969-a944-b81d951e3ece:2.26683e-07,2421c9b8-3f13-4a67-8c0e-b8cafdc12b95:0):1.13341e-07,60be14a3-383e-4c2b-9686-647e12b938fc:0):5.66631e-08):1.78623e-10,04848cd7-6aac-4a85-b68e-999ddde2ada7:0):8.8178e-11,(fd7655b7-2c10-4531-ab0b-f6be29fe6da0:0,(fa0a2fc9-f1d0-4cf5-b165-22d6b0d2809c:0,(f8e5b1df-f418-42a0-91bf-383fce2e723c:0,(dae5d6f7-6d2b-45fc-a836-c9bbc2d54778:0,(d89b1cb9-5c13-4b6e-b7ea-54a6dd644144:0,(cc4c0827-5014-4c87-b735-8ab64891ffe5:0,(c9f6a143-164b-4824-9b3e-bb9c4f1f7e61:0,(c7e16459-e452-4343-ae43-1fb90eed3013:0,(c4dc32f9-f75d-45a3-ad3f-4d8ec61bba19:0,(c2f11791-163c-4608-a6d7-7f46da5de342:0,(c2d75d68-0a56-4f75-91b7-1a45c78f3ba1:0,(aef00975-ad11-4261-9cd9-da76df0904ad:0,(a9bd4285-46b6-4f26-952f-9af8efdfca0a:0,(a496e80f-9cf4-4bdd-aa55-b107cc02010c:0,(9db313d0-0b26-41ee-ba17-4af483a7e7eb:0,(980d1630-6ff8-411b-9bb6-fcb0a47301ad:0,(8dd71e06-de6a-4283-8dba-ff6ed7bfe9f5:0,(895b7639-bb03-4f2f-a2f7-a08b265e2d79:0,(877c79c8-55a9-4c3e-8820-eaa637c47285:0,(7231a53b-135e-44e8-a30b-1dee9390b267:0,(6f72f8ed-b4c5-4afb-b7f9-7fd158fc925d:0,(6ca68378-ffd0-4e96-9608-e1874cdb83e9:0,(55a80829-3c1a-450a-9768-5c860f943b7e:0,(4dd881d9-19ed-402d-b457-618fe4ab7805:0,(48501685-5fc2-489b-ba44-d7ace33c32cc:0,(3d0aa463-5c83-4a4c-9cb9-9c9b409c8d1b:0,(35144138-d6e5-466c-afef-f7222dd01270:0,(3305a572-8178-4f52-95ce-a4ff6cc28a23:0,(29772598-a5a2-4b41-9caa-2d10e1039d55:0,(17000a9d-33fc-43b3-bf3e-d41ad6b73a9d:0,(0cb6858f-ebf0-4fb2-a049-356e6b6d4117:0,(073839c6-71e6-4197-a4ce-97a9983abbc4:0,06d1a091-e76e-475b-8e7e-1da80ba16026:0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):4.53357e-12):4.62424e-11,9d11bf16-2ef4-409f-bbfe-19678aa3ddd0:0):2.05371e-10,81b24fae-fc5a-4b54-844b-ca3ea2cce8a8:0):2.25866e-07,466d0c7a-23ac-440d-9ad2-bfbe290e70c0:0):1.13047e-07,7caaab20-0a1e-4d88-831c-8d02fdabcfe9:0):5.65808e-08,842b6e8e-f18e-41fd-b676-e2e3095a3aea:0):7.08348e-07,(eac342d0-66ca-460f-87a1-7fd1c221e981:0,76fef173-6f46-467d-99ba-eb72c8298e4e:0):2.24412e-11):1.3374e-11,(f3634e80-845f-4110-a6c3-f689b1098458:0,(3d56188f-f498-4884-9cfd-cce9fcc8d12d:0,1ad39ee8-aeb1-4891-8c24-ce4103037f5c:2.2637e-07):1.13262e-07):5.09991e-07):2.24794e-07,153e6a51-84b6-4df4-af38-d84256f38aff:0):1.12422e-07,29005f93-799f-4285-a0e5-2f79da2fed01:0):-0,(e7f737c3-6d7b-4026-b14b-fdb92acf674e:0,(cf9b67ec-0dc0-46b1-876f-528610ccc90d:2.26679e-07,(ae7796fa-b646-4f61-8369-1645c66488c3:0,(9372b181-3070-45a4-9e06-f8453ab24b60:0,(8ee9d6be-aa17-4f74-9a82-f1c2edeef1d4:0,(7f9a9e70-ac70-41d1-8374-93e37f05bd0f:0,(72ded7d1-cda0-4f5a-bde0-d1922a8146c4:0,(600fcfad-5975-403c-8926-86eb9f510416:0,(52063328-62a3-4209-9dd2-91c634b8177b:0,2f7879e0-a0f9-42fb-ad29-6c74a1e10f8d:0):0):0):0):0):0):0):0):0):-0):4.76025e-11,7e94fa47-0047-492e-a9ec-841b113ed76e:0):9.08981e-11,((((d2a0bda9-7a02-4bb7-8eca-0309073048ad:0,(b0ca25a2-882e-4108-906d-5aa16a2f7ffd:0,(8beb2f00-7af6-43a4-a1cc-589c4a0b7cb7:0,(6ae2ef45-7947-41d8-a47d-d63c21b92258:0,06bd6b85-1f6f-4e6a-bdc2-3ecd00ce74ed:0):0):0):0):2.30759e-10,41ef71f3-8ebb-4a97-9b20-e3318b0aec38:0):1.15606e-10,8e3b009b-cc78-4e8e-96d7-4b3acfdc6630:0):5.75764e-11,b7680e66-f7b1-490e-b643-b13efac24dcf:0):2.26588e-07):9.29382e-12,2fa740f8-b8ba-43b7-ad05-322ed4f9fb6f:4.53258e-07):1.03365e-10,6c441812-855f-4c6b-b04c-586da3d143fc:0):4.5384e-07,(c7a6eb59-a9b4-409e-a03a-ad49dcd2740a:9.04602e-07,((5bfe4cf9-6204-42bd-9206-278e8c200255:0,3e4cad8c-fe67-4ffa-8ab7-18f5643f393c:2.26679e-07):1.13339e-07,2a2c025e-bbeb-4d01-9309-2dbf07b27330:0):2.28791e-07):6.78395e-07):6.79734e-07,23d6df04-d7c4-44cd-a297-34edc6106bdd:1.84063e-10):4.12056e-08,(e423ac82-5f9c-4158-84ec-4d20f1c5a4ad:0.000386653,4b31a0b8-05a8-4b90-a343-d39342152876:0):6.50171e-06):4.13897e-08,(((f7c81b37-17e7-497c-b8ce-4ef4bf28250d:0,(6b61bc5e-40cc-4fd4-b7b8-41ccc2fdd07e:0,(3b9a4eb7-5506-4e5a-bca6-b16739e77612:0,(25b85ccc-0a93-49d5-b543-3008b906340e:0,1aa38c2b-392b-4afc-a814-a14ff2ef532f:0):0):0):0):1.13111e-06,46c92451-89b6-48fb-9deb-205f8430aaf7:0):1.12196e-07,(9415d3fa-4595-47cc-8108-77b4290a2ccf:0,8d08ed69-dbcf-4fc9-91a2-0abac0990620:1.03997e-06):1.79966e-07):-0):0,(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((fc1534f2-ffc9-4847-99ff-5b3d089f20fb:0,(e32c30f2-1e0e-4aa0-9466-b76cfa54d6f3:0,(e0a835e9-49c9-4037-bcff-51efd77bed32:0,(((((((((c5238261-b7bb-4203-9c38-d40ae8f1ab6c:0,(9cc07734-2934-4ff8-88c3-e94d49b879bd:0,(95ce7987-533c-4f76-91ec-9d58a2d2649f:0,(944606ab-62c2-43ea-92b2-0c667d718cba:0,(6d52446f-8ba2-44c1-89c6-2bc13724fa87:0,(528f8281-79fb-4fb6-9d3e-ff6733455b36:0,3b43c605-ce8f-4850-b9ca-4bcb6f9f76c1:0):0):0):0):0):0):1.20594e-07,22f0ccbc-213e-4e6a-a849-e33002862150:0):6.03604e-08,65e72dac-765b-4629-83af-238edd480ea2:0):3.02117e-08,85fdc3cc-cd5e-43c6-ac94-166aff785d86:0):1.51217e-08,9abf91f5-0ff5-44f5-9adf-d77d9461c629:0):7.5688e-09,a310eb9c-8f27-46c6-8908-59f41da58502:0):3.78825e-09,af7a416c-e49a-496a-9192-0f712c2e642c:0):1.89639e-09,b73cbd12-1867-4647-ae9b-731161292900:0):9.4933e-10,b78fea34-1084-4425-9b3f-ec310a3d848a:0):4.75118e-10):2.37559e-10):1.19233e-10):1.71369e-10,6085c56b-b3de-4224-9aa1-78d66873fe5d:0):4.5508e-09,0eee2d7e-a376-4ad2-892c-704197b0803a:0):2.27767e-09,17723c1f-efe4-4d46-ae58-4960ce44c77b:0):1.13974e-09,2b618173-6401-43d3-a427-3bb26aae16dd:0):5.68963e-10,62d3e924-71a5-486a-ba50-b848c60e00cb:0):2.84255e-10,6ed3e035-0aa1-4f15-b5da-6e2441a528b4:0):1.42354e-10,a3eda624-9d73-4f25-9330-419b3780db84:0):7.11771e-11,b2e2d9cf-5895-4a5c-899d-eddd9e8a4092:0):3.58152e-11,e8680b91-12e4-47cb-9938-d899e621a1fe:0):1.30567e-10,0362cff2-2679-4aaa-b93c-d47117f9e84f:0):6.82303e-10,1d582a70-32e5-4eff-8c4c-7517bfe07b99:0):3.41378e-10,1e43a759-7e56-477a-968a-1c41a5868287:0):1.70916e-10,3b5a0309-f02c-4b2f-b5b3-ebf76d6502fb:0):8.56845e-11,6fcbfa1f-ceaa-4ff1-adfb-36aea08d94d0:0):4.26156e-11,914b0f53-41f9-4e59-83f7-ffbb9c34600c:0):2.13078e-11,931b0688-c5ef-46d2-8445-ee9fc583bddb:0):1.08806e-11,c33df87c-1557-4353-90ac-9b8283741f7d:0):5.44029e-12,e022f6fe-0d89-4dc8-875a-7011b4b89769:0):1.16513e-10,7add98a9-bece-49f4-bb0b-8ffdd0314914:0):1.23721e-07,27af6c59-61e5-48bc-a81c-be89af4444c5:0):6.18719e-08,48e9f9f2-c32e-4e08-bb0f-c990035e8b12:0):3.09561e-08,6c6f8dc9-d9a8-4a02-a699-185f3502ffe6:0):1.54948e-08,73c60816-fd7a-4cb5-9d21-4d90238026c5:0):7.75604e-09,74d6b1fc-b1dd-44bc-8f75-2cc1af25f927:0):3.8821e-09,b19aec86-f30b-4fda-9ec2-323bd73bf81a:0):1.94309e-09,ba2f23e8-aaf5-4a4c-b842-8d9824994f2e:0):9.72451e-10,cfe98bac-ddc0-4fe7-b34b-4bb8a6bba446:0):1.23177e-09,09a23fb8-e8a4-461e-91dd-dcf577a98318:0):6.16566e-10,0ca8422b-186d-40d7-965a-3d614e6a470c:0):3.08736e-10,66eda345-1c47-4864-8809-b5f7825eed28:0):1.54595e-10,9deb6342-e047-42d6-94b3-57735eea6356:0):7.75241e-11,b7905214-1f93-438d-bf56-ab2d24b68f38:0):4.78201e-09,01a8878a-cdeb-4dc4-a256-368e7ca380a6:0):2.39373e-09,050ef932-e29a-422f-a343-e6134c402a6a:0):1.19777e-09,2a211085-b316-49b5-8790-db400bd4cdcc:0):5.98885e-10,2cd8cbd2-a687-40b7-b503-cde7d22d2fcb:0):2.99669e-10,3b9b18e0-1a98-4acd-8e0f-54f10c072d1a:0):1.50061e-10,3fecc13f-2fb1-4a81-b612-b660e05e4a73:0):7.48039e-11,5fcd3ba1-7cbb-4cc3-be56-98d2b7b5be31:0):3.76287e-11,6600168b-598f-4a63-abce-115ce4043af9:0):1.85876e-11,6c94ca44-bf3a-46a4-be92-8c5dc38c0aa7:0):9.5205e-12,7ba90b06-29df-41a3-93ff-53c5cb0f626e:0):4.53357e-12,8404436b-d679-4dfc-8f96-f5cfa0c4b073:0):2.26679e-12,be80d010-7944-45a0-97d9-d6d069353536:0):1.36007e-12,d353a530-f91b-4984-b233-78fb6401be67:0):4.53357e-13,f3783f64-d384-43eb-bee2-f2768b10374a:0):4.53357e-13,fbdae1ef-ffa8-40ac-a57c-7ed1f9c3fe8b:0):5.0776e-10,4ba88b58-addb-409d-a013-6c80cf95c631:0):1.27984e-07,0093f39e-9a78-4997-916a-22406f9eb3c4:0):6.40725e-08,0208e4e8-2309-4034-9c9c-5831666ecc20:0):3.20723e-08,0250fd71-0606-4d03-8de5-f72755cd57bc:0):1.60543e-08,02ee4aba-4c0e-4b70-8d31-6c3339339c73:0):8.03621e-09,03098bf0-7e20-4475-adca-b3f44703b2e0:0):4.02264e-09,03e0ac11-5346-44f9-a9aa-109d7350f90e:0):2.01381e-09,04ae9f80-a2d1-4781-9698-497028cb9439:0):1.00781e-09,0538a158-7455-4efb-99a3-36a50f5e57f6:0):5.04587e-10,0739719d-1031-4397-a307-d294f211534a:0):2.5252e-10,00f6c5d9-9e2f-4f64-a6dc-f20dea3659da:0):1.2626e-10):-0,((d445efdd-2f57-45b4-a02c-92bae74e37fd:1.36688e-06,((a2fbbecc-c8c9-4430-addd-bde74ec51ed6:0,(37ae9fc7-5883-4d8e-bba9-15aeee6e9c46:0,07e55d5b-c66f-4e10-92c1-55ad0fd9dbd9:0):0):5.28161e-10,1faf27ed-199e-488a-bea7-84e43e814f07:9.06186e-07):1.57941e-06):5.33329e-07,49744ecc-512e-40b8-9223-0026566f7754:0):1.53602e-07):0,(ff5c4a4a-aaa4-4425-b372-93ad06a46eb2:0,(fe8ebe61-f8c0-45b4-95b1-227685541d8e:0,(fe2336da-313f-4836-a646-0f0a24604210:0,(fe0d8c83-8489-4281-80c1-64ba52a26f8a:0,(fdc0da9e-eca0-44d1-9655-863199eb1911:0,(fd962142-f6fa-4add-bdb7-a80e2859caab:0,(fd794c65-3403-4f0d-aa4d-d00b1ae05d88:0,(fcc042f3-bc63-465d-a025-65f456510635:0,(fbb45933-2ce3-408a-bb65-9cef09863878:0,(fb5e62a9-6f36-4311-bf0d-3b42d2954a6a:0,(facd27fd-134c-4aa9-87fa-a48774525e39:0,(f9c56779-b9db-4873-aaf3-de6e57f11f68:0,(f92e0341-0b95-41cd-8f0f-8123da853c39:0,(f91b3f00-c19b-46af-9928-5c364aaa3f4e:0,(f8f8ee8d-2f38-471c-8911-6107fd7b3a4f:0,(f8e15b55-3a98-4140-8a04-ebb354e1695e:0,(f8d47b54-3eb2-4d46-981e-ebe268a2f330:0,(f864475e-2845-4abc-937c-0dbdfd29de79:0,(f850cb91-f7bb-470d-b12f-dd00868bda93:0,(f83ff3fb-4f11-4e8f-94e2-787ccaf1bb9d:0,(f782f3f9-572b-49d2-a78b-3e32ad4bc996:0,(f75eae06-b0b8-47cb-9596-8f2110ab6b49:0,(f75b656e-bd98-485a-95ce-fbc679381f71:0,(f67caed0-5f9e-4937-a11e-1e592e2287bd:0,(f5eb7de8-9b00-4599-9b47-2048fc2cb7ea:0,(f5dd3bad-b387-4e42-96cc-f53c0ed4b378:0,(f54df166-3989-43e1-9215-6d279d179f5a:0,(f53af447-212a-4a5a-855f-14c3821b4574:0,(f515c200-2a49-48b7-a770-9580af0e2834:0,(f501a848-8b76-4b80-8814-91fb0aef8cc0:0,(f4fa1c0a-795f-4f93-909f-ee201f631bda:0,(f4488aa1-12cc-432e-9589-16605cfcfec2:0,(f3924703-2205-4511-b2e1-5fbae249293e:0,(f3344114-46f9-4be9-80f4-b8d9395402b9:0,(f313e21f-caa5-4001-baa1-49c9b9290a72:0,(f24d3835-700d-44c3-a88b-eb98e3ca8fd1:0,(f14263b7-c858-4720-a209-02b5dc2d1ac1:0,(f0c93c11-a4ef-4542-9138-7a5822f435a5:0,(f0c197bb-1545-4b8c-a6d9-01ce41048fbc:0,(f0890608-a6e3-485b-b4d2-699241b21d18:0,(f088c561-06dc-45d2-8b2f-7fe5a4515b0d:0,(f0609599-85c2-4e16-a79a-7a0f7300aa98:0,(f05b1236-1bd5-4574-934a-627409b1ea79:0,(f02f5ed5-f7d4-4c3c-b257-aacbd73202fc:0,(f02f5a7e-85d6-427c-b938-b21b17651fba:0,(efe55ce5-f5e0-4f82-bf16-0bc49e738801:0,(ef950d42-793e-435b-b574-a477461b3133:0,(ef8c96e6-b281-424d-bb84-e5238455ce08:0,(ef6dba30-3008-450c-bd49-a7ac984f0d86:0,(ef05cbc0-b7fc-4e40-8cad-b8b1ac1d1dcc:0,(eef5c557-aafb-4ef2-bfee-73be37344357:0,(eeda32e5-92b6-4fb4-a489-c40054e127ff:0,(eed55ce9-f9e6-4ae7-a500-e7529f271d82:0,(ee31fa70-42bc-4544-a53a-5a2a7f9882e5:0,(eddcdab4-67ff-419a-9859-24d5113da5f6:0,(edcde028-8680-48c4-b13d-1285b0945eff:0,(edca2994-084a-4c4f-aec3-85be5f105bbd:0,(eda5e82a-eb8e-44cb-a098-c0fb01531951:0,(ed4bb1a2-ba40-4942-bd01-c983e9662998:0,(ed058776-b198-4243-bce2-5225bcf1d9be:0,(eccc4211-3e84-441d-b98f-7f6885c582e0:0,(ec9a663f-1a4f-4952-aa9a-b6ccfd5ddcb3:0,(ec98ad68-224e-427a-8130-a987c342eeec:0,(ec9765bc-af88-4e5c-a413-d2226dc01785:0,(ec658fda-fe7b-4365-b1d7-32cf85be78a0:0,(ec515450-b190-4ef3-a997-2749993523e7:0,(ec3746dd-02f4-4884-996a-0f2b5b0a64bc:0,(eb91e4f8-2b1e-48aa-a475-991c87950fbc:0,(eb395221-268f-4051-a44a-66944514cf3a:0,(eb30f7c2-27b2-4917-8b52-8b360c466db4:0,(eac01d64-f5d6-4887-a20f-ebbb067acaf0:0,(ea3011e6-5f38-4c48-a87c-efa84f96d95e:0,(e9f2ae12-00f9-4f2e-9abe-fe71895a522a:0,(e98577ab-584d-4d1a-afee-bec3ae260c75:0,(e8ddd1de-0655-44ea-99ee-04b475637b0b:0,(e8cf1674-50f8-46e3-beaa-d643ef23f86a:0,(e831d64e-0095-4c7d-a5a4-63c7459b74b3:0,(e8164797-ab53-47f6-b83a-ad1b0aa66ae2:0,(e7f721eb-0702-4ae6-92eb-20f82dffddcb:0,(e79dead1-b39e-4e9c-931f-411089deafa8:0,(e76d74e9-17ec-44c6-b2c2-129b8be30d42:0,(e6d29d3f-2e3f-4624-b0d0-6cf4da5a01f0:0,(e647f85c-e47e-4ec2-9f2b-01b6f257f2b9:0,(e5f491ee-7f76-4989-bafd-7e4df78d298f:0,(e5f2b1ac-fad2-4646-9648-f2ed837cc170:0,(e58aedd3-e077-4fcb-9402-005c4f5a24eb:0,(e51d2505-3532-4b89-ab9a-9d2fdeb4e198:0,(e51b09a8-6338-48fd-ad91-0bfc0d5d0840:0,(e50fba0b-26c4-4c02-bd7b-7fc7562bfa17:0,(e4fb3b79-12f1-4951-a2e1-0a3823b29400:0,(e49f5c92-b595-43cd-8d6d-4d666f806950:0,(e417871d-fbda-48a7-9a67-411462e37229:0,(e3e3be0d-79cf-40fc-baf1-bd1dd419995b:0,(e3b5aa5a-1aa1-45d2-95e7-bc724c7b933b:0,(e2fb5450-610e-4351-9764-82ec7335669a:0,(e2f9eca9-35f0-4280-8f5d-ee884a140446:0,(e2e42412-b774-4ff0-9a7c-30071bf973cf:0,(e2d7488c-fc9b-4c23-b984-eb11618a680b:0,(e25da430-04c9-424f-8ab2-46350e0ca993:0,(e1fb302f-1933-4c0d-bc2e-de7518707e05:0,(e1ea31da-206b-409a-9d37-f6451469651e:0,(e1a95121-267d-46b8-9ed7-542adf2cc965:0,(e19b8add-8b87-40c0-8ac3-44d0fadf86f7:0,(e19660c8-096f-4ab1-b027-266a7309f8d2:0,(e148ba75-44df-47b9-93ab-41b16e708021:0,(e038bcdd-e103-4755-9023-93397ea0fa53:0,(e00d32ee-0918-4318-a089-438a31154e12:0,(dfe4b9e4-a7e5-4469-8fc7-57076de9de49:0,(df9b8175-cb9c-44d1-b5d4-ec0f6e7192f8:0,(df852c54-a82d-4db7-a333-f8b2929d5c40:0,(df168501-b508-4ea4-9b29-c3ba89d04c22:0,(de8c5692-7f69-434a-bad5-75cf14bef559:0,(ddfd09ec-ff3f-4101-b4da-ef4c5d37a0f3:0,(dd4f7f1a-fd05-47e3-a21e-e320390365f7:0,(dcedf523-0acd-4082-8156-7d6c10e0d795:0,(dce2fa0a-f535-4853-a203-546c057698e6:0,(dccc3bae-da64-45ed-8231-126bdd4e2e0d:0,(dcc32d09-b80f-468a-bc40-e3b1a0ba69bf:0,(dc84434f-9d62-44b4-838c-58f0eedf2152:0,(dbf12224-ebb1-46f8-869f-e44090b806b1:0,(dbdc39a3-a819-49eb-9ba3-f25eb23f2c1d:0,(db2551e0-c641-4db6-a718-b7bdafaa7554:0,(db199dfe-9ac3-4810-8350-03335a45cc08:0,(db17c10c-c506-405c-a2f6-3db523dd9c64:0,(daa8f49b-a636-4bf1-8817-77793fb67368:0,(da9ba009-42ee-44f2-b89b-b0daa39d2496:0,(da330ec6-bc71-4b01-a53e-8cc285cf142e:0,(da0f5dad-3b64-4b9d-9baf-b96218176052:0,(da06e81c-0208-4827-859c-bb7fc8819339:0,(d9d8a2ef-1e29-42d8-828c-23a5a788b0f4:0,(d9be7567-8cd8-4b3c-85f5-37045564e1a4:0,(d9a65766-f55c-4e36-9767-5e1026e4cefc:0,(d9a056c5-df7e-452a-9fe6-55ee3b482d0b:0,(d97ed454-850c-4e37-bdf3-5fd787811c6f:0,(d8eac6a3-5147-43fb-b74d-4b98951d061b:0,(d882aff2-4b09-4d8f-9b2c-96acf5d9c14e:0,(d8790ef4-f46b-4e4c-ba82-92107d6ac371:0,(d8663b27-868b-4c86-ac7f-6b006b41df8e:0,(d8459a05-0bf6-4b87-a92a-926b74bdab4f:0,(d82e023e-d341-4877-a927-500c599dd333:0,(d7e4c868-37e3-4d90-8dde-8d4e52caef8e:0,(d79373b3-9e02-4faa-bee3-c2522d72d77c:0,(d70e0fc3-cd28-4c2b-b4cd-731fe3085626:0,(d6b56eb4-cdc7-4820-9e30-e5780fb86ecc:0,(d62909fa-5724-49c4-93da-68d57ad18a32:0,(d5bb16e1-1119-49e5-80df-824575b58a3b:0,(d5274798-7c70-4ded-961c-73697f1fae62:0,(d51f2fe3-056c-4c62-8942-c8421e0d71f9:0,(d4b42d95-f3b6-4949-8bcb-0d62696d2e1f:0,(d45d3207-75b3-4a3e-bf28-e94c73c6e150:0,(d42c3b69-b4bf-4904-8732-157266cc4acc:0,(d4247f81-d6f9-4ee0-8050-81408b7ff2e6:0,(d41acd7f-f17d-408c-8e3b-3c7448b6e660:0,(d3590cbf-818b-44c7-8f5c-ec26774cb384:0,(d2d67fd7-b7fe-429f-9385-dc03d455c9eb:0,(d2ba0f45-fa2f-4cf4-824e-2a5fea039ab4:0,(d262c5a8-1613-4643-9909-15b668132332:0,(d11bd889-5846-4f10-9545-147fe6313015:0,(d0cdb535-8bfa-42b3-b0fe-214ca4003e42:0,(d0b5f2f8-f514-44f2-905b-b829533e10e7:0,(d0af610a-5233-4586-9216-eeee151af8c5:0,(d0a15059-43c1-4e77-b8a4-0bb6d387e728:0,(d057e21d-2a4d-48ee-bbbe-98c7ecba2305:0,(d0485f61-461a-4698-853d-0fd237d79190:0,(d001fbbf-4177-42f1-b08b-25a2766fe409:0,(cfaf42a0-b1ff-4bb8-a194-034f84c410c6:0,(cfa9cb4c-7feb-4d77-83fc-5c6376793274:0,(cf6ff311-6af3-4316-b18f-4f4554d56a12:0,(cf5b7ab4-58d1-4e88-9d97-8a77a538398b:0,(cf3a00f4-08b5-43ff-a84f-f3b43a275b9b:0,(cf28b7f1-183e-4d1d-a6b5-4705d2c7e4c8:0,(cf189676-18ba-4910-965e-4a4eb8516f16:0,(ce8a18c5-7b17-4ee7-80b0-28a677500c38:0,(ce3e2537-585d-442f-88ad-795a208f1d4f:0,(ce255d60-a130-4178-be7c-9378cd2cbd53:0,(cdfad37c-bd0c-4931-be89-79f2fa8a1e04:0,(cdf0c9d1-9dc4-4f36-a299-0cb89644fec8:0,(cde00f28-54da-4f65-b604-065407e887b7:0,(cddc1d78-8d08-411c-a1a5-a9dc7cecb5da:0,(cddba97d-576f-4f2d-8820-d9dc505c6819:0,(cd8c045b-e1ec-4763-a617-c8a79286cf55:0,(ccfd8ef1-ca96-4ea4-bd2a-cc0d9ce0f6d4:0,(cce22d0b-21a3-430f-b165-91bb72994f1b:0,(ccb122d5-1cf5-4a8e-823f-c56615159738:0,(cc823d5d-4213-45c9-9411-ec165f13ba15:0,(cc4bf7b7-64b6-42ac-900e-824a818879e5:0,(cc46d2c3-01a3-4962-a4bb-4a1915224181:0,(cc3745f2-cb0f-4252-88a9-0c5771db750f:0,(cbe11525-6f9d-4020-ae1b-3e14f8fe15e3:0,(cbd923ee-3b6e-425b-bd8f-a2c20900fab1:0,(cb8bb090-f228-4b77-8bdc-c384b6fa2c18:0,(cb4d732b-f941-4758-a005-0f98cca1da89:0,(cade0e71-52da-4249-baec-6505da01285e:0,(cac0eb8d-415f-4776-b369-3aadf79d625c:0,(ca155038-5542-4389-a6bb-cc4d71243c22:0,(ca153cc6-c71d-4b3c-9dd4-d9142e7fd061:0,(ca034b69-1fa0-4b13-a938-ca146b2b32b0:0,(ca02b64f-af03-43bb-8ac2-2354add09975:0,(c96b9314-fbf1-4b86-aaf5-e40812ec06f3:0,(c91793b8-e4d5-4f07-8e5d-79dcd41e0444:0,(c886b405-7d08-4635-9d1b-e9383c01f421:0,(c84aa452-a35d-4124-a976-d9b3796a5fff:0,(c8266e60-f16e-4a5d-8982-57f48fc8baab:0,(c7ffb54f-ee5d-4cf7-9a58-0e6a19e448bf:0,(c7b7bb0e-4a1e-4c27-873a-83ad366171f1:0,(c7a4936e-fcb9-42be-933a-3825e2f7e1cf:0,(c7a419c5-7833-4bc7-b5e1-bef000ee99d1:0,(c791882a-981c-4aef-a209-b445ebd56d39:0,(c6f075a0-7195-4a18-9176-35d2c4fa04d1:0,(c6e64cf5-ee09-442e-826f-cb37ae454323:0,(c6d7779a-5478-408f-bb6a-81739f5758ae:0,(c5ed2992-3089-4f7e-a68a-d5fb84064c36:0,(c5e7f96f-4141-4c68-be34-a47b26ae1e07:0,(c5d68107-b02a-4be5-90ed-f770147db39d:0,(c4a178de-59bc-47e1-b56e-f0aa13b591e5:0,(c46048c4-555d-425b-bfab-295113d606c7:0,(c44c9ab0-9efc-4c45-9ab8-777cdef9edeb:0,(c44ad681-50ea-49e8-907b-7c3e7ce23e24:0,(c3964ad5-fe43-445e-90a1-c49ba93db472:0,(c2ddbcad-231f-448f-932a-13fbf593c7a6:0,(c1fcd122-db9d-4c02-8cef-e916d4f6269f:0,(c1d74b88-afb7-4cac-b049-311db440c4ef:0,(c1badaeb-4827-412d-a288-2c7ef7a6d337:0,(c1b90106-c768-43eb-bb70-19ac04a6d2cb:0,(c194aea8-4484-4df8-8308-9263421a2c6e:0,(c0f24a98-26e7-46fd-a1e1-99562b781200:0,(c03e809c-3309-4dd8-a763-a2051977775f:0,(c037c1d7-5508-4f6c-8509-16ff23cf92ed:0,(c0363a3d-1308-4c1d-a5fd-94221c76f2e5:0,(c01393c4-1958-4fde-9dbe-c4c998f86091:0,(bfe20bdb-a324-42c7-b69c-368d1359d4d4:0,(bfbfe105-b3c2-45bd-8657-b35de8122f08:0,(bf98bc1e-6026-47b5-bd2c-626a88392c6a:0,(bf80afc5-b571-4af7-91a2-5220387895b5:0,(bf12ef33-125f-4f51-b7a5-cadc7ee793c6:0,(beb0d9d0-d047-498d-9e66-4d1ebdf7cbf7:0,(bea4be9f-677a-4938-a555-c974bf1cd51a:0,(be7c02f5-4df6-4e4d-b73f-93124b48d084:0,(be231692-eb15-45ea-9530-89ec403b31ad:0,(bd6c98eb-1318-4354-9563-ee12dd4ca750:0,(bcde575f-d3dc-410a-ad77-e3b4bbf06b63:0,(bcc9039c-369f-4e66-ab00-fc713c1abb3d:0,(bc346569-efa2-428e-9381-9c831b599f42:0,(bbe1d2b7-8515-41d7-b864-caabedb4bc5d:0,(bbb6f23f-3b24-4620-971d-b75691af0547:0,(bba0044c-497f-4f6b-87ea-bcbfdd644f61:0,(bb03059c-4596-4728-a46f-98a94cbc543b:0,(ba1f732b-afae-4a77-bb54-f310dcc3de90:0,(b9809f87-32d4-4a97-8fec-2e0a0c45cd61:0,(b93c8295-e413-4469-b33d-6da091bb2160:0,(b8ed5abd-b5e6-4cc3-9d88-e23278b5a16c:0,(b8aca71d-4fb2-4adc-a2c6-014ebd5121b3:0,(b8a008f3-155a-4272-81cd-1a9ae2471888:0,(b85fe905-c9f8-4c6c-bea7-a1df575ba989:0,(b80b6eb8-3c42-49c2-a02a-629bd0e34822:0,(b7d55dc7-a1e4-470c-803a-58e6c733ce35:0,(b79431cc-ca30-437a-9834-e1296dcd487b:0,(b78684ed-4a6f-4a5f-ae39-53007d8ac7bd:0,(b779c8ae-15d6-418a-9c95-d47de04d93c7:0,(b7602c43-7d8e-4215-85aa-a7d60f8790b7:0,(b6c3bb3b-e4d8-4de2-9c5a-95ced04fb0b6:0,(b68ea375-0cd2-45dc-8359-a4ca3876e894:0,(b6531255-60aa-4232-bf4e-c97695c7178d:0,(b5e52c2d-cdfd-45f5-9d6b-641f5ece04fe:0,(b5491cb8-fa68-4de4-b749-a088e187cecc:0,(b4826984-60d3-4fdb-b33a-348af69c4c27:0,(b402ff71-f157-45ac-b33d-e3bb81f0a39d:0,(b3bfa7e7-c05d-4487-85fb-311ebe75639e:0,(b3113fe6-7760-4b76-90ad-8c7b7b322c97:0,(b2f07ed7-ac09-4505-ad24-0ffc36f3f503:0,(b2bcf50f-cbfa-4d41-9fd3-56640b348b7d:0,(b2ace529-ca91-4b62-9a6e-fc5c8d298e52:0,(b29aa01d-2da2-4b4e-b6eb-1fbb07cb71ab:0,(b28d48e9-b043-4cc9-a7d6-329547d09194:0,(b26f2197-98c9-4f85-b78b-cb13df187d02:0,(b1675c83-c342-44ad-97f0-9cd8ef9af70d:0,(b164994e-0b98-40e3-994e-27ac3a762d4d:0,(b1571b64-4f09-41b4-ac28-221408f65b89:0,(b14083ff-54ad-4f2c-851b-1c10b364b7d0:0,(b0be2d99-4c6b-4cab-8fc5-99691c3df65e:0,(b0b9b44f-f3c8-44e9-b480-322a224be1e3:0,(b00bb742-fd87-485c-b784-7576c5d94204:0,(b00324f8-293d-4ec0-8f0e-40ab0c63ec75:0,(af1a01ad-cee0-451c-a0a0-7e561cf5954e:0,(aef1f429-1b00-4dd2-a73e-1364398a2bc6:0,(ae5359d1-b4f9-4d76-94be-12f162d34224:0,(ae4695ff-1ecd-4476-83c7-d61e4293f9f5:0,(ae3c31bb-56ea-48cf-82d7-7ada5a51e286:0,(adca5609-e75a-4e42-b2cf-b2053d78747d:0,(adbd7738-9f7f-4ed9-a0be-b0ffba3ef520:0,(acf5f3f1-d77a-41e7-8a3b-b3b0bd033a3d:0,(acf51375-f84f-46b3-827c-1ea024fcc477:0,(acecbb94-e81b-4e5a-a1b2-16e2e72c5f6e:0,(acc29b52-468e-4c67-8bc5-edc9d136244f:0,(ac6bc776-f1d8-4c2a-ad78-3e34373bd429:0,(ac4b5447-5dd1-40e5-9f43-421249dffd06:0,(ac0f19be-fcfe-4110-b873-de3ac85019e0:0,(abaef4a9-8832-48b6-97b8-4a9909940080:0,(ab48bcb9-a62e-44d0-a757-46d73c30a331:0,(ab03da05-232e-47e8-8435-cdbe55376a94:0,(aa8e7211-8fb0-484a-9d16-10da2c77b0c6:0,(aa6c6a82-eceb-4494-a09a-ae80f54e8999:0,(aa12f781-a45c-4e11-a0c6-9bd2c52c5cae:0,(a9cacf26-bbbf-4737-a877-b38b846a34c9:0,(a98eac89-5190-4d40-9cfb-d5c5ae0891e3:0,(a943a0ee-934c-4969-b0af-2958dc341e32:0,(a90b64a9-2df9-4391-bfc0-3a75092e646a:0,(a8d36f40-bb8e-4fc4-940d-3f3dbd40feac:0,(a8a76a00-86b8-4086-bc17-8a56753ee7d8:0,(a870fe5c-8e1e-46f4-9eb6-e994264d698b:0,(a80958c1-8dc8-45d4-9c87-acee1fc25ad3:0,(a740369c-6d93-489f-aa61-9e6135d5ebe3:0,(a7377662-d656-404c-b9f9-84478a611ffd:0,(a724a068-6b7b-4305-90a1-4583c4e6aad3:0,(a7134fb3-b8cb-464f-8c15-4b1c15c9ba6c:0,(a6f2e8b8-8041-4ce0-87c8-1d1cf5c9137c:0,(a5b7a082-00d3-4b26-acdf-a46e53691c0e:0,(a59b0821-16b0-4864-96af-a6f36397e33f:0,(a5961680-1524-4114-98e5-5603c85db6d2:0,(a58daf12-3a60-47a8-a628-44515754b338:0,(a51bbf1a-7776-4407-a3b3-ec33a81753c3:0,(a4a93376-5da8-4413-91d9-36d63e99eb62:0,(a48fecc6-220f-453c-8534-7a585e6cefe7:0,(a44d07a9-f983-48dc-afc7-bcf031a81d7d:0,(a419f1cf-ede0-4777-be49-17ce726d9ff3:0,(a3ef4d93-98e2-4ce8-bf3d-087589049f6f:0,(a3ce51f0-870d-457e-9e4c-f6dc7a802727:0,(a3bc6a57-6710-4628-9161-9dc3be4d4504:0,(a3a85b94-f30d-4fb9-ad9f-d0374125bf4b:0,(a31f6742-4c87-4646-a984-f5f7f811df46:0,(a2ce862f-a2ba-444b-8a14-60335fdb3eb1:0,(a27508ef-3acf-40fc-8ca7-a4d9392633ba:0,(a21f8c60-d769-44a4-9b73-a1e2512fe776:0,(a14e6b20-dbce-4f81-a076-4cfb001c1335:0,(a075291f-091c-4e3d-b8f0-cfce5f7d1a04:0,(a038860e-8bee-4a34-abfc-9ff45dcdf4e3:0,(a00b91b2-1505-4eb3-a3d5-1659ea045088:0,(9faeb73b-8343-4af5-a7f1-86585c1e99eb:0,(9f3a4917-e2a3-4afb-b562-47eee4c5ffd9:0,(9f1bdd95-02b0-44c3-ad62-e8bd5aef6396:0,(9e95d72c-e385-45ed-925b-3df8648ca8ea:0,(9e84dbbf-39e7-475f-8664-1ba40220bfa6:0,(9e411a0c-d4c8-4eb5-ad00-9fa28b9a132d:0,(9df03844-68c9-45bb-9eba-ff9eae331422:0,(9d8bdc36-4fa5-4bcd-935e-5a312999cebd:0,(9d82dc5d-a5b6-49bb-9f3d-293d39cf9172:0,(9d7eeaec-875a-48c1-bb7b-e7ba70490717:0,(9ccd1607-bc7b-4997-bbca-fd44d900a0f5:0,(9cc940c4-6aea-4cf2-9e11-430b28e7ad19:0,(9cc05972-4775-4c2d-94e8-c90207e341bd:0,(9c935f1a-d8ad-4410-b39d-0304833ca79b:0,(9c715bda-0279-4eb1-888c-4dc17a483ed1:0,(9bbe7d32-619a-4c09-9971-b06763647fea:0,(9b433643-f788-42c4-ba6a-c16b25a0565d:0,(9a9ea980-5fab-4b0e-b72f-ce4f9f7cf013:0,(99da87b5-408d-4f66-a34d-d875fad9afdb:0,(99518f61-b827-4a9a-8c79-e4a6c158ae0f:0,(992a1530-8e0e-4dc2-af21-d02a0c9d491b:0,(98a79c36-399e-436b-90cd-be23e42c6495:0,(98685d7f-a06e-4b37-a104-5497bc34372d:0,(983cc63d-3435-4de9-b708-5b57c0adc009:0,(981b9e63-e139-46bc-9736-a14731d34da9:0,(98024fde-7b4a-4c88-a5e0-246ddd29a241:0,(97d27ca7-ce2c-407c-9e34-5c1aca3070fe:0,(97b0d7ac-6a49-4f24-ba49-5ae454f98bfa:0,(97a64c82-2bf6-4202-925d-038d6b1ac369:0,(979d544c-0b99-4316-9e30-c456982104c8:0,(977efc89-57ec-4278-b87b-094ba7448e94:0,(974e95e8-97c8-4f7a-9ff9-1e4fbfada6fc:0,(967e0127-f432-4a92-91fd-9a926e081d62:0,(967c2ef4-b8f0-41e8-b04e-fef10c574985:0,(9646b988-f5d0-4f30-9a15-c2b0b0d7d2d6:0,(95f2597f-4397-42e3-870c-2a8702bf7a8a:0,(95bd6bc7-0d47-4945-b321-be692bf4149c:0,(957cf8ab-b9db-44f2-aa40-6cf639556b47:0,(95590398-777b-41a1-a896-3201603010f5:0,(94deb80d-5dc6-44a3-bdcc-5b38007c3d2f:0,(94b0b607-d8ae-4013-baae-c4f7e0b0ff97:0,(9495fa8e-10bc-4a66-a62e-07a470057c26:0,(947cfc3e-ec8e-4950-b931-dae714dd5bc9:0,(9437fdc1-695a-473a-8308-bdd080254081:0,(943594cb-871e-4083-aac7-2a5b05b34417:0,(93a97ede-3e63-4d19-8da1-d798280305e2:0,(9383c72f-e66e-456e-97ff-f4bcbd68bc79:0,(935f39b6-1806-43a3-acdd-df457cb6fefc:0,(9304518e-c07b-45c0-8819-55049df9fcfe:0,(92ed610f-44ed-4c27-8f22-a12d66172f72:0,(92db9085-4b40-4db4-a4da-7330466f5f97:0,(92addb65-9744-40e2-8616-b52048c062d6:0,(924fe674-f18a-4716-97de-b06040f5aab0:0,(9248b95a-f4c0-44bc-8ca6-e0fd870872ff:0,(922be21f-25a3-4235-85e5-9bf0e41e55a0:0,(915ff250-4d79-4025-ba5b-5ec6da2673ff:0,(9154e8ea-6416-4d6a-bd64-e3f4fc9d953d:0,(90936a45-3e76-4052-b25b-591bf44447e5:0,(90628ca3-a88e-4562-9d0c-c891d23540b4:0,(9058b476-6984-4d53-9246-8c2002af150a:0,(90486532-f872-4a8c-b5e8-99e64c340cbb:0,(904244b8-3dad-4c4c-a6d4-749ec912bc97:0,(903667ac-1798-4096-bab4-a6fa9c7d4af7:0,(8feb1e36-e7c6-4e15-b13b-86a67909cb73:0,(8fe5f272-17ed-41e6-b557-4832608b1d2d:0,(8fe221b7-dae8-4b13-8e35-0eee975a4b68:0,(8f9c0126-ffaf-4671-b205-23343e175c0c:0,(8f87476c-5911-446d-9c0d-04bb1959d60d:0,(8e71d058-01f7-4e4c-810f-a84d04501213:0,(8e32ac42-d8ee-4e86-b906-2b2d0d1d4118:0,(8e16d892-575a-4b24-bd68-86a03782490e:0,(8de87ee0-5a9c-49bb-943a-b6964f0ab47e:0,(8da5f0da-63a5-4a33-a625-f5d5ba3b4482:0,(8d99acbb-5f48-47ae-8ca0-1db60bbba21f:0,(8d7c960a-3217-47cd-9408-3d93912beaac:0,(8cb676b8-75f0-44d6-872f-f0cf9f9c0b63:0,(8bee5ade-9757-43e4-bd6e-09947d48543e:0,(8b671731-06c7-4480-84e2-3fe0a40cc2e7:0,(8b1549b4-1771-40a4-a1d4-cf9fdbff5a91:0,(8ad89d5d-ef9a-4745-ab05-b8dfa84b6c9c:0,(8aaf12cd-e44f-4f3e-8d84-e6edb32457a3:0,(8a37b042-2733-44e5-80b1-0f320a3cec97:0,(89f5b1ce-410c-4802-9a02-983a3f164141:0,(898a1f16-e910-4276-89cb-8ad9782cc5ec:0,(89625ea3-ee28-46ba-b5c9-f458293409cc:0,(88bc49d9-f348-4ff9-bc16-566508bb3ec5:0,(88a26417-a520-4b73-a038-0203269a2c54:0,(8849302f-aa5f-485b-8a79-532b70cafd3e:0,(883aaf85-abdd-4609-8aca-70b21f65ea4b:0,(8829793b-b4f5-49ac-88a4-42c2e45cfff4:0,(88079c83-d743-48b5-a4dc-33584b31ed4c:0,(873ed99e-34ab-40c4-bf40-65b78e199afc:0,(8739c83e-7a05-47a3-b50b-6281f447dca4:0,(8716f2d0-fba9-401a-9491-32b5fc7ad9af:0,(86ec8ddf-2aea-4bef-8a36-78557425a88a:0,(8689a922-13cd-428c-8164-8667593d98e6:0,(85d370ce-9faf-462b-9f49-c063165750fc:0,(85ab247b-95cf-4ee9-9a4d-81b39a6b2aba:0,(84d7d630-135e-4f0a-8644-4995b0bd1631:0,(84774381-efa8-46cd-9021-c7d8218eb7b8:0,(83bfbc80-3e04-4f9c-9d8f-f1c0a1899859:0,(839b5499-0ac5-4b62-b465-5039a5651778:0,(834af840-b4b5-441c-802e-b3bdbda8d330:0,(830b0d18-38dd-49e0-9cb8-e69d818bb2e0:0,(8243ee0f-9b76-4a0a-8ab2-bf0c868b6d06:0,(8231e220-435a-4a36-93dc-0d21beccf990:0,(818605fb-a766-40ce-a42e-f91df113b51a:0,(811fe25d-0676-440d-a025-010903f2a402:0,(811b4102-346a-493f-971b-a550c8730838:0,(80a75848-bb1f-48c4-94df-7e727913d766:0,(80a5266d-6c63-4980-bede-50d7122cdaa9:0,(80388ad1-4847-4e56-b72e-49b3704fc24e:0,(7ff06ab5-519d-48d8-9a27-4e7dfd912242:0,(7f571d1f-e7f0-4b2b-b688-8e6a832d57a2:0,(7f0ece2d-1535-4cd1-8517-5e38daa341e5:0,(7ea1e635-9075-45cb-a00b-df79ec52165d:0,(7e9e0693-7eb3-4fad-b9b6-a0cceeae15ae:0,(7df90614-c056-4c92-86b9-830ed2519d37:0,(7de33318-ea95-49ac-bfb0-ad8ebb875c61:0,(7d933480-f78f-4ad7-8977-0152bb89fd33:0,(7d5823b7-3cf9-4c79-a1ca-64c8b1e759aa:0,(7d159979-d7a7-4217-9d4d-351f0e12bc97:0,(7d08ccaf-3026-492d-ad31-5f78d6f539f4:0,(7ce2cac8-6f03-4b3d-aed3-b5d415961ce1:0,(7ccb04f5-da58-4480-8586-e55dde31b848:0,(7c8f3b1a-5218-4ee3-a787-6db811fed198:0,(7c601745-fdd9-4ffa-ad74-8bbbbe86bcc7:0,(7c3c28a6-0574-44e3-9105-25cf6de37f3f:0,(7c221b8f-558c-4f38-bcf7-ef8ce54904e6:0,(7bf64d20-213c-4f4d-97ad-bc28bb745484:0,(7bc593a5-e36b-41f3-a88b-11abcd456342:0,(7bc031b0-52e5-485b-a080-963df92a9e9c:0,(7b9d3a40-4d80-46eb-9743-aad5b7dac67a:0,(7b4a49db-03ca-422a-86e9-3b4bda446c95:0,(7aad22d3-d6b5-4045-b8a2-556173c20bfa:0,(7aa1348a-b26f-4982-a42c-9aacaee71bb8:0,(7a982a90-91b0-4b84-8453-4fbde2580d29:0,(7a6ab6d7-2f18-4c5d-a48d-8f7eee81e28f:0,(795dbbde-843b-4c4d-8c35-9cd587cdbd67:0,(791fe600-d103-40dd-bb83-7d86ac0c0fc3:0,(7914ab4e-7097-4cff-816b-c93bc3bb2fb3:0,(7838df49-3e57-406c-bb85-4713e8af4b12:0,(781d1e31-7ae2-4527-ba24-e06329cac178:0,(77a08a21-7da9-4ef5-9854-e3a906e44094:0,(77543956-14a9-42dc-9118-b1562f26b7ae:0,(774e70cd-f913-4eaf-99b2-76e4e482ad4b:0,(774043b5-017f-4034-aaeb-47d1a29c9f9b:0,(77379012-b3ad-49f5-8850-5948eae19e0a:0,(77304a9b-dd69-4f1e-ba4e-e0eaaddd37bf:0,(76f3ee19-ba6e-4af6-856b-c9ad42bc69db:0,(7601a119-e1a1-4f3a-8ec9-1bb863e53b65:0,(75c8d126-b5a1-422a-9ea3-5d2a1e67721b:0,(75b09111-ae2c-4340-aeb5-bb7c0ec407ef:0,(75acc5c3-27e7-4779-98b6-87dad9782e7e:0,(754349dd-3b5c-4cb8-a9cc-362447a02349:0,(750fb684-1648-4b99-8f6a-1115c3bd307c:0,(747ff85f-a4c9-4aaa-b1f1-c1f1580c91be:0,(746bc39e-f7dd-450f-b3cc-d1e121b406e3:0,(745f689c-e8d6-458a-be32-a19e7fb57f93:0,(744da65d-a4ac-49f9-89df-c52d83788faa:0,(74172062-fa80-4247-a1fb-d37798bb7728:0,(73dc458b-f2b6-4ddb-9fb3-f26bf53be065:0,(7374f706-64f0-416c-809e-e44e88508349:0,(735bbe5a-b1cd-4c92-98d6-ed4d37dc7565:0,(7335f738-e5dc-4f5b-a7f6-8f10ab46f074:0,(732010dc-8427-45f1-934c-0d45205da124:0,(72fb597d-9d11-48ef-bd3b-b82bac390d25:0,(72f6a9fc-2279-4e6d-9658-92afd097d23a:0,(71ed9cdd-d1f0-46cb-9e21-0e66821b4c59:0,(71d63f77-91c0-4a53-ac70-93714e6645a5:0,(71b09cf8-dd72-4fe6-9a2c-9d2ecfb90975:0,(71868b64-9bae-4217-8157-e2b83e3f5dfc:0,(715e9e20-312a-46d8-9631-9caa4ac6068d:0,(714a3450-0840-4c21-88b5-2f17401e62e6:0,(71146d6f-bff6-42be-b197-151c2d0b7411:0,(70f56a35-54ae-4969-8c0c-4f14ad7ae882:0,(70a9d331-313f-4c1f-8496-88a51b5931d5:0,(702767e5-d2f4-4b95-a2c9-062011be1052:0,(6fc40cd1-660b-4b8e-a039-94a1a20596d1:0,(6f0f763b-911f-456a-b5d2-80feb2c1b878:0,(6f024252-9102-4b17-995f-cf95aaa9ad2c:0,(6ed9d472-662f-4b4d-ad70-33e1d6072c8d:0,(6ebbceef-a7a1-4c90-95b1-2b0748ae4a79:0,(6eb96f76-67f9-442f-9e82-2dedf3bb5a53:0,(6eb8d741-fd16-4010-ab96-a6a158fe9a7e:0,(6eaae253-19b8-40bd-91f0-d618d728ea03:0,(6e771238-d2f4-48fe-bc27-ae1561558e3f:0,(6e51b400-fa9b-4988-80ec-338fcc799e27:0,(6de1e17d-962f-43d3-8c86-62e6559d2c32:0,(6dd5a0e0-df3e-4e5c-97fb-357651140614:0,(6db9c9a5-8d95-4e0e-a6c7-ae00300294a8:0,(6da97738-5a4f-439c-8dcd-6f702f9087f8:0,(6d80cd18-79b4-48e0-bf94-d2a861086896:0,(6d013126-7d53-4852-8b53-2b6de6dbd01d:0,(6c9c0300-3079-4195-815e-df1af020f69c:0,(6b50c8ee-ef25-4a72-98d6-61b3153d509c:0,(6ae4a944-5d72-4888-81e3-1b2cf0f872db:0,(6ad2e937-4c40-4e33-a594-016625c3be5a:0,(699e7c22-d631-41b2-93a0-45410f4e998b:0,(698ac8da-76b8-4a83-89e9-0bc52225372d:0,(6983dd96-cafe-4b47-ac39-f2e20463ad93:0,(696087f5-77e7-4266-bc2f-b2e28d60e5fb:0,(6931663f-3c1a-460b-8d99-f9a94fb4b16b:0,(69301637-bcdc-4912-b12b-7cff618dee2d:0,(68b29bd5-31de-4433-a0e9-69f1ea946532:0,(680a9a22-fb72-4383-8416-b4aeda135772:0,(67b0ecf7-5997-43ad-a08f-d1593c6c2249:0,(6712a2a9-d68c-4e7d-8b0c-641584adda32:0,(67042c3f-0022-472a-b5a6-8478e7ede6c0:0,(66d1ac66-5d58-45aa-809f-06057cb0d714:0,(664a6703-ae22-461c-ba84-3e12ab70980c:0,(66123018-d9fb-4dca-b906-dfab2d202cdb:0,(65a69989-911b-450b-bf00-f2a9b392ea76:0,(65288097-3d40-4053-8c1b-65510a341ee9:0,(64e52bb5-0111-4a20-bc89-84ab25d3a343:0,(649e3f31-1783-4bb3-b28f-8983385b3028:0,(63feb209-d22d-446d-af86-7d96c3abe97b:0,(63f0cfaf-ebb9-462f-96e2-931e72c98c69:0,(63875925-c4c1-4be9-b305-70da9252a89f:0,(6373f354-8150-45be-b123-d5942c554ad6:0,(629100d7-b8f2-4387-936e-f2cb6d59c653:0,(6272aeec-421c-4325-8b0b-2b28ccbda10a:0,(624b23f4-61e1-43b1-8994-e4d310a94093:0,(62462782-2264-4943-af06-816026b9ea01:0,(61de7a1f-ccad-4a20-8b5e-4eb1516907f4:0,(61d920d9-09a8-4919-a437-b57eaadce62d:0,(6150ae54-e162-4e02-9441-83360653213f:0,(61098daa-9128-425d-882c-51d40a8c24b4:0,(60f36a4d-a2a9-4f38-a1d8-68950f092ea8:0,(60b51531-4e7d-46e1-bd13-2ff28137a06b:0,(60a134a3-8b21-4660-a687-ddfc1d6c4f8c:0,(6086c193-847d-454f-bf2a-d4209e41d90b:0,(6079af18-9bb4-4d10-a8e1-511c69f071cb:0,(605f9e93-1761-4b7d-a193-ab774bf457bd:0,(6015e536-9cb7-474b-b527-037e1cab5e5c:0,(60089b6a-c05b-4fd7-ab51-9fe389ca2245:0,(5f7cc5e2-7e4d-465b-9a3a-2f95c35d1fd3:0,(5f5e545d-7909-47ef-8b43-30c4c3ebac12:0,(5f53d5ba-b967-41c4-a252-0a40a2468b4a:0,(5f2f2ede-c098-46c5-9d6a-de102e912c10:0,(5ef38dc4-2ae1-40d0-ae58-8d050628861e:0,(5e4e1446-7fa4-4ba7-9e86-166b14d0aa95:0,(5df62ab7-a2a7-4089-ac5f-2b8a039a6cfd:0,(5df58d61-b703-4a77-aff8-ad6d955a909a:0,(5d5ebaf0-d503-4996-a6b2-a94dfc017746:0,(5cf22c14-bd3c-427d-9970-2ba63cd2ee59:0,(5ce0b55b-3e43-49c7-9a96-af2e21979625:0,(5ca06252-fb82-4e12-872f-d45d8907e3e1:0,(5c987605-5f55-4db5-add2-c66f91128e8f:0,(5c559ac9-9e1f-49d6-9261-9f3c8f3d15ff:0,(5c3a1d06-a3a7-4bbd-b2d3-c3fa72937758:0,(5baeb3fb-b48a-4fc5-ad9f-e11c506aef58:0,(5b868f7f-b7fb-4428-864c-75b1226e06c3:0,(5af1883f-0842-4c3a-98a4-040cdc99e6cc:0,(5ade4017-42a7-4a3f-9592-daccec837321:0,(5a8cf7bd-6a5a-4c26-8c69-ba1ec1ab444b:0,(5a767c36-a336-40d2-92ad-d2531aaf1ae2:0,(5a701f1a-89b6-4a40-b014-0db8ad3a67e6:0,(5a30c953-255b-4d19-9fd7-06bbcef20326:0,(598c24f5-f095-4493-821f-34e6d4ae3db6:0,(5987441b-b7eb-47d7-9d7d-a835904a2015:0,(5868755a-8927-40fb-8ebc-a6aee7b6ec6e:0,(5836be59-40de-4eea-80b3-c657f37e81c9:0,(581e4244-468d-426f-9b27-50a6ebd9bc30:0,(579fee67-2b39-4925-9028-d6c1f2898dc3:0,(577634e1-5581-464d-9682-8d8dc05e6e71:0,(56f45041-2cf2-46fb-aeef-89d5dd763cc6:0,(56f00144-31fc-4ae8-a121-dae5dc4ec9b3:0,(56e0903e-67c8-4661-8146-0bdc056ec54d:0,(56203e25-adab-47d3-9688-9b4fd33e15d3:0,(55c69527-6925-415a-88d8-23e667b3b8d9:0,(55a7afac-23bb-4460-aa68-31050095ef8a:0,(551e7d70-e979-422b-9e43-d16d35e6a81b:0,(545b41ba-e033-4f03-85b7-f4c4bc659f0c:0,(53841e2e-d143-4444-9fdd-d308ac90760b:0,(5338d0a3-5000-4a11-972a-1bfe9f7b0750:0,(530cbaed-efb5-4e72-b778-2b6b6f0fe5b6:0,(52e1267f-03d2-44a2-811a-e7a4cb1bf2db:0,(52c9e146-6917-41f3-aabd-82a2b59e4628:0,(52412a46-9d93-4d0b-945b-89240e2c5e97:0,(51fbe3ac-4e01-4e31-83f9-60c26c3b6613:0,(51413b96-aecd-4510-b7e7-212b71b13833:0,(511cb8de-106a-40ab-a965-479d10c33cc1:0,(5079d234-9fc5-41d9-8653-99fcc53d30cd:0,(5066fe8d-e4f5-47e6-9ef8-87766f279385:0,(50446796-ce3a-40ac-aa89-c40d3bb98309:0,(4f9baa06-3a35-4564-8aa0-756fe1436e2e:0,(4f2c59d8-5214-43e6-9168-463614d10fd7:0,(4de2eaf4-5c62-4665-8f51-5f78771570c9:0,(4dda0eaf-7e26-47f4-a1b5-eb6ea221dd9b:0,(4d2f62e8-4899-46bf-aa02-d09b063e1be3:0,(4ce76968-066d-48e8-a40e-cf79e138374c:0,(4cd3ac4a-d572-4b12-ac77-375876c942e9:0,(4c971619-bfb2-488c-85e7-862fcfe8b953:0,(4c4fee84-3c27-4131-869a-ea31c5d0a567:0,(4c3b34f6-ad61-4e27-984b-110dd9b8d184:0,(4b4fb477-27b2-4d31-802e-3008daae09c8:0,(4b30b072-a005-4c76-a5b3-882f28ec0c42:0,(4aef725d-50e8-43e7-b853-f849b85f30c2:0,(4acb5d6d-f30a-4450-bd4f-bdcc19ad6937:0,(4a1b6220-5e73-4c48-b53d-556c50a47b2d:0,(49fab83b-0211-47f1-b18b-41843778b7e3:0,(499d8f31-4b1f-499f-bc62-7243a3ad3a99:0,(4934b9e1-2fd7-47d9-9976-752fe3bedec1:0,(492b0169-1065-4b7d-b891-87800262040c:0,(49249fdd-0225-471c-89b7-b40342395a17:0,(48ad8bdb-96a1-4ba4-80ca-7e7a7d3d44fd:0,(4856a35d-e132-4d89-a269-22ff2ebbb29d:0,(4833b5ea-322c-4cb9-b909-26449a6441be:0,(481c3430-25fe-437b-82b5-914b7a3327b7:0,(47da627f-1c1f-4f59-b080-0cf7eb10467a:0,(479616d1-c276-4a54-a07b-08a45d8a3d86:0,(47211acd-615a-4d0b-b01d-2c41c073e31c:0,(46c80301-c62c-4ad0-a1b9-eafae84574b0:0,(46b8ec8d-be3b-490d-aea3-29e0c1b96163:0,(46782ef2-c6eb-49bd-8de2-d8232ad7f4a0:0,(46504219-8400-4d3b-8b0f-f8972c057783:0,(44c7ffb7-6f25-4378-897e-31075f5f8130:0,(4488bd65-1684-47b8-88bc-e621d2bf8111:0,(44528a7b-b7c3-4d99-9f2e-8885b7fe2041:0,(441ec5bd-f529-4bdd-bdef-5971b21425ec:0,(44067f74-4ecb-467b-bcb6-e49cad80b164:0,(43b17cfb-a265-4117-843e-27ec8026f3b2:0,(435fb9e8-c58f-4cdb-9903-04eb7523d56f:0,(43119ff4-f705-43ec-889f-fe399adc8ec1:0,(42e842c6-5584-4b97-bb2c-cb2a8fbb09cd:0,(428197ac-047a-44b6-af1b-fe7306643f77:0,(4195abc6-294a-432e-bae1-462dc2ddafd5:0,(412086f7-80f0-4649-aeda-68f259a65e65:0,(411f2890-81b3-4728-8450-d5ef61e9ebd3:0,(411bd7b8-39e7-42e0-b26b-9b6e123d1836:0,(411a1cd2-a90b-4a76-b251-da428c563f98:0,(40dd585c-cb35-428d-9184-114cecbd34f3:0,(4090b874-2af7-4d0a-9f76-1334b8aed713:0,(408a0c58-de75-4b96-9ac1-6766f88aaf8c:0,(401b0d75-844f-4151-9133-dfdabfaba1b4:0,(3fa556f8-6c96-4762-a402-cdf9f5fc8883:0,(3f10d247-95ad-49b0-bf3c-b1a4ca61fd56:0,(3e904bcf-6c79-4928-ba0f-21494597e4e9:0,(3e5244e0-3e5f-4aee-b81c-dcd0c8d865e2:0,(3df88d90-5aa0-4680-9b26-9d34cd032e5e:0,(3d7cac27-6c1a-4c82-92e1-b9f1b9061f65:0,(3cde3db7-0c48-4038-86e7-315899ad2744:0,(3bf7508d-d1fd-4924-9a55-28cc5acad7ba:0,(3b01012b-9f51-481e-a873-c394739a830e:0,(3ab3dd06-cf21-4ae4-b0b5-ef1514434248:0,(3a90e7a1-51e7-4cdf-bea0-f95f1226ae75:0,(3a773f27-ffd7-4db2-a185-b9f6e8dba6f4:0,(3a3e9df3-52e4-4416-99bd-113c936bae8e:0,(3a17f1d8-7be4-4915-8a6d-5c9ad4751bdc:0,(3a018abf-2035-454d-8077-848cc73178c4:0,(39fb4f91-ba59-49af-9666-019673759919:0,(39f0af3b-1439-45cd-9679-150fbaa75150:0,(39d5df5f-71a0-414f-b6a8-d4f31e786204:0,(3909ed2f-a2ca-4bd9-a845-35466fb2f0c6:0,(38fa80b1-7e63-41dc-85d3-48dd90f0117b:0,(377cec05-f219-430c-a35d-46433c9d13fb:0,(3702c329-543a-4347-8789-8b2367e55eb4:0,(36dfc5ec-6810-487d-9bd9-fc4c5ad9b3fe:0,(36d34a19-5e20-4efd-b170-0cfabf1a9f14:0,(36cfffc4-dedc-4e3b-9a21-595010d2fa3c:0,(36c4983c-2489-4ec7-9ae4-c6d3cf918cda:0,(36913f3b-82f8-429d-ba42-b082c1eca225:0,(35f4da9e-355a-49b6-9e2a-966569e50d0f:0,(35efafd1-b7e2-4109-846d-7cf46d0682a3:0,(353e78b5-a8e3-4929-aa81-dcee0f79e36d:0,(34daadf0-df47-43cf-ad5b-9c3d2dd2fd44:0,(34a7e8dc-48db-4f07-bcdb-9767890d4c28:0,(34889bb2-ef66-48c5-9719-4e515a8656ec:0,(3431c262-bd09-4047-bcf7-526ad6503fd8:0,(33e588bc-aff6-47a1-af29-2179d4e8cc46:0,(33a7ab98-1f08-4ba0-86a1-55bf0e235597:0,(33a454b5-cd9f-487b-ac00-35ef8e26ab3a:0,(339a8f35-e896-4c18-be89-96acbe2eb090:0,(339156cd-559a-495b-874e-71668c6d7c42:0,(3356c208-28f0-49dd-8eff-7c7880c34415:0,(32e60ec5-5a2c-4bce-924b-f3eb8e108e65:0,(329a15d1-61de-41dc-8092-00a0bf782b58:0,(327852b4-a251-48e0-bdcc-0428c1be819b:0,(3235ea9d-b17a-4bce-8bef-b55889f6364e:0,(31fd2230-467b-44bf-a0b3-8e1d4f955412:0,(31708234-e852-4f93-b864-7e6ee8c242f6:0,(31029c4a-63bc-499d-8e76-e820557f7ec7:0,(30708265-b3e5-4048-96dd-8e4eb3c2bb4b:0,(305dfe6a-9981-4537-bbdc-daf88484c9da:0,(303f6c21-0b3b-4d5d-bac8-3afad0eb5ad5:0,(3016177e-7388-4cb2-ae5e-cb8df8badb30:0,(300c0de1-176f-4241-816e-558754dd4b6c:0,(2fc7b279-504f-4f7f-94e6-a8108c76d243:0,(2fc04b6c-53a6-4925-87e1-b947b8341003:0,(2fb80602-bae2-4ac0-8a12-175960c02494:0,(2fa66283-de4f-4764-b9c0-be3fe30dfed4:0,(2f998edf-7bda-4a39-8073-ca7beb542d45:0,(2f677617-997b-4ecb-9de7-4ae60c7e28f4:0,(2ee9cfa3-443b-4b25-a5d4-901c22cbae77:0,(2ed9a3a6-d948-4192-807d-475c32d1a9bb:0,(2e987452-a130-49bc-89f7-e15b62069833:0,(2e8c187b-4725-4f90-a38c-154cca134a72:0,(2e505b15-f970-46af-94ba-793385946b63:0,(2d6a1d35-d602-4019-b5cb-202a14503d9f:0,(2d3075c8-393c-4bd8-a3ac-8b69691203e8:0,(2d0b0db9-1dc7-4fd7-9a41-c088922102b0:0,(2cb95cb2-e704-466c-a45c-4bdd4d933f4b:0,(2c874aba-c391-4966-82ad-c033cc7d33cd:0,(2c603005-fff5-4b9a-bab4-896b1aa6b787:0,(2c4bc259-c35b-4201-bb65-3c4df9c73310:0,(2c2fab62-fffc-43f7-9487-d86d9709d8c3:0,(2bff3c9f-0a47-44bb-94f7-95bbde9e395f:0,(2bc399fa-f3c9-44dc-aebb-59e336e3fd1d:0,(2b95f432-7575-40bd-8f5a-e79c280b5158:0,(2b8241fe-ddae-4970-bd55-3bd3555f013d:0,(2b475a68-8f14-4945-9c52-4230120acf92:0,(2b455b9e-6a13-4744-9097-3e587fbc5d8e:0,(2b05e280-4e4c-4108-afad-e89cb82c6d61:0,(2b0271a3-59e5-41ea-9ef1-21a9fde8f692:0,(2a931af8-4bc3-4d6b-8fd2-a2919a072ec2:0,(2a78c1ad-df11-48d3-8de1-0327f4c273b0:0,(2a37ba1e-5e24-48b2-93a4-23734117128a:0,(29989438-9878-4d34-8018-c9712e98a11c:0,(288e17b4-243b-45cf-9483-c09f47b16331:0,(287efe08-febd-4e7e-b423-3a8ce4f64860:0,(2829529d-192c-47b6-a004-68cdf459bb84:0,(27999cd4-0650-4d14-977c-680bf459b0e3:0,(272c79ea-dadf-4693-a7e1-60455c223675:0,(26b2b3ab-23bb-4d16-bb18-4a75d9b40889:0,(269f27e1-51de-4c2c-934c-1f18f6982465:0,(2653fa2e-38a4-47f2-8041-fa870d18375d:0,(264b364c-9d08-45d2-944e-c8884137dfa8:0,(26445829-e0fc-4444-ad9e-29cf7510ddd6:0,(25cd0fb0-1dc1-43d6-80aa-ca9414bd0ad3:0,(25ab9847-03ec-4aff-978e-f1a31a597005:0,(25a02587-ba55-4d40-910d-6e09e5c451cd:0,(250ab4cd-08ee-45f1-a259-4dc977495966:0,(250808ce-59cb-4f7b-854f-8749a3ba37c2:0,(24d64c89-e305-48b8-89e1-286f73e68e74:0,(24acebb9-7dd7-4785-9e57-9017b33437db:0,(23cdb4f8-31bd-4c1b-b0db-f8dab19dcc0c:0,(235c287c-abdb-40f4-a286-ffc104cd2097:0,(22641113-5e9b-4a9d-a281-bf49dd434674:0,(21d9ce64-b3a8-46da-90e5-f6e60b5ac37d:0,(219e5aea-6529-486c-ac60-867e550d9b03:0,(2167a6a7-d68f-4783-98e2-e1373cc2be91:0,(212b47ed-d6c3-4b1b-8b39-5294d45444ad:0,(2112340a-8ff9-4abf-8c74-136b2ac71384:0,(20732634-6e26-4c50-8d7b-c76d50f3099a:0,(2017b29c-4fb6-48d8-91df-b361b954e0ba:0,(20113d3e-af9d-4458-9809-9f3436722893:0,(200f08c8-ca46-409c-a73e-dd76c9ad534c:0,(1fae9632-62f0-4517-9322-d0ed8b27c848:0,(1f9e3ba8-d23b-4312-9de0-e77c9c091739:0,(1f25ddba-29c4-4a6c-8d1c-620e133ec5df:0,(1f0cc274-1342-41d6-bbb3-ca69ae45e1eb:0,(1ecc0c86-d9ea-4c1f-8ccb-92166421c20a:0,(1e9efc56-66a2-4b31-9096-6293a918aff0:0,(1e46518a-0ab0-4ed7-9788-b860a7db1649:0,(1d4383f9-b6b1-4456-92c6-d35083b5c7b9:0,(1d16519e-dbd7-4aa8-aafb-c3fb71835016:0,(1cd0211c-c7ca-401c-a1cb-11bf16dfd7e1:0,(1cadc795-ac11-469c-a00e-59c780604ea0:0,(1ca50b01-08da-4533-b7f4-da8b65533777:0,(1be09c5e-bb39-4178-8f41-dccbfb87edae:0,(1b6b0452-33d2-46ec-8857-29ce9449c0ee:0,(1ad77076-9ed6-4b81-935f-11840ec15908:0,(19fc0400-f7ac-4f40-9c60-d7666d5e55ba:0,(19bb61d0-1237-474f-ae24-ced68c8f74a7:0,(1989abcb-d7f6-4dc6-b2e4-caab47fccb38:0,(192a69fe-a5d0-46f7-b75f-4d72b4f93a67:0,(187782b1-64a0-4022-8cff-31ff49375c4b:0,(186dd603-5f5f-4fb8-bbb7-fc9c65efb1cb:0,(185b70b5-a2c2-4e33-b01b-f1da44ee0cd5:0,(184091e1-4ac0-4849-ac0e-e483d8846fd2:0,(17e677e9-7d8d-4e8b-b3ae-e5aadd5ae514:0,(178e464e-93da-4181-9b4f-e4d7833e6406:0,(17157a4c-d985-4343-9aaa-5f939b6bd995:0,(16fbc967-bc3a-4c87-8a36-4ed08e124c96:0,(1515e6c0-b828-4391-a7b5-cba8fde9d9fa:0,(14668224-ccad-484b-869b-3baf9fe4f5e3:0,(143dc951-2b79-4339-b2a6-2bb73420fd14:0,(142e8e4a-1142-4f79-9911-28936541297c:0,(1419fd19-2d1b-4954-a13a-38e043cb150b:0,(14181035-d2bc-4284-946b-1159b357960f:0,(13a80b94-cf38-4d32-ab4f-8fab3e0c2a14:0,(1376fdc0-a7ee-48b4-b8c2-2d54fa4641c2:0,(131cad40-6b31-4a8a-be34-4059a6a6d230:0,(130b515b-209a-4603-b1f7-5e6c621dfd19:0,(12df167e-3ed7-4bc9-b5b8-22822679b09a:0,(12bdc0bd-9344-44c5-97b7-e8e2531989c9:0,(1288c01e-f5b8-4204-935b-eb168f33ca49:0,(1248718c-db1b-40af-ac55-e1adc27daa6c:0,(12111065-07c6-45e0-bdf9-628491668a22:0,(11ca0b96-da1d-4c54-b7f1-2bd6febb5266:0,(11c9c68e-9012-4d8c-99b7-90f3e4154525:0,(113f3459-ed51-4101-97e8-44897f65f358:0,(10a365d0-5491-489f-9112-ead98ff02e86:0,(10718890-be31-4a88-8631-fc6edbaa4e79:0,(10415fcc-ec9d-4363-9333-22806b0c9a9b:0,(1033ae08-1605-4b50-a6ae-5016f9ae5c0c:0,(0ff95a12-06b0-49e7-81b8-feb2682dfc13:0,(0ff182ca-da13-4534-88f3-b975175eeff6:0,(0fce23fb-9566-4839-9d0a-a3900c3c3b54:0,(0f11b0ca-27ef-4e61-9706-9b129dc17a6b:0,(0eae3c8c-f7d0-42aa-ac90-ccee0f2915f6:0,(0dd3fa72-1c86-4fa1-97ca-c05c22535b35:0,(0dd3a8bd-29f3-4403-871a-3b0e1c16da71:0,(0dc51119-cbc9-4d42-8aca-e6dcd73f46ec:0,(0da2ab33-f0a6-4fc7-9b66-961546c3a672:0,(0d7596d6-63c3-4167-9add-86657991e60a:0,(0d3b528c-9235-4188-8fe1-96ae541b4082:0,(0cea2ff5-a321-4464-bace-1353c14a18fb:0,(0ce54772-4299-45f1-a6e8-0427231c551d:0,(0c68883e-7358-4b8a-9c35-0a327a93abab:0,(0bae0cd0-e02f-45a8-958f-8001232f38c4:0,(0a80af99-3024-4a4c-9496-c063a0e34057:0,(0a61a4a3-8cbc-4aad-93e5-b077155f262b:0,(09dd5a72-22eb-48c8-a098-e2ec9520e4c4:0,(09db4832-8b34-4401-a016-a6c67df64de8:0,(094df432-8e9e-4bdc-a528-db44e6ad4aa4:0,(090c2fc7-f126-4ba5-af5a-85e9e9966c16:0,(08dbcf8b-0ec3-4270-9124-708a1d3ba259:0,(086dcbd5-e725-41c3-b4fb-12373686ae6b:0,(07ff82cd-145b-452b-8b9e-715cd6f8f681:0,(07c90ee9-a404-4639-953c-735fa43adc4a:0,(07c48788-ed7c-4589-b74a-089096512172:0,(078051ed-df37-475e-a943-96d411193b09:0,(070cdf82-46d7-474a-a23c-0df43c2c8f5a:0,(06d13339-57ae-410e-b9dc-ba34b9049fc9:0,(05644890-1ae3-47c9-8b7a-eda693b51ea8:0,(04ea42b9-e4cb-4e66-b50b-4bf68ffeb94a:0,(02cf16e2-9e11-4cfc-8d8b-be79d3e8b619:0,(02ae4d48-32b0-43a6-aa99-f243b5df2058:0,(023c03bb-ff94-490e-a1fe-13cd4013b6f8:0,(01191b06-9d2f-4d86-9d8f-dbc7af6b0d02:0,(01113241-9062-451e-b764-6bff88b2c044:0,(00f19714-4104-47f7-94fd-186c9b307b84:0,00105798-327f-4c83-a006-2969cee59902:0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0):0,ffcfd4ac-de26-47eb-a811-f7b508db8c26:0,ffd8e146-1fb1-4611-9f24-813447e0868f:0);"""
        
        ## Two positive controls which should work
        # read a small tree
        smallTree=ete3.Tree(smallTreeText)
        for (i,node) in enumerate(smallTree):
            pass
        self.assertEqual(i,3)
                
        # read a medium tree
        mediumTree=ete3.Tree(mediumTreeText)
        for (i,node) in enumerate(mediumTree):
            pass
        self.assertEqual(i,237)
        
        # This tree reproduces issue 258
        # read a large tree 
        largeTree=ete3.Tree(largeTreeText)
        for (i,node) in enumerate(largeTree):
            pass
        self.assertEqual(i,1506)        

if __name__ == '__main__':
        unittest.main()            ## test everything
        exit()
        
