/*
* Copyright 2025 wooyechan
*/
// SPDX-License-Identifier: Apache-2.0

#pragma once

#include <array>

namespace ZXing::OneD::Code93 {

constexpr std::array<std::array<int, 6>, 48> CODE_PATTERNS = { {
	{ 1, 3, 1, 1, 1, 2 }, // 0
	{ 1, 1, 1, 2, 1, 3 },
	{ 1, 1, 1, 3, 1, 2 },
	{ 1, 1, 1, 4, 1, 1 },
	{ 1, 2, 1, 1, 1, 3 },
	{ 1, 2, 1, 2, 1, 2 }, // 5
	{ 1, 2, 1, 3, 1, 1 },
	{ 1, 1, 1, 1, 1, 4 },
	{ 1, 3, 1, 2, 1, 1 },
	{ 1, 4, 1, 1, 1, 1 },
	{ 2, 1, 1, 1, 1, 3 }, // 10
	{ 2, 1, 1, 2, 1, 2 }, 
	{ 2, 1, 1, 3, 1, 1 },
	{ 2, 2, 1, 1, 1, 2 },
	{ 2, 2, 1, 2, 1, 1 },
	{ 2, 3, 1, 1, 1, 1 }, // 15
	{ 1, 1, 2, 1, 1, 3 },
	{ 1, 1, 2, 2, 1, 2 },
	{ 1, 1, 2, 3, 1, 1 },
	{ 1, 2, 2, 1, 1, 2 },
	{ 1, 3, 2, 1, 1, 1 }, // 20
	{ 1, 1, 1, 1, 2, 3 },
	{ 1, 1, 1, 2, 2, 2 },
	{ 1, 1, 1, 3, 2, 1 },
	{ 1, 2, 1, 1, 2, 2 },
	{ 1, 3, 1, 1, 2, 1 }, // 25
	{ 2, 1, 2, 1, 1, 2 },
	{ 2, 1, 2, 2, 1, 1 },
	{ 2, 1, 1, 1, 2, 2 },
	{ 2, 1, 1, 2, 2, 1 },
	{ 2, 2, 1, 1, 2, 1 }, // 30
	{ 2, 2, 2, 1, 1, 1 },
	{ 1, 1, 2, 1, 2, 2 },
	{ 1, 1, 2, 2, 2, 1 },
	{ 1, 2, 2, 1, 2, 1 },
	{ 1, 2, 3, 1, 1, 1 }, // 35
	{ 1, 2, 1, 1, 3, 1 },
	{ 3, 1, 1, 1, 1, 2 },
	{ 3, 1, 1, 2, 1, 1 },
	{ 3, 2, 1, 1, 1, 1 },
	{ 1, 1, 2, 1, 3, 1 }, // 40
	{ 1, 1, 3, 1, 2, 1 },
	{ 2, 1, 1, 1, 3, 1 },
	{ 1, 2, 1, 2, 2, 1 },
	{ 3, 1, 2, 1, 1, 1 },
	{ 3, 1, 1, 1, 2, 1 }, // 45
	{ 1, 2, 2, 2, 1, 1 },
	{ 1, 1, 1, 1, 4, 1 }  // STOP_CODE
} };

} // namespace ZXing::OneD::Code93
