/*****************************************************************************/
/*									     */
/*									     */
/*	X patience - xpm.c						     */
/*									     */
/*	written by Heiko Eissfeldt and Michael Bischoff			     */
/*									     */
/*	24-Feb-1993: First release (0.1)				     */
/*									     */
/*									     */
/*****************************************************************************/

#include "xpat.h"
#include "xpatx11.h"

#include <X11/Intrinsic.h>	/* to avoid "redefinition of pixel" error */

#ifndef NO_XPM
#include <xpm.h>
#endif
#ifndef NO_ROUND_CARDS
#include <X11/Xmu/Drawing.h>
#endif

void write_pixmap(const char *filename, Pixmap pict, Pixmap clip)
{
#ifndef NO_XPM
    if (XpmWriteFileFromPixmap(dpy, filename, pict, clip, NULL) != XpmSuccess)
        fprintf(stderr, "error writing xpm file %s\n", filename);
#endif
}

int read_pixmap(const char *filename, Pixmap *pict)
{
#ifndef NO_XPM
    if (XpmReadFileToPixmap(dpy, table, filename, pict, NULL, NULL) == XpmSuccess) {
	/* add nice outline which may vary (-cround option) */
#ifndef NO_ROUND_CARDS
	if (ROUND_W)
	    XmuDrawRoundedRectangle(dpy, *pict,
	        blackgc, 0, 0, CARD_WIDTH-1, CARD_HEIGHT-1, ROUND_W, ROUND_H);
	else
#endif
	    XDrawRectangle(dpy, *pict, blackgc,
			   0, 0, CARD_WIDTH-1, CARD_HEIGHT-1);
	return 1;
    }
#endif
    *pict = 0;
    return 0;
}
