/*
 * Copyright (c) 1993-1994 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and the Network Research Group at
 *      Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: grabber-mme.cc,v 1.7 94/11/28 22:05:01 mccanne Exp $ (LBL)";
#endif

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <osfcn.h>
#include <sys/file.h>
#include <sys/stat.h>

extern "C" {
/*XXX*/
#undef VOID
#include <mme/mme_api.h>
}

#include "inet.h"
#include "Tcl.h"
#include "framer-jpeg.h"
#include "packet.h"

extern "C" {
#include <tcl.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#ifdef mips
#include <mips/cachectl.h>
int cacheflush(char* addr, int len, int cache);
#endif
#ifdef __osf__
int shmget(key_t, u_int, u_int);
#endif
}

class MmeGrabber : public Grabber, public IOHandler, public Timer {
public:
	MmeGrabber(Tcl&, JpegFramer*, int qFactor);
	virtual ~MmeGrabber();
	virtual void start();
	virtual void stop();
	virtual void fps(int);

	virtual int command(int argc, char** argv);

	/*
	 * This structure should be private,
	 * but DEC's C++ compiler cannot hack it.
	 */
	struct dmabuf {
		int shmid;
		u_char* bp;
	};
protected:
	virtual void dispatch(int mask);
	virtual void timeout();
	virtual const char* type() const;
private:
	int mme_error(MMRESULT, const char* msg) const;
	void init();
	static int server_;	/* fd of server socket */
	HVIDEO handle_;		/* handle for video connection */
	VIDEOHDR* vh_;
	static void mme_callback(HVIDEO handle, DWORD code, DWORD instance,
				 LPARAM p1, LPARAM p2);
	int callback(int code, VIDEOHDR*);
	void grab();
	void waitgrab();
	int mapq(int q) const;

	int field_width_;
	int field_height_;
	int quantization_;
	int nq_;

	int maxfps_;
	int running_;
	JpegFramer* framer_;
};

class MmeDevice : public Device {
 public:
	virtual int match(const char* type) const;
	virtual int default_format() const;
	virtual Grabber* jpeg_grabber(Tcl&, JpegFramer*, int q);
#ifdef notyet
	virtual Grabber* yuv_grabber(Tcl&, YuvEncoder*);
#endif
};

static MmeDevice mme_device;

/*XXX*/
MmeGrabber* mmeMaster;

int MmeDevice::default_format() const
{
	return (RTPCONT_JPEG);
}

int MmeDevice::match(const char* type) const
{
	return (strcasecmp(type, "mme") == 0);
}

virtual Grabber* MmeDevice::jpeg_grabber(Tcl& t, JpegFramer* p, int q)
{
	return (new MmeGrabber(t, p, q));
}

inline int MmeGrabber::mme_error(MMRESULT code, const char* msg) const
{
	if (code != DV_ERR_OK) {
		fprintf(stderr, "vic: %s (%d)\n", msg, code);
		return (1);
	}
	return (0);
}

MmeGrabber::MmeGrabber(Tcl& tcl, JpegFramer* p, int q)
	: Grabber(tcl), quantization_(q), nq_(q), framer_(p)
{
	mmeMaster = this;

	format_ = RTPCONT_JPEG;
	/*XXX defer videoOpen until start? */
	if (videoGetNumDevs() <= 0 || 
	    videoOpen(&handle_, 0, VIDEO_IN) != DV_ERR_OK) {
		valid_ = 0;
		return;
	}
	valid_ = 1;
	running_ = 0;

	/*XXX*/
	maxfps_ = 15;
	field_width_ = 320;
	field_height_ = 240;
	framer_->setparams(quantization_, 320, 240);
	fps(5);
	init();
}

MmeGrabber::~MmeGrabber()
{
	if (valid_) {
		if (running_)
			stop();
#ifdef notdef
		freedma(cb0_);
		freedma(cb1_);
#endif
		mmeFreeMem(vh_);
		videoClose(handle_);
	}
}

const char* MmeGrabber::type() const
{
	return ("mme");
}

int MmeGrabber::server_ = -1;

void MmeGrabber::init()
{
	struct info {
		EXBMINFOHEADER b;
		JPEGINFOHEADER jpeg;
	} *bmh;
	int size;
	MMRESULT s;

	/*
	 * Allocate some memory for the video header and bitmap
	 * info header.  We can share this memory since it will
	 * be used at disjoint times.
	 */
	size = sizeof(*vh_) > sizeof(*bmh) ? sizeof(*vh_) : sizeof(*bmh);
	bmh = (info*)mmeAllocMem(size);
	if (bmh == 0) {
		fprintf(stderr, "vic: cannot allocate mme memory\n");
		valid_ = 0;
		return;
	}
	memset(bmh, 0, sizeof(*bmh));
	bmh->b.bmi.biSize = sizeof(*bmh);
	bmh->b.bmi.biWidth = 320;/*XXX*/
	bmh->b.bmi.biHeight = 240;/*XXX*/
	bmh->b.bmi.biPlanes = 1;
	bmh->b.bmi.biBitCount = 24;
	bmh->b.bmi.biCompression = MJPG_DIB; /*XXX*/
	bmh->b.biExtDataOffset = sizeof(bmh->b);
	bmh->jpeg.JPEGSize = sizeof(bmh->jpeg);
	bmh->jpeg.JPEGProcess = JPEG_PROCESS_BASELINE;
	bmh->jpeg.JPEGColorSpaceID = JPEG_YCbCr;
	bmh->jpeg.JPEGBitsPerSample = 8;
	bmh->jpeg.JPEGHSubSampling = 2;/*XXX*/
	bmh->jpeg.JPEGVSubSampling = 1;/*XXX*/

	s = videoConfigure(handle_, DVM_FORMAT,
			   VIDEO_CONFIGURE_GET|VIDEO_CONFIGURE_MIN,
			   0, bmh, sizeof(*bmh), 0, 0);
	size = bmh->b.bmi.biSizeImage;/*XXX ridiculously large*/
	s = videoConfigure(handle_, DVM_FORMAT, VIDEO_CONFIGURE_SET,
			   0, bmh, sizeof(*bmh), 0, 0);
	if (mme_error(s, "couldn't configure mme"))
		goto bail;

	/*
	 * Done with bmh.  Use that memory for the video header.
	 */
	vh_ = (VIDEOHDR*)bmh;
	memset(vh_, 0, sizeof(*vh_));
#ifdef notdef
	size = 320 * 240 * 3;
#endif
	vh_->lpData = (LPSTR)mmeAllocBuffer(size);
	if (vh_->lpData == 0) {
		fprintf(stderr, "vic: couldn't allocate mme frame memory\n");
		goto bail;
	}
	vh_->dwBufferLength = size;

	if (server_ < 0) {
		server_ = mmeServerFileDescriptor();
		link(server_, TK_READABLE);
	}

	s = videoSetBrightness(handle_, 6000);
	(void)mme_error(s, "couldn't set brightness");

	return;
 bail:
	mmeFreeMem(bmh);
	videoClose(handle_);
	vh_ = 0;
	valid_ = 0;
	/*XXX*/
}

void MmeGrabber::fps(int v)
{
	Grabber::fps(v);
	/*XXX ignore for now*/
}

void MmeGrabber::start()
{
	if (running_)
		return;

	quantization_ = nq_; /*XXX*/
	MMRESULT s;
	s = videoSetQuality(handle_, mapq(quantization_));
	(void)mme_error(s, "couldn't set quality");
	s = videoStreamInit(handle_, 1000000/*10fps*/,
			    (void (*)())mme_callback,
			    0, CALLBACK_FUNCTION);
	if (mme_error(s, "couldn't initialize mme stream\n"))
		return;
	s = videoStreamPrepareHeader(handle_, vh_, sizeof(*vh_));
	if (mme_error(s, "couldn't prepare mme video hdr"))
		return;
	s = videoStreamStart(handle_);
	if (mme_error(s, "couldn't start mme video stream\n"))
		return;
	running_ = 1;
	frameclock_ = gettimeofday();
	grab();
}

void MmeGrabber::stop()
{
	if (!running_)
		return;

	MMRESULT s;
	s = videoStreamStop(handle_);
	(void)mme_error(s, "couldn't stop mme stream");
	s = videoStreamReset(handle_);
	(void)mme_error(s, "couldn't reset mme stream");
	/*
	 * XXX should do unprepare first, but we need to use this
	 * order to work around bug in libmme.
	 */
	s = videoStreamFini(handle_);
	(void)mme_error(s, "couldn't shutdown mme stream");
	s = videoStreamUnprepareHeader(handle_, vh_, sizeof(*vh_));
	(void)mme_error(s, "couldn't unprepare mme video header");
	running_ = 0;
}

int wantgrab;

extern "C" {
void MmeGrabber::mme_callback(HVIDEO handle, DWORD code, DWORD instance,
			      LPARAM vh, LPARAM p2)
{
#ifdef notyet
	MmeGrabber* p = (MmeGrabber*)instance;
	p->callback();
#else
	(void)mmeMaster->callback(code, (VIDEOHDR*)vh);
#endif
}
}

int MmeGrabber::callback(int code, VIDEOHDR* vh)
{
	/*XXX*/
	if (code != MM_DRVM_DATA) {
		printf("vic: mme callback code %d\n", code);
		return (0);
	}
	if (vh->lpData != vh_->lpData)
		printf("different buffer\n");
		
	if ((vh->dwFlags & VHDR_DONE) == 0)
		fprintf(stderr, "vic: mme callback: done bit 0\n");

	/*
	 * XXX We should get timestamps from mme.
	 */
	int length = vh->dwBytesUsed; /*this right?*/
	u_char* p = (u_char*)vh->lpData;
	int n = framer_->send(p, length, ntptime());
	/*XXX don't need to derive from Timer since we can
	  use rate specified in video stream start method*/
#ifdef notyet
	if (fps_ != maxfps_ || bps_ < 1024000)
		usched(tick(n));
#endif
	wantgrab = 1;
	return (1);
}

int MmeGrabber::mapq(int q) const
{
	return (10000 - (q * 10000 / 512));
}

void MmeGrabber::grab()
{
	if (nq_ != quantization_) {
		quantization_ = nq_;
		MMRESULT s = videoSetQuality(handle_, mapq(quantization_));
		framer_->setparams(quantization_,
				   field_width_,
				   field_height_);
		(void)mme_error(s, "couldn't set quality\n");
	}
#ifdef notdef
	cb_ = (cb_ == cb0_) ? cb1_ : cb0_;
#endif
	MMRESULT s;
	s = videoStreamAddBuffer(handle_, vh_, sizeof(*vh_));
	(void)mme_error(s, "couldn't queue mme buffer");
}

void MmeGrabber::dispatch(int mask)
{
	while (mmeCheckForCallbacks())
		mmeProcessCallbacks();
	if (wantgrab) {
		wantgrab = 0;
		mmeMaster->grab();
	}
}

void MmeGrabber::timeout()
{
}

int MmeGrabber::command(int argc, char** argv)
{
	abort();
}
