/*
** rots.h - For the finger distribution.
**
** Written by Keith Gabryelski
** Released into public domain September 1, 1988.
** Please keep this header.
**
** Some basic routines for most programs in the distribution.
*/

#include <stdio.h>
#include <errno.h>

extern int errno, sys_nerr;
extern char *sys_errlist[];
extern char *malloc(), *realloc();

extern *progname;

char *puterr();

char *
mymalloc(size)
unsigned size;
{
    char *p;

    if ((p = malloc(size)) == NULL)
    {
	(void) fprintf(stderr, "%s: Out of memory.\n", progname);
	exit(-1);
    }

    return p;
}

char *
myrealloc(p, size)
char *p;
unsigned size;
{
    if (p == NULL)
    {
	if ((p = malloc(size)) == NULL)
	{
	    (void) fprintf(stderr, "%s: Out of memory.\n", progname);
	    exit(-1);
	}
    }
    else if ((p = realloc(p, size)) == NULL)
    {
	(void) fprintf(stderr, "%s: Out of memory.\n", progname);
	exit(-1);
    }

    return p;
}

strnlen(string, length)
char *string;
int length;
{
    register i;

    for (i=0; i < length; ++i)
	if (*string++ == '\0')
	    break;

    return i;
}

char *
puterr(error)
int error;
{
    static char qwerty[42];

    (void) sprintf(qwerty, "Unknown error %d", error);

    return ((unsigned)error >= sys_nerr) ? qwerty : sys_errlist[error];
}
