/* ftp.h */

#ifndef _ftp_h_
#define _ftp_h_

#define IS_FILE 1
#define IS_STREAM 0
#define IS_PIPE -1

/* Progress-meter types. */
#define pr_none 0
#define pr_percent 1
#define pr_philbar 2
#define pr_kbytes 3

int hookup(char *host, int port);
int login(char *, int, int);
void cmdabort(int unused);
int command(char *cmd);
int getreply(int expecteof);
void abortsend(int unused);
void sendrequest(char *cmd, char *local, char *remote);
void abortrecv(int unused);
void recvrequest(char *cmd, char *local, char *remote, char *mode);
int initconn(void);
FILE *dataconn(char *mode);
void close_file(FILE **fin, int filetype);
long get_remote_size(char *remote, int filetype);
int start_progress(int sending, char *local);
void progress_report(int);
void end_progress(char *direction, char *local, char *remote);

#endif /* _ftp_h_ */

/* eof ftp.h */
