#include "cs.h"                                       /*    MIDIOPS.C    */
#include "midiops.h"
#include <math.h>

static float f128 = 128.;
extern float *cpsocint, *cpsocfrc, octresol;
extern INSDS    *curip;  /* valid at I-time */

void notnum(p)      /* valid only at I-time */
 register MIDIVAL *p;
{
    *p->r = curip->m_pitch;
}

void veloc(p)      /* valid only at I-time */
 register MIDIVAL *p;
{
    *p->r = curip->m_veloc;
}

void pchmidi(p)
 register MIDIVAL *p;
{
    register INSDS *curip = p->h.insdshead;
    double fract, oct, ioct;
    oct = curip->m_pitch / 12. + 3.;
    fract = modf(oct, &ioct);
    fract *= 0.12;
    *p->r = ioct + fract;
}

void pchmidib(p)
 register MIDIVAL *p;
{
    register INSDS *curip = p->h.insdshead;
    double fract, oct, ioct;
    oct = (curip->m_pitch + curip->m_chnbp->pbendiff) / 12. + 3.;
    fract = modf(oct, &ioct);
    fract *= 0.12;
    *p->r = ioct + fract;
}

void octmidi(p)
 register MIDIVAL *p;
{
    register INSDS *curip = p->h.insdshead;
    *p->r = curip->m_pitch / 12. + 3.;
}

void octmidib(p)
 register MIDIVAL *p;
{
    register INSDS *curip = p->h.insdshead;
    *p->r = (curip->m_pitch + curip->m_chnbp->pbendiff) / 12. + 3.;
}

void cpsmidi(p)
 register MIDIVAL *p;
{
    register INSDS *curip = p->h.insdshead;
    register long  loct;
    loct = (curip->m_pitch / 12. + 3.) * octresol;
    *p->r = CPSOCTL(loct);
}

void cpsmidib(p)
 register MIDIVAL *p;
{
    register INSDS *curip = p->h.insdshead;
    register long  loct;
    loct = ((curip->m_pitch + curip->m_chnbp->pbendiff) / 12. + 3.) * octresol;
    *p->r = CPSOCTL(loct);
}

void ampmidi(p)           /* convert midi veloc to amplitude */
 register MIDIAMP *p;     /*   valid only at I-time          */
{
    float amp;
    long  fno;
    register FUNC *ftp;

    amp = curip->m_veloc / f128;                    /* amp = normalized veloc */
    if ((fno = *p->ifn) > 0) {
        if ((ftp = ftfind(p->ifn)) == NULL)         /* if valid ftable,       */
	    return;                                 /*     use amp as index   */
	amp = *(ftp->ftable + (long)(amp * ftp->flen));
    }
    *p->r = amp * *p->imax;                         /* now scale the output   */
}

void aftset(p)
 register MIDISCL *p;
{
    p->scale = *p->iscal / f128;
}

void aftouch(p)
 register MIDISCL *p;
{
    register INSDS *curip = p->h.insdshead;
    *p->r = curip->m_chnbp->katouch[curip->m_pitch] * p->scale;
}

void chpress(p)
 register MIDISCL *p;
{
    register INSDS *curip = p->h.insdshead;
    *p->r = curip->m_chnbp->chnpress * p->scale;
}

void pbenset(p)
 register MIDISCL *p;
{
    p->scale = *p->iscal;
}

void pchbend(p)
 register MIDISCL *p;
{
    register INSDS *curip = p->h.insdshead;
    *p->r = curip->m_chnbp->pbendiff * p->scale;
}

void imidictl(p)
 register MIDICTL *p;
{
    register INSDS *curip = p->h.insdshead;
    *p->r = curip->m_chnbp->pbendiff * p->scale;
    die("midictl not yet implemented");
}

void mctlset(p)
 register MIDICTL *p;
{
    register INSDS *curip = p->h.insdshead;
    *p->r = curip->m_chnbp->pbendiff * p->scale;
    die("midictl not yet implemented");
}

void midictl(p)
 register MIDICTL *p;
{
    register INSDS *curip = p->h.insdshead;
    *p->r = curip->m_chnbp->pbendiff * p->scale;
}

