/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class LockDetectMode {
    public static final LockDetectMode NONE = new LockDetectMode("NONE", 0);
    public static final LockDetectMode DEFAULT = new LockDetectMode("DEFAULT", 1);
    public static final LockDetectMode EXPIRE = new LockDetectMode("EXPIRE", 2);
    public static final LockDetectMode MAXLOCKS = new LockDetectMode("MAXLOCKS", 3);
    public static final LockDetectMode MAXWRITE = new LockDetectMode("MAXWRITE", 4);
    public static final LockDetectMode MINLOCKS = new LockDetectMode("MINLOCKS", 5);
    public static final LockDetectMode MINWRITE = new LockDetectMode("MINWRITE", 6);
    public static final LockDetectMode OLDEST = new LockDetectMode("OLDEST", 7);
    public static final LockDetectMode RANDOM = new LockDetectMode("RANDOM", 8);
    public static final LockDetectMode YOUNGEST = new LockDetectMode("YOUNGEST", 9);
    private String modeName;
    private int flag;

    static LockDetectMode fromFlag(int n) {
        switch (n) {
            case 0: {
                return NONE;
            }
            case 1: {
                return DEFAULT;
            }
            case 2: {
                return EXPIRE;
            }
            case 3: {
                return MAXLOCKS;
            }
            case 4: {
                return MAXWRITE;
            }
            case 5: {
                return MINLOCKS;
            }
            case 6: {
                return MINWRITE;
            }
            case 7: {
                return OLDEST;
            }
            case 8: {
                return RANDOM;
            }
            case 9: {
                return YOUNGEST;
            }
        }
        throw new IllegalArgumentException("Unknown lock detect mode: " + n);
    }

    private LockDetectMode(String string, int n) {
        this.modeName = string;
        this.flag = n;
    }

    int getFlag() {
        return this.flag;
    }

    public String toString() {
        return "LockDetectMode." + this.modeName;
    }
}

