/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.util.Date;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class NowFunction
implements Function {
    private static final long serialVersionUID = 4108282053598696841L;

    @Override
    public String getCanonicalName() {
        return "NOW";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        LocalizationContext localizationContext = context.getLocalizationContext();
        Date now = DateUtil.now(localizationContext);
        Date date = DateUtil.normalizeDate(now, (Type)DateTimeType.DATETIME_TYPE);
        return new TypeValuePair(DateTimeType.DATETIME_TYPE, date);
    }
}

