/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugUtilsLabelEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PLABELNAME;
    public static final int COLOR;

    public VkDebugUtilsLabelEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDebugUtilsLabelEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugUtilsLabelEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugUtilsLabelEXT.npNext(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pLabelName() {
        return VkDebugUtilsLabelEXT.npLabelName(this.address());
    }

    @NativeType(value="char const *")
    public String pLabelNameString() {
        return VkDebugUtilsLabelEXT.npLabelNameString(this.address());
    }

    @NativeType(value="float[4]")
    public FloatBuffer color() {
        return VkDebugUtilsLabelEXT.ncolor(this.address());
    }

    public float color(int index) {
        return VkDebugUtilsLabelEXT.ncolor(this.address(), index);
    }

    public VkDebugUtilsLabelEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugUtilsLabelEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugUtilsLabelEXT sType$Default() {
        return this.sType(1000128002);
    }

    public VkDebugUtilsLabelEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugUtilsLabelEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugUtilsLabelEXT pLabelName(@NativeType(value="char const *") ByteBuffer value) {
        VkDebugUtilsLabelEXT.npLabelName(this.address(), value);
        return this;
    }

    public VkDebugUtilsLabelEXT color(@NativeType(value="float[4]") FloatBuffer value) {
        VkDebugUtilsLabelEXT.ncolor(this.address(), value);
        return this;
    }

    public VkDebugUtilsLabelEXT color(int index, float value) {
        VkDebugUtilsLabelEXT.ncolor(this.address(), index, value);
        return this;
    }

    public VkDebugUtilsLabelEXT set(int sType, long pNext, ByteBuffer pLabelName, FloatBuffer color) {
        this.sType(sType);
        this.pNext(pNext);
        this.pLabelName(pLabelName);
        this.color(color);
        return this;
    }

    public VkDebugUtilsLabelEXT set(VkDebugUtilsLabelEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDebugUtilsLabelEXT malloc() {
        return (VkDebugUtilsLabelEXT)VkDebugUtilsLabelEXT.wrap(VkDebugUtilsLabelEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDebugUtilsLabelEXT calloc() {
        return (VkDebugUtilsLabelEXT)VkDebugUtilsLabelEXT.wrap(VkDebugUtilsLabelEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDebugUtilsLabelEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDebugUtilsLabelEXT)VkDebugUtilsLabelEXT.wrap(VkDebugUtilsLabelEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDebugUtilsLabelEXT create(long address) {
        return (VkDebugUtilsLabelEXT)VkDebugUtilsLabelEXT.wrap(VkDebugUtilsLabelEXT.class, (long)address);
    }

    @Nullable
    public static VkDebugUtilsLabelEXT createSafe(long address) {
        return address == 0L ? null : (VkDebugUtilsLabelEXT)VkDebugUtilsLabelEXT.wrap(VkDebugUtilsLabelEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDebugUtilsLabelEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDebugUtilsLabelEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDebugUtilsLabelEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugUtilsLabelEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDebugUtilsLabelEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDebugUtilsLabelEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDebugUtilsLabelEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkDebugUtilsLabelEXT mallocStack() {
        return VkDebugUtilsLabelEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugUtilsLabelEXT callocStack() {
        return VkDebugUtilsLabelEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugUtilsLabelEXT mallocStack(MemoryStack stack) {
        return VkDebugUtilsLabelEXT.malloc(stack);
    }

    @Deprecated
    public static VkDebugUtilsLabelEXT callocStack(MemoryStack stack) {
        return VkDebugUtilsLabelEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDebugUtilsLabelEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDebugUtilsLabelEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsLabelEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugUtilsLabelEXT.calloc(capacity, stack);
    }

    public static VkDebugUtilsLabelEXT malloc(MemoryStack stack) {
        return (VkDebugUtilsLabelEXT)VkDebugUtilsLabelEXT.wrap(VkDebugUtilsLabelEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugUtilsLabelEXT calloc(MemoryStack stack) {
        return (VkDebugUtilsLabelEXT)VkDebugUtilsLabelEXT.wrap(VkDebugUtilsLabelEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugUtilsLabelEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugUtilsLabelEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static ByteBuffer npLabelName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PLABELNAME)));
    }

    public static String npLabelNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)PLABELNAME)));
    }

    public static FloatBuffer ncolor(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)COLOR), (int)4);
    }

    public static float ncolor(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)COLOR + Checks.check((int)index, (int)4) * 4L);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npLabelName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PLABELNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void ncolor(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)COLOR), (long)(value.remaining() * 4));
    }

    public static void ncolor(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)COLOR + Checks.check((int)index, (int)4) * 4L, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLABELNAME)));
    }

    static {
        Struct.Layout layout = VkDebugUtilsLabelEXT.__struct((Struct.Member[])new Struct.Member[]{VkDebugUtilsLabelEXT.__member((int)4), VkDebugUtilsLabelEXT.__member((int)POINTER_SIZE), VkDebugUtilsLabelEXT.__member((int)POINTER_SIZE), VkDebugUtilsLabelEXT.__array((int)4, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PLABELNAME = layout.offsetof(2);
        COLOR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDebugUtilsLabelEXT, Buffer>
    implements NativeResource {
        private static final VkDebugUtilsLabelEXT ELEMENT_FACTORY = VkDebugUtilsLabelEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDebugUtilsLabelEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugUtilsLabelEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugUtilsLabelEXT.npNext(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pLabelName() {
            return VkDebugUtilsLabelEXT.npLabelName(this.address());
        }

        @NativeType(value="char const *")
        public String pLabelNameString() {
            return VkDebugUtilsLabelEXT.npLabelNameString(this.address());
        }

        @NativeType(value="float[4]")
        public FloatBuffer color() {
            return VkDebugUtilsLabelEXT.ncolor(this.address());
        }

        public float color(int index) {
            return VkDebugUtilsLabelEXT.ncolor(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugUtilsLabelEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000128002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugUtilsLabelEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pLabelName(@NativeType(value="char const *") ByteBuffer value) {
            VkDebugUtilsLabelEXT.npLabelName(this.address(), value);
            return this;
        }

        public Buffer color(@NativeType(value="float[4]") FloatBuffer value) {
            VkDebugUtilsLabelEXT.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(int index, float value) {
            VkDebugUtilsLabelEXT.ncolor(this.address(), index, value);
            return this;
        }
    }
}

