/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.ui;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.AnnotationProcessors;
import org.netbeans.modules.java.hints.ui.Bundle;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class AnnoProcessorGenerator
implements CodeGenerator.Factory {
    public List<? extends CodeGenerator> create(Lookup context) {
        ArrayList<Gen> ret = new ArrayList<Gen>();
        JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
        CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
        if (component == null || controller == null) {
            return ret;
        }
        TreePath path = (TreePath)context.lookup(TreePath.class);
        path = controller.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
        if (path == null) {
            return ret;
        }
        try {
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        }
        catch (IOException ioe) {
            return ret;
        }
        AnnotationProcessors.ProcessorHintSupport supp = new AnnotationProcessors.ProcessorHintSupport((CompilationInfo)controller, path);
        if (!supp.initialize()) {
            return ret;
        }
        if (!supp.canOverrideProcessor(true)) {
            return ret;
        }
        ret.add(new Gen(component, (ElementHandle<TypeElement>)ElementHandle.create((Element)supp.getProcessor())));
        return ret;
    }

    private static class Gen
    implements CodeGenerator {
        private final ElementHandle<TypeElement> handle;
        private final JTextComponent component;

        public Gen(JTextComponent component, ElementHandle<TypeElement> handle) {
            this.component = component;
            this.handle = handle;
        }

        public String getDisplayName() {
            return Bundle.GEN_AnnoProcessor_OverrideLatestSupported();
        }

        public void invoke() {
            JavaSource js = JavaSource.forDocument((Document)this.component.getDocument());
            if (js == null) {
                return;
            }
            try {
                ModificationResult mr = js.runModificationTask((Task)new Mod(this.handle));
                GeneratorUtils.guardedCommit((JTextComponent)this.component, (ModificationResult)mr);
                int[] span = mr.getSpan((Object)"methodBodyTag");
                if (span != null) {
                    this.component.setSelectionStart(span[0]);
                    this.component.setSelectionEnd(span[1]);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class Mod
    implements Task<WorkingCopy> {
        private final ElementHandle<TypeElement> handle;

        public Mod(ElementHandle<TypeElement> handle) {
            this.handle = handle;
        }

        public void run(WorkingCopy parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement resolved = (TypeElement)this.handle.resolve((CompilationInfo)parameter);
            if (!Utilities.isValidElement(resolved)) {
                return;
            }
            TreePath path = parameter.getTrees().getPath(resolved);
            if (path == null) {
                return;
            }
            AnnotationProcessors.ProcessorHintSupport supp = new AnnotationProcessors.ProcessorHintSupport((CompilationInfo)parameter, path);
            if (!supp.initialize() || !supp.canOverrideProcessor(true)) {
                return;
            }
            supp.makeGetSupportedOverride(parameter, null, true);
        }
    }
}

