/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript.karma.browsers.Browser;
import org.netbeans.modules.javascript.karma.browsers.Browsers;
import org.netbeans.modules.javascript.karma.exec.Bundle;
import org.netbeans.modules.javascript.karma.options.KarmaOptions;
import org.netbeans.modules.javascript.karma.options.KarmaOptionsValidator;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferencesValidator;
import org.netbeans.modules.javascript.karma.run.KarmaRunInfo;
import org.netbeans.modules.javascript.karma.run.TestRunner;
import org.netbeans.modules.javascript.karma.ui.KarmaErrorsDialog;
import org.netbeans.modules.javascript.karma.util.FileUtils;
import org.netbeans.modules.javascript.karma.util.StringUtils;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class KarmaExecutable {
    private static final Logger LOGGER = Logger.getLogger(KarmaExecutable.class.getName());
    public static final String KARMA_NAME = Utilities.isWindows() ? "karma.cmd" : "karma";
    private static final String START_COMMAND = "start";
    private static final String RUN_COMMAND = "run";
    private static final String PORT_PARAMETER = "--port";
    protected final String karmaPath;
    protected final Project project;

    KarmaExecutable(String karmaPath, Project project) {
        assert (karmaPath != null);
        assert (project != null);
        this.karmaPath = karmaPath;
        this.project = project;
    }

    @CheckForNull
    public static KarmaExecutable getDefault(Project project, boolean showOptionsOrCustomizer) {
        assert (project != null);
        ValidationResult result = new KarmaOptionsValidator().validateKarma().getResult();
        if (KarmaExecutable.validateResult(result) != null) {
            if (showOptionsOrCustomizer) {
                OptionsDisplayer.getDefault().open("Html5/Karma");
            }
            return null;
        }
        result = new KarmaPreferencesValidator().validate(project).getResult();
        if (KarmaExecutable.validateResult(result) != null) {
            if (showOptionsOrCustomizer) {
                ((CustomizerProvider2)project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer("JS_TESTING", null);
            }
            return null;
        }
        return KarmaExecutable.createExecutable(KarmaOptions.getInstance().getKarma(), project);
    }

    private static KarmaExecutable createExecutable(String karma, Project project) {
        if (Utilities.isMac()) {
            return new MacKarmaExecutable(karma, project);
        }
        return new KarmaExecutable(karma, project);
    }

    @CheckForNull
    public Future<Integer> start(int port, KarmaRunInfo karmaRunInfo) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable countDownTask = new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        };
        Future task = this.getExecutable(Bundle.KarmaExecutable_start(ProjectUtils.getInformation((Project)this.project).getDisplayName()), this.getProjectDir()).additionalParameters(this.getStartParams(port, karmaRunInfo)).environmentVariables(karmaRunInfo.getEnvVars()).run(this.getStartDescriptor(karmaRunInfo, countDownTask));
        assert (task != null) : this.karmaPath;
        try {
            countDownLatch.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (task.isDone()) {
            return null;
        }
        return task;
    }

    public void runTests(int port) {
        this.getExecutable("karma run...", this.getProjectDir()).additionalParameters(this.getRunParams(port)).run(this.getRunDescriptor());
    }

    private File getProjectDir() {
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    String getCommand() {
        return this.karmaPath;
    }

    private ExternalExecutable getExecutable(String title, File workDir) {
        return new ExternalExecutable(this.getCommand()).workDir(workDir).displayName(title).noOutput(false);
    }

    private ExecutionDescriptor getStartDescriptor(KarmaRunInfo karmaRunInfo, Runnable serverStartTask) {
        return new ExecutionDescriptor().frontWindow(false).frontWindowOnError(false).outLineBased(true).errLineBased(true).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new ServerLineConvertorFactory(karmaRunInfo, serverStartTask)).postExecution(serverStartTask);
    }

    private ExecutionDescriptor getRunDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL);
    }

    List<String> getStartParams(int port, KarmaRunInfo karmaRunInfo) {
        ArrayList<String> params = new ArrayList<String>(4);
        params.add(START_COMMAND);
        params.add(karmaRunInfo.getNbConfigFile());
        params.add(PORT_PARAMETER);
        params.add(Integer.toString(port));
        return params;
    }

    List<String> getRunParams(int port) {
        ArrayList<String> params = new ArrayList<String>(3);
        params.add(RUN_COMMAND);
        params.add(PORT_PARAMETER);
        params.add(Integer.toString(port));
        return params;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
    }

    private static final class MacKarmaExecutable
    extends KarmaExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacKarmaExecutable(String karmaPath, Project project) {
            super(karmaPath, project);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getStartParams(int port, KarmaRunInfo karmaRunInfo) {
            return this.getParams(super.getStartParams(port, karmaRunInfo));
        }

        @Override
        List<String> getRunParams(int port) {
            return this.getParams(super.getRunParams(port));
        }

        private List<String> getParams(List<String> originalParams) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.karmaPath);
            sb.append("\" \"");
            sb.append(StringUtils.implode(originalParams, "\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }

    private static final class ServerLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        private final LineConvertor serverLineConvertor;

        public ServerLineConvertorFactory(KarmaRunInfo karmaRunInfo, Runnable startFinishedTask) {
            assert (karmaRunInfo != null);
            assert (startFinishedTask != null);
            this.serverLineConvertor = new ServerLineConvertor(karmaRunInfo, startFinishedTask);
        }

        public LineConvertor newLineConvertor() {
            return this.serverLineConvertor;
        }
    }

    static final class FileLineParser {
        static final Pattern OUTPUT_FILE_LINE_PATTERN = Pattern.compile("(?:^|\\()(?<FILE>[^(]+?):(?<LINE>\\d+)(?::\\d+)?(?:$|\\))");

        FileLineParser() {
        }

        static Pair<String, Integer> getOutputFileLine(String line) {
            Matcher matcher = OUTPUT_FILE_LINE_PATTERN.matcher(line);
            if (!matcher.find()) {
                return null;
            }
            String file = matcher.group("FILE");
            if (!new File(file).isFile()) {
                return null;
            }
            return Pair.of((Object)file, (Object)Integer.valueOf(matcher.group("LINE")));
        }
    }

    private static final class FileOutputListener
    implements OutputListener {
        final String file;
        final int line;

        public FileOutputListener(String file, int line) {
            assert (file != null);
            this.file = file;
            this.line = line;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    FileUtils.openFile(new File(file), line);
                }
            });
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static final class ServerLineConvertor
    implements LineConvertor {
        private static final boolean DEBUG = Boolean.getBoolean("nb.karma.debug");
        private static final String NB_BROWSERS = "$NB$netbeans browsers ";
        private static final String KARMA_ERROR = "[31mERROR [";
        private static final String KARMA_WARN = "[33mWARN [";
        private final KarmaRunInfo karmaRunInfo;
        private final Runnable startFinishedTask;
        private final TestRunner testRunner;
        private boolean firstLine = true;
        private boolean startFinishedTaskRun = false;
        private Collection<Browser> browsers = null;
        private int browserCount = -1;
        private int connectedBrowsers = 0;

        public ServerLineConvertor(KarmaRunInfo karmaRunInfo, Runnable startFinishedTask) {
            assert (karmaRunInfo != null);
            assert (startFinishedTask != null);
            this.karmaRunInfo = karmaRunInfo;
            this.startFinishedTask = startFinishedTask;
            this.testRunner = new TestRunner(karmaRunInfo);
        }

        public List<ConvertedLine> convert(String line) {
            if (this.firstLine && line.contains(this.karmaRunInfo.getNbConfigFile())) {
                this.firstLine = false;
                return Collections.singletonList(ConvertedLine.forText((String)line.replace(this.karmaRunInfo.getNbConfigFile(), this.karmaRunInfo.getProjectConfigFile()), null));
            }
            if (this.browsers == null && line.startsWith(NB_BROWSERS)) {
                List<String> allBrowsers = StringUtils.explode(line.substring(NB_BROWSERS.length()), ",");
                this.browserCount = allBrowsers.size();
                this.browsers = Browsers.getBrowsers(allBrowsers);
                return Collections.emptyList();
            }
            if (this.startFinishedTask != null && !this.startFinishedTaskRun && line.contains("Connected on socket")) {
                assert (this.browsers != null);
                ++this.connectedBrowsers;
                if (this.connectedBrowsers == this.browserCount) {
                    this.startFinishedTask.run();
                    this.startFinishedTaskRun = true;
                }
            } else if (line.startsWith("$NB$netbeans ")) {
                this.testRunner.process(line);
                if (DEBUG) {
                    return Collections.singletonList(ConvertedLine.forText((String)line, null));
                }
                return Collections.emptyList();
            }
            if (this.connectedBrowsers < this.browserCount && (line.contains(KARMA_ERROR) || line.contains(KARMA_WARN))) {
                KarmaErrorsDialog.getInstance().show();
            }
            FileOutputListener outputListener = null;
            if (this.browsers == null) {
                Pair<String, Integer> fileLine = FileLineParser.getOutputFileLine(line);
                if (fileLine != null) {
                    outputListener = new FileOutputListener((String)fileLine.first(), (Integer)fileLine.second());
                }
                return Collections.singletonList(ConvertedLine.forText((String)line, outputListener));
            }
            for (Browser browser : this.browsers) {
                Pair<String, Integer> fileLine = browser.getOutputFileLine(line);
                if (fileLine == null) continue;
                outputListener = new FileOutputListener((String)fileLine.first(), (Integer)fileLine.second());
                break;
            }
            this.testRunner.logMessageToTestResultsWindowOutputView(line);
            return Collections.singletonList(ConvertedLine.forText((String)line, outputListener));
        }
    }
}

