/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.php.dbgp.packets.PropertyCommand;

public class PropertyGetCommand
extends PropertyCommand {
    private static final String KEY_ARG = "-k ";
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    static final String PROPERTY_GET = "property_get";
    private String myKey;

    public PropertyGetCommand(String transactionId) {
        this(PROPERTY_GET, transactionId);
    }

    protected PropertyGetCommand(String command, String transactionId) {
        super(command, transactionId);
    }

    @Override
    public boolean wantAcknowledgment() {
        return true;
    }

    public void setKey(String key) {
        this.myKey = key;
    }

    @Override
    protected String getArguments() {
        StringBuilder builder = new StringBuilder(super.getArguments());
        if (this.myKey != null) {
            builder.append(" ");
            builder.append(KEY_ARG);
            builder.append(this.myKey);
        }
        return builder.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    void firePropertyChangeEvent(String propertyName, Object propertyValue) {
        this.changeSupport.firePropertyChange(propertyName, null, propertyValue);
    }
}

