/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ControllerProvider;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ExceptionBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.FieldBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.LineBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.MethodBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ThreadBreakpointPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BreakpointsActionsProvider
implements NodeActionsProviderFilter {
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)BreakpointsActionsProvider.loc("CTL_Breakpoint_Customize_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            BreakpointsActionsProvider.customize((Breakpoint)nodes[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    private static String loc(String key) {
        return NbBundle.getBundle(BreakpointsActionsProvider.class).getString(key);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (!(node instanceof JPDABreakpoint)) {
            return original.getActions(node);
        }
        Action[] oas = original.getActions(node);
        Action[] as = new Action[oas.length + 1];
        System.arraycopy(oas, 0, as, 0, oas.length);
        as[as.length - 1] = CUSTOMIZE_ACTION;
        return as;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof ThreadBreakpoint) {
            BreakpointsActionsProvider.customize((Breakpoint)node);
        } else {
            original.performDefaultAction(node);
        }
    }

    public static JComponent getCustomizerComponent(Breakpoint b) {
        JPanel c = null;
        if (b instanceof LineBreakpoint) {
            c = new LineBreakpointPanel((LineBreakpoint)b);
        } else if (b instanceof FieldBreakpoint) {
            c = new FieldBreakpointPanel((FieldBreakpoint)b);
        } else if (b instanceof ClassLoadUnloadBreakpoint) {
            c = new ClassBreakpointPanel((ClassLoadUnloadBreakpoint)b);
        } else if (b instanceof MethodBreakpoint) {
            c = new MethodBreakpointPanel((MethodBreakpoint)b);
        } else if (b instanceof ThreadBreakpoint) {
            c = new ThreadBreakpointPanel((ThreadBreakpoint)b);
        } else if (b instanceof ExceptionBreakpoint) {
            c = new ExceptionBreakpointPanel((ExceptionBreakpoint)b);
        }
        ((Component)c).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"ACSD_Breakpoint_Customizer_Dialog"));
        return c;
    }

    public static void customize(Breakpoint b) {
        JComponent c = BreakpointsActionsProvider.getCustomizerComponent(b);
        HelpCtx helpCtx = HelpCtx.findHelp((Component)c);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        Controller cc = c instanceof ControllerProvider ? ((ControllerProvider)((Object)c)).getController() : (Controller)c;
        final Controller[] cPtr = new Controller[]{cc};
        final DialogDescriptor[] descriptorPtr = new DialogDescriptor[1];
        final Dialog[] dialogPtr = new Dialog[1];
        ActionListener buttonsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (descriptorPtr[0].getValue() == DialogDescriptor.OK_OPTION) {
                    boolean ok = cPtr[0].ok();
                    if (ok) {
                        dialogPtr[0].setVisible(false);
                    }
                } else {
                    dialogPtr[0].setVisible(false);
                }
            }
        };
        DialogDescriptor descriptor = new DialogDescriptor((Object)c, NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_Breakpoint_Customizer_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, buttonsActionListener);
        descriptor.setClosingOptions(new Object[0]);
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.pack();
        descriptorPtr[0] = descriptor;
        dialogPtr[0] = d;
        d.setVisible(true);
    }
}

