/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerSupport;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.netbeans.modules.docker.ui.wizard.AddDockerInstanceWizard;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class BuildInstanceVisual
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DefaultComboBoxModel<DockerInstanceWrapper> model = new DefaultComboBoxModel();
    private final ChangeListener instancesListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (SwingUtilities.isEventDispatchThread()) {
                BuildInstanceVisual.this.refresh();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuildInstanceVisual.this.refresh();
                    }
                });
            }
        }
    };
    private JButton addButton;
    private JComboBox<DockerInstanceWrapper> instanceComboBox;
    private JLabel instanceLabel;

    public BuildInstanceVisual() {
        this.initComponents();
        DockerSupport integration = DockerSupport.getDefault();
        integration.addChangeListener(WeakListeners.change((ChangeListener)this.instancesListener, (Object)integration));
        this.instanceComboBox.setModel(this.model);
        this.instanceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildInstanceVisual.this.changeSupport.fireChange();
            }
        });
        this.refresh();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public DockerInstance getInstance() {
        Object item = this.instanceComboBox.getSelectedItem();
        if (item == null) {
            return null;
        }
        return ((DockerInstanceWrapper)item).getInstance();
    }

    public void setInstance(DockerInstance instance) {
        if (instance == null) {
            return;
        }
        for (int i = 0; i < this.model.getSize(); ++i) {
            DockerInstanceWrapper w = this.model.getElementAt(i);
            if (!instance.equals((Object)w.getInstance())) continue;
            this.instanceComboBox.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public String getName() {
        return Bundle.LBL_BuildInstance();
    }

    private void refresh() {
        assert (SwingUtilities.isEventDispatchThread());
        DockerInstanceWrapper wrapper = (DockerInstanceWrapper)this.model.getSelectedItem();
        this.model.removeAllElements();
        ArrayList<DockerInstance> instances = new ArrayList<DockerInstance>(DockerSupport.getDefault().getInstances());
        instances.sort(UiUtils.getInstanceComparator());
        for (DockerInstance i : instances) {
            this.model.addElement(new DockerInstanceWrapper(i));
        }
        if (wrapper != null) {
            this.model.setSelectedItem(wrapper);
        }
    }

    private void initComponents() {
        this.instanceLabel = new JLabel();
        this.instanceComboBox = new JComboBox();
        this.addButton = new JButton();
        this.instanceLabel.setLabelFor(this.instanceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.instanceLabel, (String)NbBundle.getMessage(BuildInstanceVisual.class, (String)"BuildInstanceVisual.instanceLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(BuildInstanceVisual.class, (String)"BuildInstanceVisual.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildInstanceVisual.this.addButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.instanceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instanceComboBox, 0, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instanceLabel).addComponent(this.instanceComboBox, -2, -1, -2).addComponent(this.addButton)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        AddDockerInstanceWizard wizard = new AddDockerInstanceWizard();
        DockerInstance instance = wizard.show();
        this.setInstance(instance);
    }

    private static class DockerInstanceWrapper {
        private final DockerInstance instance;

        public DockerInstanceWrapper(DockerInstance instance) {
            this.instance = instance;
        }

        public DockerInstance getInstance() {
            return this.instance;
        }

        public String toString() {
            return this.instance.getDisplayName();
        }

        public int hashCode() {
            int hash = 3;
            hash = 31 * hash + Objects.hashCode(this.instance);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DockerInstanceWrapper other = (DockerInstanceWrapper)obj;
            return Objects.equals(this.instance, other.instance);
        }
    }
}

