/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class ApisupportAntUIUtils {
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/apisupport/project/resources/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/apisupport/project/resources/defaultFolderOpen.gif";

    private ApisupportAntUIUtils() {
    }

    public static void setProjectChooserDir(File folder) {
        if (folder == null || !folder.isDirectory()) {
            return;
        }
        ProjectChooser.setProjectsFolder((File)folder);
    }

    public static void setProjectChooserDirParent(File fileOrFolder) {
        if (fileOrFolder == null) {
            return;
        }
        File parent = fileOrFolder.getParentFile();
        ApisupportAntUIUtils.setProjectChooserDir(parent != null ? parent : (fileOrFolder.isDirectory() ? fileOrFolder : null));
    }

    public static void setText(JTextComponent textComp, String text) {
        textComp.setText(text);
        textComp.setCaretPosition(text == null ? 0 : text.length());
    }

    public static NbModuleProject chooseSuiteComponent(Component parent, SuiteProject suite) {
        Project project = ApisupportAntUIUtils.chooseProject(parent);
        if (project == null) {
            return null;
        }
        if (!(project instanceof NbModuleProject)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ApisupportAntUIUtils.class, (String)"MSG_TryingToAddNonNBModule", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            return null;
        }
        NbModuleProject p = (NbModuleProject)project;
        if (SuiteUtils.getSubProjects(suite).contains((NbModuleProject)project)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ApisupportAntUIUtils.class, (String)"MSG_SuiteAlreadyContainsProject", (Object)ProjectUtils.getInformation((Project)suite).getDisplayName(), (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            return null;
        }
        switch (p.getModuleType()) {
            case SUITE_COMPONENT: {
                Object[] params = new Object[]{ProjectUtils.getInformation((Project)project).getDisplayName(), ApisupportAntUIUtils.getSuiteProjectName(project), ApisupportAntUIUtils.getSuiteProjectDirectory(project), ProjectUtils.getInformation((Project)suite).getDisplayName()};
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ApisupportAntUIUtils.class, (String)"MSG_MoveFromSuiteToSuite", (Object[])params), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() == NotifyDescriptor.OK_OPTION) {
                    return p;
                }
                return null;
            }
            case STANDALONE: {
                return p;
            }
            case NETBEANS_ORG: {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ApisupportAntUIUtils.class, (String)"MSG_TryingToAddNBORGModule", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
                return null;
            }
        }
        throw new AssertionError();
    }

    public static Image getTreeFolderIcon(boolean opened) {
        Image base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
        if (base == null) {
            Icon baseIcon = UIManager.getIcon(opened ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
            base = baseIcon != null ? ImageUtilities.icon2Image((Icon)baseIcon) : ImageUtilities.loadImage((String)(opened ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
        }
        assert (base != null);
        return base;
    }

    @CheckForNull
    public static NbModuleProject runLibraryWrapperWizard(Project suiteProvider) {
        NewNbModuleWizardIterator iterator = NewNbModuleWizardIterator.createLibraryModuleIterator(suiteProvider);
        return ApisupportAntUIUtils.runProjectWizard(iterator, "CTL_NewLibraryWrapperProject");
    }

    @CheckForNull
    public static NbModuleProject runProjectWizard(NewNbModuleWizardIterator iterator, String titleBundleKey) {
        boolean cancelled;
        WizardDescriptor wd = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        wd.setTitleFormat(new MessageFormat("{0}"));
        wd.setTitle(NbBundle.getMessage(ApisupportAntUIUtils.class, (String)titleBundleKey));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wd);
        dialog.setVisible(true);
        dialog.toFront();
        NbModuleProject project = null;
        boolean bl = cancelled = wd.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            FileObject folder = iterator.getCreateProjectFolder();
            if (folder == null) {
                return null;
            }
            try {
                project = (NbModuleProject)ProjectManager.getDefault().findProject(folder);
                OpenProjects.getDefault().open(new Project[]{project}, false);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return project;
    }

    public static Project chooseProject(Component parent) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        int option = chooser.showOpenDialog(parent);
        Project project = null;
        if (option == 0) {
            File projectDir = chooser.getSelectedFile();
            ApisupportAntUIUtils.setProjectChooserDirParent(projectDir);
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)projectDir));
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
        return project;
    }

    private static String getSuiteProjectDirectory(Project suiteComp) {
        File d = SuiteUtils.getSuiteDirectory(suiteComp);
        return d != null ? d.getAbsolutePath() : "???";
    }

    private static String getSuiteProjectName(Project suiteComp) {
        FileObject suiteDir;
        File d = SuiteUtils.getSuiteDirectory(suiteComp);
        FileObject fileObject = suiteDir = d != null ? FileUtil.toFileObject((File)d) : null;
        if (suiteDir == null) {
            return "???";
        }
        return ApisupportAntUtils.getDisplayName(suiteDir);
    }

    public static boolean showAcceptCancelDialog(String title, String message, String acceptButton, String cancelButton, int messageType) {
        return ApisupportAntUIUtils.showAcceptCancelDialog(title, message, acceptButton, null, cancelButton, messageType);
    }

    public static boolean showAcceptCancelDialog(String title, String message, String acceptButton, String accDescrAcceptButton, String cancelButton, int messageType) {
        DialogDescriptor d = new DialogDescriptor((Object)message, title);
        d.setModal(true);
        JButton accept = new JButton(acceptButton);
        accept.setDefaultCapable(true);
        if (accDescrAcceptButton != null) {
            accept.getAccessibleContext().setAccessibleDescription(accDescrAcceptButton);
        }
        d.setOptions(new Object[]{accept, cancelButton != null ? new JButton(cancelButton) : NotifyDescriptor.CANCEL_OPTION});
        d.setMessageType(messageType);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d).equals(accept);
    }
}

