/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.apps.StatefulSetOrdinals;
import io.fabric8.kubernetes.api.model.apps.StatefulSetOrdinalsBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetOrdinalsFluentImpl;
import io.fabric8.kubernetes.api.model.apps.StatefulSetPersistentVolumeClaimRetentionPolicy;
import io.fabric8.kubernetes.api.model.apps.StatefulSetPersistentVolumeClaimRetentionPolicyBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetPersistentVolumeClaimRetentionPolicyFluentImpl;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy;
import io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StatefulSetSpecFluentImpl<A extends StatefulSetSpecFluent<A>>
extends BaseFluent<A>
implements StatefulSetSpecFluent<A> {
    private Integer minReadySeconds;
    private StatefulSetOrdinalsBuilder ordinals;
    private StatefulSetPersistentVolumeClaimRetentionPolicyBuilder persistentVolumeClaimRetentionPolicy;
    private String podManagementPolicy;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private LabelSelectorBuilder selector;
    private String serviceName;
    private PodTemplateSpecBuilder template;
    private StatefulSetUpdateStrategyBuilder updateStrategy;
    private ArrayList<PersistentVolumeClaimBuilder> volumeClaimTemplates = new ArrayList();
    private Map<String, Object> additionalProperties;

    public StatefulSetSpecFluentImpl() {
    }

    public StatefulSetSpecFluentImpl(StatefulSetSpec instance) {
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withOrdinals(instance.getOrdinals());
            this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
            this.withPodManagementPolicy(instance.getPodManagementPolicy());
            this.withReplicas(instance.getReplicas());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSelector(instance.getSelector());
            this.withServiceName(instance.getServiceName());
            this.withTemplate(instance.getTemplate());
            this.withUpdateStrategy(instance.getUpdateStrategy());
            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    @Deprecated
    public StatefulSetOrdinals getOrdinals() {
        return this.ordinals != null ? this.ordinals.build() : null;
    }

    @Override
    public StatefulSetOrdinals buildOrdinals() {
        return this.ordinals != null ? this.ordinals.build() : null;
    }

    @Override
    public A withOrdinals(StatefulSetOrdinals ordinals) {
        this._visitables.get((Object)"ordinals").remove(this.ordinals);
        if (ordinals != null) {
            this.ordinals = new StatefulSetOrdinalsBuilder(ordinals);
            this._visitables.get((Object)"ordinals").add(this.ordinals);
        } else {
            this.ordinals = null;
            this._visitables.get((Object)"ordinals").remove(this.ordinals);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOrdinals() {
        return this.ordinals != null;
    }

    @Override
    public A withNewOrdinals(Integer start) {
        return this.withOrdinals(new StatefulSetOrdinals(start));
    }

    @Override
    public StatefulSetSpecFluent.OrdinalsNested<A> withNewOrdinals() {
        return new OrdinalsNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.OrdinalsNested<A> withNewOrdinalsLike(StatefulSetOrdinals item) {
        return new OrdinalsNestedImpl(item);
    }

    @Override
    public StatefulSetSpecFluent.OrdinalsNested<A> editOrdinals() {
        return this.withNewOrdinalsLike(this.getOrdinals());
    }

    @Override
    public StatefulSetSpecFluent.OrdinalsNested<A> editOrNewOrdinals() {
        return this.withNewOrdinalsLike(this.getOrdinals() != null ? this.getOrdinals() : new StatefulSetOrdinalsBuilder().build());
    }

    @Override
    public StatefulSetSpecFluent.OrdinalsNested<A> editOrNewOrdinalsLike(StatefulSetOrdinals item) {
        return this.withNewOrdinalsLike(this.getOrdinals() != null ? this.getOrdinals() : item);
    }

    @Override
    @Deprecated
    public StatefulSetPersistentVolumeClaimRetentionPolicy getPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null ? this.persistentVolumeClaimRetentionPolicy.build() : null;
    }

    @Override
    public StatefulSetPersistentVolumeClaimRetentionPolicy buildPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null ? this.persistentVolumeClaimRetentionPolicy.build() : null;
    }

    @Override
    public A withPersistentVolumeClaimRetentionPolicy(StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
        this._visitables.get((Object)"persistentVolumeClaimRetentionPolicy").remove(this.persistentVolumeClaimRetentionPolicy);
        if (persistentVolumeClaimRetentionPolicy != null) {
            this.persistentVolumeClaimRetentionPolicy = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(persistentVolumeClaimRetentionPolicy);
            this._visitables.get((Object)"persistentVolumeClaimRetentionPolicy").add(this.persistentVolumeClaimRetentionPolicy);
        } else {
            this.persistentVolumeClaimRetentionPolicy = null;
            this._visitables.get((Object)"persistentVolumeClaimRetentionPolicy").remove(this.persistentVolumeClaimRetentionPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null;
    }

    @Override
    public A withNewPersistentVolumeClaimRetentionPolicy(String whenDeleted, String whenScaled) {
        return this.withPersistentVolumeClaimRetentionPolicy(new StatefulSetPersistentVolumeClaimRetentionPolicy(whenDeleted, whenScaled));
    }

    @Override
    public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicy() {
        return new PersistentVolumeClaimRetentionPolicyNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicyLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
        return new PersistentVolumeClaimRetentionPolicyNestedImpl(item);
    }

    @Override
    public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editPersistentVolumeClaimRetentionPolicy() {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(this.getPersistentVolumeClaimRetentionPolicy());
    }

    @Override
    public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicy() {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(this.getPersistentVolumeClaimRetentionPolicy() != null ? this.getPersistentVolumeClaimRetentionPolicy() : new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder().build());
    }

    @Override
    public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicyLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
        return this.withNewPersistentVolumeClaimRetentionPolicyLike(this.getPersistentVolumeClaimRetentionPolicy() != null ? this.getPersistentVolumeClaimRetentionPolicy() : item);
    }

    @Override
    public String getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    @Override
    public A withPodManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPodManagementPolicy() {
        return this.podManagementPolicy != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get((Object)"template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public StatefulSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public StatefulSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public A withUpdateStrategy(StatefulSetUpdateStrategy updateStrategy) {
        this._visitables.get((Object)"updateStrategy").remove(this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new StatefulSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get((Object)"updateStrategy").add(this.updateStrategy);
        } else {
            this.updateStrategy = null;
            this._visitables.get((Object)"updateStrategy").remove(this.updateStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy());
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : new StatefulSetUpdateStrategyBuilder().build());
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : item);
    }

    @Override
    public A addToVolumeClaimTemplates(int index, PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= this.volumeClaimTemplates.size()) {
            this._visitables.get((Object)"volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        } else {
            this._visitables.get((Object)"volumeClaimTemplates").add(index, builder);
            this.volumeClaimTemplates.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToVolumeClaimTemplates(int index, PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= this.volumeClaimTemplates.size()) {
            this._visitables.get((Object)"volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        } else {
            this._visitables.get((Object)"volumeClaimTemplates").set(index, builder);
            this.volumeClaimTemplates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeClaimTemplates(PersistentVolumeClaim ... items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get((Object)"volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList();
        }
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get((Object)"volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim ... items) {
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get((Object)"volumeClaimTemplates").remove(builder);
            if (this.volumeClaimTemplates == null) continue;
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get((Object)"volumeClaimTemplates").remove(builder);
            if (this.volumeClaimTemplates == null) continue;
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumeClaimTemplates(Predicate<PersistentVolumeClaimBuilder> predicate) {
        if (this.volumeClaimTemplates == null) {
            return (A)this;
        }
        Iterator<PersistentVolumeClaimBuilder> each = this.volumeClaimTemplates.iterator();
        List visitables = this._visitables.get((Object)"volumeClaimTemplates");
        while (each.hasNext()) {
            PersistentVolumeClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PersistentVolumeClaim> getVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null ? StatefulSetSpecFluentImpl.build(this.volumeClaimTemplates) : null;
    }

    @Override
    public List<PersistentVolumeClaim> buildVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null ? StatefulSetSpecFluentImpl.build(this.volumeClaimTemplates) : null;
    }

    @Override
    public PersistentVolumeClaim buildVolumeClaimTemplate(int index) {
        return this.volumeClaimTemplates.get(index).build();
    }

    @Override
    public PersistentVolumeClaim buildFirstVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(0).build();
    }

    @Override
    public PersistentVolumeClaim buildLastVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(this.volumeClaimTemplates.size() - 1).build();
    }

    @Override
    public PersistentVolumeClaim buildMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        for (PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        for (PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this._visitables.get((Object)"volumeClaimTemplates").clear();
        }
        if (volumeClaimTemplates != null) {
            this.volumeClaimTemplates = new ArrayList();
            for (PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        } else {
            this.volumeClaimTemplates = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeClaimTemplates(PersistentVolumeClaim ... volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this.volumeClaimTemplates.clear();
            this._visitables.remove((Object)"volumeClaimTemplates");
        }
        if (volumeClaimTemplates != null) {
            for (PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null && !this.volumeClaimTemplates.isEmpty();
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
        return new VolumeClaimTemplatesNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(-1, item);
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index, PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(index, item);
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index) {
        if (this.volumeClaimTemplates.size() <= index) {
            throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate() {
        if (this.volumeClaimTemplates.size() == 0) {
            throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(0, this.buildVolumeClaimTemplate(0));
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate() {
        int index = this.volumeClaimTemplates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeClaimTemplates.size(); ++i) {
            if (!predicate.test(this.volumeClaimTemplates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetSpecFluentImpl that = (StatefulSetSpecFluentImpl)o;
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.ordinals, that.ordinals)) {
            return false;
        }
        if (!Objects.equals(this.persistentVolumeClaimRetentionPolicy, that.persistentVolumeClaimRetentionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.podManagementPolicy, that.podManagementPolicy)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.serviceName, that.serviceName)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.updateStrategy, that.updateStrategy)) {
            return false;
        }
        if (!Objects.equals(this.volumeClaimTemplates, that.volumeClaimTemplates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.ordinals, this.persistentVolumeClaimRetentionPolicy, this.podManagementPolicy, this.replicas, this.revisionHistoryLimit, this.selector, this.serviceName, this.template, this.updateStrategy, this.volumeClaimTemplates, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.ordinals != null) {
            sb.append("ordinals:");
            sb.append(this.ordinals + ",");
        }
        if (this.persistentVolumeClaimRetentionPolicy != null) {
            sb.append("persistentVolumeClaimRetentionPolicy:");
            sb.append(this.persistentVolumeClaimRetentionPolicy + ",");
        }
        if (this.podManagementPolicy != null) {
            sb.append("podManagementPolicy:");
            sb.append(this.podManagementPolicy + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.serviceName != null) {
            sb.append("serviceName:");
            sb.append(this.serviceName + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.updateStrategy != null) {
            sb.append("updateStrategy:");
            sb.append(this.updateStrategy + ",");
        }
        if (this.volumeClaimTemplates != null) {
            sb.append("volumeClaimTemplates:");
            sb.append(this.volumeClaimTemplates + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class VolumeClaimTemplatesNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>>
    implements StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>,
    Nested<N> {
        PersistentVolumeClaimBuilder builder;
        int index;

        VolumeClaimTemplatesNestedImpl(int index, PersistentVolumeClaim item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimBuilder((PersistentVolumeClaimFluent)this, item);
        }

        VolumeClaimTemplatesNestedImpl() {
            this.index = -1;
            this.builder = new PersistentVolumeClaimBuilder((PersistentVolumeClaimFluent)this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.setToVolumeClaimTemplates(this.index, this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }

    class UpdateStrategyNestedImpl<N>
    extends StatefulSetUpdateStrategyFluentImpl<StatefulSetSpecFluent.UpdateStrategyNested<N>>
    implements StatefulSetSpecFluent.UpdateStrategyNested<N>,
    Nested<N> {
        StatefulSetUpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(StatefulSetUpdateStrategy item) {
            this.builder = new StatefulSetUpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new StatefulSetUpdateStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.withUpdateStrategy(this.builder.build());
        }

        @Override
        public N endUpdateStrategy() {
            return this.and();
        }
    }

    class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<StatefulSetSpecFluent.TemplateNested<N>>
    implements StatefulSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<StatefulSetSpecFluent.SelectorNested<N>>
    implements StatefulSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    class PersistentVolumeClaimRetentionPolicyNestedImpl<N>
    extends StatefulSetPersistentVolumeClaimRetentionPolicyFluentImpl<StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<N>>
    implements StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<N>,
    Nested<N> {
        StatefulSetPersistentVolumeClaimRetentionPolicyBuilder builder;

        PersistentVolumeClaimRetentionPolicyNestedImpl(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
            this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this, item);
        }

        PersistentVolumeClaimRetentionPolicyNestedImpl() {
            this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.withPersistentVolumeClaimRetentionPolicy(this.builder.build());
        }

        @Override
        public N endPersistentVolumeClaimRetentionPolicy() {
            return this.and();
        }
    }

    class OrdinalsNestedImpl<N>
    extends StatefulSetOrdinalsFluentImpl<StatefulSetSpecFluent.OrdinalsNested<N>>
    implements StatefulSetSpecFluent.OrdinalsNested<N>,
    Nested<N> {
        StatefulSetOrdinalsBuilder builder;

        OrdinalsNestedImpl(StatefulSetOrdinals item) {
            this.builder = new StatefulSetOrdinalsBuilder(this, item);
        }

        OrdinalsNestedImpl() {
            this.builder = new StatefulSetOrdinalsBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.withOrdinals(this.builder.build());
        }

        @Override
        public N endOrdinals() {
            return this.and();
        }
    }
}

