/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HexFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.spi.java.loaders.RenameHandler;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class JavaNode
extends DataNode
implements ChangeListener {
    private static final long serialVersionUID = -7396485743899766258L;
    private static final String JAVA_ICON_BASE = "org/netbeans/modules/java/resources/class.png";
    private static final String CLASS_ICON_BASE = "org/netbeans/modules/java/resources/clazz.gif";
    private static final String ABSTRACT_CLASS_ICON_BASE = "org/netbeans/modules/java/resources/abstract_class_file.png";
    private static final String INTERFACE_ICON_BASE = "org/netbeans/modules/java/resources/interface_file.png";
    private static final String ENUM_ICON_BASE = "org/netbeans/modules/java/resources/enum_file.png";
    private static final String ANNOTATION_ICON_BASE = "org/netbeans/modules/java/resources/annotation_file.png";
    private static final String EXECUTABLE_BADGE_URL = "org/netbeans/modules/java/resources/executable-badge.png";
    private static final String NEEDS_COMPILE_BADGE_URL = "org/netbeans/modules/java/resources/needs-compile.png";
    private static final String GLOBAL_VM_OPTIONS = "java_file_launcher_global_vm_options";
    private static final String FILE_ARGUMENTS = "single_file_run_arguments";
    private static final String FILE_JDK = "single_file_run_jdk";
    private static final String FILE_VM_OPTIONS = "single_file_vm_options";
    private static final String FILE_REGISTER_ROOT = "register_root";
    private static final Map<String, Image> IMAGE_CACHE = new ConcurrentHashMap<String, Image>();
    private static final boolean ALWAYS_PREFFER_COMPUTED_ICON = Boolean.getBoolean("JavaNode.prefferComputedIcon");
    private static final Logger LOG = Logger.getLogger(JavaNode.class.getName());
    private FileBuiltQuery.Status status;
    private final boolean isJavaSource;
    private final AtomicReference<Image> isCompiled;
    private final AtomicReference<Image> isExecutable;
    private final AtomicReference<Image> computedIcon;
    private final AtomicReference<FileChangeListener> computedIconListener;
    private ChangeListener executableListener;
    private Node.PropertySet[] propertySets;
    private static final RequestProcessor WORKER = new RequestProcessor("Java Node Badge Processor", 1, false, false);

    public JavaNode(DataObject jdo, boolean isJavaSource) {
        super(jdo, Children.LEAF);
        this.isJavaSource = isJavaSource;
        this.isCompiled = new AtomicReference();
        this.isExecutable = new AtomicReference();
        this.computedIcon = new AtomicReference();
        this.computedIconListener = new AtomicReference();
        this.setIconBaseWithExtension(isJavaSource ? JAVA_ICON_BASE : CLASS_ICON_BASE);
        Logger.getLogger("TIMER").log(Level.FINE, "JavaNode", new Object[]{jdo.getPrimaryFile(), this});
        if (!jdo.isTemplate()) {
            WORKER.post((Runnable)IconTask.create(this));
            if (isJavaSource) {
                WORKER.post((Runnable)new BuildStatusTask(this));
                WORKER.post((Runnable)new ExecutableTask(this));
                jdo.addPropertyChangeListener(evt -> {
                    if ("primaryFile".equals(evt.getPropertyName())) {
                        Logger.getLogger("TIMER").log(Level.FINE, "JavaNode", new Object[]{jdo.getPrimaryFile(), this});
                        WORKER.post(() -> {
                            this.computedIconListener.set(null);
                            JavaNode javaNode = this;
                            synchronized (javaNode) {
                                this.status = null;
                                this.executableListener = null;
                                WORKER.post((Runnable)new BuildStatusTask(this));
                                WORKER.post((Runnable)new ExecutableTask(this));
                            }
                        });
                    }
                });
            }
        }
    }

    public void setName(String name) {
        RenameHandler handler = JavaNode.getRenameHandler();
        if (handler == null) {
            super.setName(name);
        } else {
            try {
                handler.handleRename((Node)this, name);
            }
            catch (IllegalArgumentException ioe) {
                super.setName(name);
            }
        }
    }

    private static synchronized RenameHandler getRenameHandler() {
        Collection handlers = Lookup.getDefault().lookupAll(RenameHandler.class);
        if (handlers.isEmpty()) {
            return null;
        }
        if (handlers.size() > 1) {
            LOG.warning("Multiple instances of RenameHandler found in Lookup; only using first one: " + handlers);
        }
        return (RenameHandler)handlers.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node.PropertySet[] getPropertySets() {
        this.getSheet();
        JavaNode javaNode = this;
        synchronized (javaNode) {
            return Arrays.copyOf(this.propertySets, this.propertySets.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (JavaNode.getRenameHandler() != null) {
            sheet.get("properties").put(this.createNameProperty());
        }
        Sheet.Set ps = new Sheet.Set();
        ps.setName("classpaths");
        ps.setDisplayName(NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_sheet_classpaths"));
        ps.setShortDescription(NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_sheet_classpaths"));
        ps.put(new Node.Property[]{new ClasspathProperty("classpath/compile", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("classpath/execute", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/boot", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_boot_classpath"))});
        sheet.put(ps);
        if (!this.isJavaSource) {
            ps = new Sheet.Set();
            ps.setName("classfile_info");
            ps.setDisplayName(NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_sheet_classfile"));
            ps.setShortDescription(NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_sheet_classfile"));
            ps.put((Node.Property)new ClassFileVersionProperty());
            sheet.put(ps);
        }
        Project parentProject = FileOwnerQuery.getOwner((FileObject)super.getDataObject().getPrimaryFile());
        DataObject dObj = super.getDataObject();
        if (parentProject == null) {
            Sheet.Set ss = new Sheet.Set();
            ss.setName("runFileArguments");
            ss.setDisplayName(NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_without_project_run"));
            ss.setShortDescription("Run the file's source code.");
            ss.put((Node.Property)new JavaFileBooleanAttributeProperty(dObj, FILE_REGISTER_ROOT, "registerRoot", "singlefile_registerRoot"));
            ss.put((Node.Property)new RunFileJDKProperty(dObj));
            ss.put((Node.Property)new JavaFileAttributeProperty(dObj, FILE_ARGUMENTS, "runFileArguments", "singlefile_arguments"));
            ss.put((Node.Property)new JavaFileAttributeProperty(dObj, FILE_VM_OPTIONS, "runFileVMOptions", "singlefile_options"));
            ss.put((Node.Property)new JavaFileGlobalOptionsProperty());
            sheet.put(ss);
        }
        Node.PropertySet[] propertySets = sheet.toArray();
        JavaNode javaNode = this;
        synchronized (javaNode) {
            this.propertySets = propertySets;
        }
        return sheet;
    }

    private Node.Property createNameProperty() {
        PropertySupport.ReadWrite<String> p = new PropertySupport.ReadWrite<String>("name", String.class, NbBundle.getMessage(DataObject.class, (String)"PROP_name"), NbBundle.getMessage(DataObject.class, (String)"HINT_name")){

            public String getValue() {
                return JavaNode.this.getName();
            }

            public Object getValue(String key) {
                if ("suppressCustomEditor".equals(key)) {
                    return Boolean.TRUE;
                }
                return super.getValue(key);
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                JavaNode.this.setName(val);
            }

            public boolean canWrite() {
                return JavaNode.this.canRename();
            }
        };
        return p;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        WORKER.post((Runnable)new BuildStatusTask(this));
    }

    public Image getIcon(int type) {
        Image i = this.prefferImage(this.computedIcon.get(), super.getIcon(type), type);
        return this.enhanceIcon(i);
    }

    public Image getOpenedIcon(int type) {
        Image i = super.getOpenedIcon(type);
        return this.enhanceIcon(i);
    }

    private Image prefferImage(Image computed, Image parent, int type) {
        Object attrValue;
        if (computed == null) {
            return parent;
        }
        if (!ALWAYS_PREFFER_COMPUTED_ICON && (attrValue = parent.getProperty("url", null)) instanceof URL) {
            String url = attrValue.toString();
            if (!(!this.isJavaSource ? url.endsWith(CLASS_ICON_BASE) : url.endsWith(JAVA_ICON_BASE))) {
                return parent;
            }
        }
        try {
            FileObject fo = this.getDataObject().getPrimaryFile();
            computed = FileUIUtils.getImageDecorator((FileSystem)fo.getFileSystem()).annotateIcon(computed, type, Set.of(fo));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return computed;
    }

    private Image enhanceIcon(Image i) {
        Image executable;
        Image needsCompile = this.isCompiled.get();
        if (needsCompile != null) {
            i = ImageUtilities.mergeImages((Image)i, (Image)needsCompile, (int)16, (int)0);
        }
        if ((executable = this.isExecutable.get()) != null) {
            i = ImageUtilities.mergeImages((Image)i, (Image)executable, (int)10, (int)6);
        }
        return i;
    }

    private static Image getImage(@NonNull String resourceId, @NullAllowed String annotationTemplate) {
        Image result = IMAGE_CACHE.get(resourceId);
        if (result == null) {
            result = ImageUtilities.loadImage((String)resourceId, (boolean)true);
            if (annotationTemplate != null) {
                URL resourceURL = JavaNode.class.getClassLoader().getResource(resourceId);
                String annotation = MessageFormat.format(annotationTemplate, resourceURL);
                result = ImageUtilities.assignToolTipToImage((Image)result, (String)annotation);
            }
            IMAGE_CACHE.put(resourceId, result);
        }
        return result;
    }

    private static abstract class IconTask
    implements Runnable {
        protected final JavaNode node;

        IconTask(@NonNull JavaNode node) {
            this.node = node;
        }

        @CheckForNull
        abstract String computeIcon(@NonNull FileObject var1);

        @Override
        public final void run() {
            String res = null;
            FileObject file = this.node.getDataObject().getPrimaryFile();
            if (file != null && file.isValid()) {
                FCL l;
                if (this.node.computedIconListener.get() == null && this.node.computedIconListener.compareAndSet(null, (FileChangeListener)(l = new FCL(this.node)))) {
                    file.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)l, (Object)file));
                }
                res = this.computeIcon(file);
            }
            if (res == null) {
                res = this.node.isJavaSource ? JavaNode.JAVA_ICON_BASE : JavaNode.CLASS_ICON_BASE;
            }
            this.node.computedIcon.set(JavaNode.getImage(res, null));
            this.node.fireIconChange();
            this.node.fireOpenedIconChange();
        }

        static IconTask create(@NonNull JavaNode node) {
            return node.isJavaSource ? new SourceIcon(node) : new ClassIcon(node);
        }

        private static final class FCL
        extends FileChangeAdapter {
            private final JavaNode node;

            FCL(@NonNull JavaNode node) {
                this.node = node;
            }

            public void fileChanged(FileEvent fe) {
                WORKER.post((Runnable)IconTask.create(this.node));
            }
        }

        private static final class SourceIcon
        extends IconTask {
            private SourceIcon(@NonNull JavaNode node) {
                super(node);
            }

            @Override
            String computeIcon(@NonNull FileObject file) {
                String[] res = new String[1];
                JavaSource src = JavaSource.forFileObject((FileObject)file);
                if (src != null) {
                    try {
                        src.runUserActionTask(cc -> {
                            cc.toPhase(JavaSource.Phase.PARSED);
                            CompilationUnitTree cu = cc.getCompilationUnit();
                            Collection topTypes = (Collection)cu.accept(new ClasssFinder(), new ArrayList());
                            for (ClassTree ct : topTypes) {
                                switch (ct.getKind()) {
                                    case CLASS: {
                                        res[0] = ct.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) ? JavaNode.ABSTRACT_CLASS_ICON_BASE : JavaNode.JAVA_ICON_BASE;
                                        break;
                                    }
                                    case INTERFACE: {
                                        res[0] = JavaNode.INTERFACE_ICON_BASE;
                                        break;
                                    }
                                    case ENUM: {
                                        res[0] = JavaNode.ENUM_ICON_BASE;
                                        break;
                                    }
                                    case ANNOTATION_TYPE: {
                                        res[0] = JavaNode.ANNOTATION_ICON_BASE;
                                    }
                                }
                                if (!file.getName().contentEquals(ct.getSimpleName())) continue;
                                break;
                            }
                        }, true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return res[0];
            }

            private static final class ClasssFinder
            extends ErrorAwareTreeScanner<Collection<ClassTree>, Collection<ClassTree>> {
                private ClasssFinder() {
                }

                public Collection<ClassTree> visitCompilationUnit(CompilationUnitTree node, Collection<ClassTree> p) {
                    super.visitCompilationUnit(node, p);
                    return p;
                }

                public Collection<ClassTree> visitClass(ClassTree node, Collection<ClassTree> p) {
                    p.add(node);
                    return p;
                }
            }
        }

        private static final class ClassIcon
        extends IconTask {
            private ClassIcon(@NonNull JavaNode node) {
                super(node);
            }

            @Override
            @CheckForNull
            String computeIcon(@NonNull FileObject file) {
                String res = JavaNode.CLASS_ICON_BASE;
                try (InputStream in2 = file.getInputStream();){
                    ClassFile cf = new ClassFile(in2, false);
                    res = cf.isEnum() ? JavaNode.ENUM_ICON_BASE : (cf.isAnnotation() ? JavaNode.ANNOTATION_ICON_BASE : ((cf.getAccess() & 0x200) == 512 ? JavaNode.INTERFACE_ICON_BASE : ((cf.getAccess() & 0x400) == 1024 ? JavaNode.ABSTRACT_CLASS_ICON_BASE : JavaNode.CLASS_ICON_BASE)));
                }
                catch (FileNotFoundException in2) {
                }
                catch (InvalidClassFormatException e) {
                    LOG.log(Level.INFO, "Invalid classfile: {0}", FileUtil.getFileDisplayName((FileObject)file));
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                return res;
            }
        }
    }

    private static class BuildStatusTask
    implements Runnable {
        private JavaNode node;

        public BuildStatusTask(JavaNode node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean oldIsCompiled;
            FileBuiltQuery.Status _status;
            JavaNode javaNode = this.node;
            synchronized (javaNode) {
                _status = this.node.status;
            }
            if (_status == null) {
                FileObject jf = this.node.getDataObject().getPrimaryFile();
                _status = FileBuiltQuery.getStatus((FileObject)jf);
                JavaNode javaNode2 = this.node;
                synchronized (javaNode2) {
                    if (_status != null && this.node.status == null) {
                        this.node.status = _status;
                        this.node.status.addChangeListener(WeakListeners.change((ChangeListener)this.node, (Object)this.node.status));
                    }
                }
            }
            boolean isPackageInfo = "package-info.java".equals(this.node.getDataObject().getPrimaryFile().getNameExt());
            boolean newIsCompiled = _status != null && !isPackageInfo ? _status.isBuilt() : true;
            boolean bl = oldIsCompiled = this.node.isCompiled.getAndSet(newIsCompiled ? null : JavaNode.getImage(JavaNode.NEEDS_COMPILE_BADGE_URL, "<img src=\"{0}\">&nbsp;" + NbBundle.getMessage(JavaNode.class, (String)"TP_NeedsCompileBadge"))) == null;
            if (newIsCompiled != oldIsCompiled) {
                this.node.fireIconChange();
                this.node.fireOpenedIconChange();
            }
        }
    }

    private static class ExecutableTask
    implements Runnable {
        private final JavaNode node;

        public ExecutableTask(JavaNode node) {
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassPath cp;
            FileObject root;
            ChangeListener _executableListener;
            JavaNode javaNode = this.node;
            synchronized (javaNode) {
                _executableListener = this.node.executableListener;
            }
            FileObject file = this.node.getDataObject().getPrimaryFile();
            if (_executableListener == null) {
                _executableListener = e -> WORKER.post((Runnable)new ExecutableTask(this.node));
                ExecutableFilesIndex.DEFAULT.addChangeListener(file.toURL(), _executableListener);
                JavaNode javaNode2 = this.node;
                synchronized (javaNode2) {
                    if (this.node.executableListener == null) {
                        this.node.executableListener = _executableListener;
                    }
                }
            }
            FileObject fileObject = root = (cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source")) != null ? cp.findOwnerRoot(file) : null;
            if (root != null) {
                boolean oldIsExecutable;
                boolean newIsExecutable = ExecutableFilesIndex.DEFAULT.isMainClass(root.toURL(), file.toURL());
                boolean bl = oldIsExecutable = this.node.isExecutable.getAndSet(newIsExecutable ? JavaNode.getImage(JavaNode.EXECUTABLE_BADGE_URL, "<img src=\"{0}\">&nbsp;" + NbBundle.getMessage(JavaNode.class, (String)"TP_ExecutableBadge")) : null) != null;
                if (newIsExecutable != oldIsExecutable) {
                    this.node.fireIconChange();
                    this.node.fireOpenedIconChange();
                }
            }
        }
    }

    private final class ClasspathProperty
    extends PropertySupport.ReadOnly<String> {
        private final String id;

        public ClasspathProperty(String id, String displayName, String shortDescription) {
            super(id, String.class, displayName, shortDescription);
            this.id = id;
            this.setValue("oneline", false);
        }

        public String getValue() {
            ClassPath cp = ClassPath.getClassPath((FileObject)JavaNode.this.getDataObject().getPrimaryFile(), (String)this.id);
            if (cp != null) {
                StringBuilder sb = new StringBuilder();
                for (ClassPath.Entry entry : cp.entries()) {
                    URL u = entry.getURL();
                    String item = u.toExternalForm();
                    if (u.getProtocol().equals("file")) {
                        item = Utilities.toFile((URI)URI.create(item)).getAbsolutePath();
                    } else if (u.getProtocol().equals("jar") && item.endsWith("!/")) {
                        URL embedded = FileUtil.getArchiveFile((URL)u);
                        assert (embedded != null) : u;
                        if (embedded.getProtocol().equals("file")) {
                            item = Utilities.toFile((URI)URI.create(embedded.toExternalForm())).getAbsolutePath();
                        }
                    }
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(item);
                }
                return sb.toString();
            }
            return NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_classpath_unknown");
        }
    }

    private final class ClassFileVersionProperty
    extends PropertySupport.ReadOnly<String> {
        public static final Duration REFRESH = Duration.ofSeconds(5L);
        private Instant expiration;
        private String version;

        public ClassFileVersionProperty() {
            super("classfile_version", String.class, NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_classfile_version"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_classfile_version"));
            this.expiration = Instant.now();
            this.version = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getValue() {
            FileObject file = JavaNode.this.getDataObject().getPrimaryFile();
            if (this.version != null && Instant.now().isBefore(this.expiration)) {
                return this.version;
            }
            try (InputStream in = file.getInputStream();){
                ByteBuffer bytes = ByteBuffer.wrap(in.readNBytes(8));
                if (bytes.capacity() == 8 && bytes.getInt() == HexFormat.fromHexDigits("CAFEBABE")) {
                    char minor = bytes.getChar();
                    char major = bytes.getChar();
                    this.version = major >= '7' ? major + " (Java " + (major - 44) + (minor == '\uffff' ? ", preview enabled" : "") + ")" : major + "." + minor + " (Java " + (major - 44) + ")";
                    this.expiration = Instant.now().plus(REFRESH);
                    String string = this.version;
                    return string;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.version = "unknown";
            return this.version;
        }
    }

    private static final class JavaFileBooleanAttributeProperty
    extends PropertySupport.ReadWrite<Boolean> {
        private final String attribute;
        private final DataObject dObj;

        public JavaFileBooleanAttributeProperty(DataObject dObj, String attribute, String name, String msgKeyPart) {
            super(name, Boolean.class, NbBundle.getMessage(JavaNode.class, (String)("PROP_JavaNode_" + msgKeyPart)), NbBundle.getMessage(JavaNode.class, (String)("HINT_JavaNode_" + msgKeyPart)));
            this.dObj = dObj;
            this.attribute = attribute;
        }

        public Boolean getValue() {
            Boolean val;
            Object object = this.dObj.getPrimaryFile().getAttribute(this.attribute);
            return object instanceof Boolean ? (val = (Boolean)object) : Boolean.valueOf(false);
        }

        public void setValue(Boolean o) {
            try {
                this.dObj.getPrimaryFile().setAttribute(this.attribute, (Object)o);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Java File does not exist : {0}", this.dObj.getPrimaryFile().getName());
            }
        }
    }

    private static final class RunFileJDKProperty
    extends PropertySupport.ReadWrite<String> {
        private final PropertyEditorSupport jdkPicker = new JDKPicker();
        private final DataObject dObj;

        public RunFileJDKProperty(DataObject dObj) {
            super("runFileJDK", String.class, NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_singlefile_jdk"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_singlefile_jdk"));
            this.dObj = dObj;
        }

        public String getValue() {
            String jdk;
            Object object = this.dObj.getPrimaryFile().getAttribute(JavaNode.FILE_JDK);
            return object instanceof String ? (jdk = (String)object) : "";
        }

        public void setValue(String text) {
            try {
                this.dObj.getPrimaryFile().setAttribute(JavaNode.FILE_JDK, (Object)text);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Java File does not exist : {0}", this.dObj.getPrimaryFile().getName());
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.jdkPicker;
        }

        private static final class JDKPicker
        extends PropertyEditorSupport {
            private final JComboBox jdkCombo = new JComboBox();
            private final PropertyChangeListener modelUpdater = e -> this.initModel();
            private String[] jdks;

            public JDKPicker() {
                this.initModel();
                this.jdkCombo.addActionListener(e -> super.setValue(this.jdkCombo.getSelectedItem()));
                JavaPlatformManager jdkman = JavaPlatformManager.getDefault();
                jdkman.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.modelUpdater, (Object)jdkman));
            }

            private void initModel() {
                this.jdks = (String[])Stream.of(JavaPlatformManager.getDefault().getInstalledPlatforms()).filter(jdk -> JDKPicker.isCompatible(jdk.getSpecification().getVersion())).map(jdk -> jdk.getDisplayName()).sorted(Comparator.reverseOrder()).toArray(String[]::new);
                this.jdkCombo.setModel(new DefaultComboBoxModel<String>(this.jdks));
            }

            private static boolean isCompatible(SpecificationVersion jdkVerison) {
                try {
                    return Integer.parseInt(jdkVerison.toString()) >= 11;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                this.jdkCombo.setSelectedItem(text);
            }

            @Override
            public void setValue(Object value) {
                this.jdkCombo.setSelectedItem(value);
                super.setValue(value);
            }

            @Override
            public String[] getTags() {
                return this.jdks;
            }

            @Override
            public Component getCustomEditor() {
                return this.jdkCombo;
            }
        }
    }

    private static final class JavaFileAttributeProperty
    extends PropertySupport.ReadWrite<String> {
        private final String attribute;
        private final DataObject dObj;

        public JavaFileAttributeProperty(DataObject dObj, String attribute, String name, String msgKeyPart) {
            super(name, String.class, NbBundle.getMessage(JavaNode.class, (String)("PROP_JavaNode_" + msgKeyPart)), NbBundle.getMessage(JavaNode.class, (String)("HINT_JavaNode_" + msgKeyPart)));
            this.dObj = dObj;
            this.attribute = attribute;
        }

        public String getValue() {
            String val;
            Object object = this.dObj.getPrimaryFile().getAttribute(this.attribute);
            return object instanceof String ? (val = (String)object) : "";
        }

        public void setValue(String o) {
            try {
                this.dObj.getPrimaryFile().setAttribute(this.attribute, (Object)o);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Java File does not exist : {0}", this.dObj.getPrimaryFile().getName());
            }
        }
    }

    private static final class JavaFileGlobalOptionsProperty
    extends PropertySupport.ReadOnly<String> {
        public JavaFileGlobalOptionsProperty() {
            super("runFileGlobalOptions", String.class, NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_singlefile_global_options"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_singlefile_global_options"));
        }

        public String getValue() {
            return NbPreferences.forModule(JavaPlatformManager.class).get(JavaNode.GLOBAL_VM_OPTIONS, "").trim();
        }
    }
}

