/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class SpringIndex {
    private final FileObject[] binaryRoots;

    public SpringIndex(FileObject fo) {
        this.binaryRoots = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute").getRoots();
    }

    public SpringIndex(ClassPath cp) {
        this.binaryRoots = cp.getRoots();
    }

    private QuerySupport createBinaryIndex() throws IOException {
        return QuerySupport.forRoots((String)"SpringBinary", (int)1, (FileObject[])this.binaryRoots);
    }

    public Map<String, FileObject> getAllSpringLibraryDescriptors() {
        HashMap<String, FileObject> map = new HashMap<String, FileObject>();
        try {
            Collection results = this.createBinaryIndex().query("xsdSpringSchema", "true", QuerySupport.Kind.EXACT, new String[]{"xsdSpringSchema", "namespace"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                map.put(result.getValue("namespace"), file);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return map;
    }
}

