/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.callhierarchy.Call;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyTasks;
import org.openide.util.Lookup;

final class CallHierarchyModel {
    public static final String PROP_ROOT = "root";
    public static final String PROP_CONTENTS = "contents";
    private Call root;
    private HierarchyType type = HierarchyType.CALLER;
    private Set<Scope> scopes = EnumSet.of(Scope.ALL, Scope.TESTS);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    private CallHierarchyModel(HierarchyType type, Set<Scope> scopes) {
        if (type != null) {
            this.type = type;
        }
        if (scopes != null) {
            this.scopes = scopes;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public Call getRoot() {
        return this.root;
    }

    public synchronized Set<Scope> getScopes() {
        return this.scopes;
    }

    public synchronized void setScopes(Set<Scope> scopes) {
        this.scopes = scopes;
    }

    public synchronized HierarchyType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(HierarchyType type) {
        CallHierarchyModel callHierarchyModel = this;
        synchronized (callHierarchyModel) {
            this.type = type;
        }
        this.replaceRoot();
    }

    public void computeCalls(Call c, final Runnable resultHandler) {
        Runnable handlerWrapper = new Runnable(){

            @Override
            public void run() {
                CallHierarchyModel.this.support.firePropertyChange(CallHierarchyModel.PROP_CONTENTS, null, null);
                resultHandler.run();
            }
        };
        if (this.type == HierarchyType.CALLER) {
            CallHierarchyTasks.findCallers(c, this.scopes.contains((Object)Scope.TESTS), this.scopes.contains((Object)Scope.ALL), handlerWrapper);
        } else {
            CallHierarchyTasks.findCallees(c, handlerWrapper);
        }
    }

    void replaceRoot() {
        if (this.root == null) {
            return;
        }
        CallHierarchyTasks.resolveRoot(this.root.selection, this.scopes.contains((Object)Scope.BASE), this.type == HierarchyType.CALLER, (Task<Call>)new ReplaceRootTask(this));
    }

    void replaceRoot(Call root) {
        Call oroot = this.root;
        if (root == null || oroot != null && root.isIncomplete()) {
            return;
        }
        root.model = this;
        this.root = root;
        this.support.firePropertyChange(PROP_ROOT, oroot, root);
    }

    static CallHierarchyModel create(Lookup context, Set<Scope> scopes, HierarchyType type) {
        boolean isCallerGraph = type == null || type == HierarchyType.CALLER;
        CallHierarchyModel m = new CallHierarchyModel(type, scopes);
        boolean bl = scopes.contains((Object)Scope.BASE);
        CallHierarchyModel callHierarchyModel = m;
        Objects.requireNonNull(callHierarchyModel);
        CallHierarchyTasks.resolveRoot(context, bl, isCallerGraph, (Task<Call>)callHierarchyModel.new ReplaceRootTask(m));
        return m;
    }

    static CallHierarchyModel create(TreePathHandle selection, Set<Scope> scopes, HierarchyType type) {
        boolean isCallerGraph = type == null || type == HierarchyType.CALLER;
        CallHierarchyModel m = new CallHierarchyModel(type, scopes);
        boolean bl = scopes.contains((Object)Scope.BASE);
        CallHierarchyModel callHierarchyModel = m;
        Objects.requireNonNull(callHierarchyModel);
        CallHierarchyTasks.resolveRoot(selection, bl, isCallerGraph, (Task<Call>)callHierarchyModel.new ReplaceRootTask(m));
        return m;
    }

    static enum HierarchyType {
        CALLER,
        CALLEE;

    }

    static enum Scope {
        ALL,
        PROJECT,
        TESTS,
        BASE;

    }

    private class ReplaceRootTask
    implements Task<Call> {
        CallHierarchyModel model;

        public ReplaceRootTask(CallHierarchyModel model) {
            this.model = model;
        }

        public void run(Call parameter) throws Exception {
            this.model.replaceRoot(parameter);
        }
    }
}

