/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.api.model.CdiException;
import org.netbeans.modules.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.NormalScopeChecker;
import org.netbeans.modules.web.beans.impl.model.ResultLookupStrategy;
import org.netbeans.modules.web.beans.impl.model.ScopeChecker;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;
import org.netbeans.modules.web.beans.impl.model.results.DefinitionErrorResult;
import org.netbeans.modules.web.beans.impl.model.results.ResultImpl;
import org.netbeans.modules.web.beans.model.spi.WebBeansModelProvider;
import org.openide.util.NbBundle;

abstract class ParameterInjectionPointLogic
extends FieldInjectionPointLogic
implements WebBeansModelProvider {
    static final String CONTEXT_DEPENDENT_ANNOTATION = "javax.enterprise.context.Dependent";
    static final String CONTEXT_DEPENDENT_ANNOTATION_JAKARTA = "jakarta.enterprise.context.Dependent";
    static final String DISPOSES_ANNOTATION = "javax.enterprise.inject.Disposes";
    static final String DISPOSES_ANNOTATION_JAKARTA = "jakarta.enterprise.inject.Disposes";
    static final String OBSERVES_ANNOTATION = "javax.enterprise.event.Observes";
    static final String OBSERVES_ANNOTATION_JAKARTA = "jakarta.enterprise.event.Observes";

    ParameterInjectionPointLogic(WebBeansModelImplementation model) {
        super(model);
    }

    protected DependencyInjectionResult findParameterInjectable(VariableElement element, DeclaredType parentType, ResultLookupStrategy strategy, AtomicBoolean cancel) {
        boolean observes;
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType);
        }
        catch (FieldInjectionPointLogic.DefinitionError e) {
            TypeElement type = e.getElement();
            return new DefinitionErrorResult(element, parentType, NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_BadParent", (Object)element.getSimpleName(), (Object)(type != null ? type.toString() : null)));
        }
        ExecutableElement parentMethod = (ExecutableElement)element.getEnclosingElement();
        ExecutableType methodType = (ExecutableType)this.getCompilationController().getTypes().asMemberOf(parent, parentMethod);
        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        boolean isInjectionPoint = false;
        List<? extends VariableElement> parameters = parentMethod.getParameters();
        int index = 0;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement variableElement = parameters.get(i);
            if (variableElement.equals(element)) {
                index = i;
                continue;
            }
            if (!AnnotationObjectProvider.hasAnnotation(variableElement, DISPOSES_ANNOTATION, this.getModel().getHelper()) && !AnnotationObjectProvider.hasAnnotation(variableElement, OBSERVES_ANNOTATION, this.getModel().getHelper()) && !AnnotationObjectProvider.hasAnnotation(variableElement, DISPOSES_ANNOTATION_JAKARTA, this.getModel().getHelper()) && !AnnotationObjectProvider.hasAnnotation(variableElement, OBSERVES_ANNOTATION_JAKARTA, this.getModel().getHelper())) continue;
            isInjectionPoint = true;
        }
        TypeMirror elementType = strategy.getType(this.getModel(), parameterTypes.get(index));
        DependencyInjectionResult result = null;
        boolean disposes = AnnotationObjectProvider.hasAnnotation(element, DISPOSES_ANNOTATION, this.getModel().getHelper()) || AnnotationObjectProvider.hasAnnotation(element, DISPOSES_ANNOTATION_JAKARTA, this.getModel().getHelper());
        boolean bl = observes = AnnotationObjectProvider.hasAnnotation(element, OBSERVES_ANNOTATION, this.getModel().getHelper()) || AnnotationObjectProvider.hasAnnotation(element, OBSERVES_ANNOTATION_JAKARTA, this.getModel().getHelper());
        if (isInjectionPoint || AnnotationObjectProvider.hasAnnotation(parentMethod, "javax.inject.Inject", this.getModel().getHelper()) || AnnotationObjectProvider.hasAnnotation(parentMethod, "javax.enterprise.inject.Produces", this.getModel().getHelper()) || AnnotationObjectProvider.hasAnnotation(parentMethod, "jakarta.inject.Inject", this.getModel().getHelper()) || AnnotationObjectProvider.hasAnnotation(parentMethod, "jakarta.enterprise.inject.Produces", this.getModel().getHelper()) || disposes || observes) {
            result = this.doFindVariableInjectable(element, elementType, false, cancel);
            isInjectionPoint = true;
        }
        if (disposes) {
            if (result instanceof ResultImpl) {
                ((ResultImpl)result).getTypeElements().clear();
                Set<Element> productions = ((ResultImpl)result).getProductions();
                TypeElement enclosingTypeElement = this.getCompilationController().getElementUtilities().enclosingTypeElement((Element)element);
                Iterator<Element> iterator = productions.iterator();
                while (iterator.hasNext()) {
                    Element injectable = iterator.next();
                    if (injectable instanceof ExecutableElement && this.getCompilationController().getElementUtilities().isMemberOf(injectable, enclosingTypeElement)) continue;
                    iterator.remove();
                }
            } else {
                return result;
            }
        }
        if (isInjectionPoint) {
            return strategy.getResult(this.getModel(), result, cancel);
        }
        return new DefinitionErrorResult(element, elementType, NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_NoInjectPoint", (Object)element.getSimpleName()));
    }

    @Override
    public boolean isDynamicInjectionPoint(VariableElement element) {
        TypeMirror type = this.getParameterType(element, null, "jakarta.enterprise.inject.Instance");
        if (type == null) {
            type = this.getParameterType(element, null, "javax.enterprise.inject.Instance");
        }
        if (type != null) {
            try {
                return this.isInjectionPoint(element);
            }
            catch (InjectionPointDefinitionError e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getScope(Element element) throws CdiException {
        return ParameterInjectionPointLogic.getScope(element, this.getModel().getHelper());
    }

    public static String getScope(Element element, AnnotationModelHelper helper) throws CdiException {
        boolean javaxInjectPresent;
        String scope = ParameterInjectionPointLogic.getDeclaredScope(element, helper);
        if (scope != null) {
            return scope;
        }
        List<AnnotationMirror> stereotypes = WebBeansModelProviderImpl.getAllStereotypes(element, helper.getHelper());
        for (AnnotationMirror annotationMirror : stereotypes) {
            String declaredScope;
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Element annotationElement = annotationType.asElement();
            if (annotationElement == null || (declaredScope = ParameterInjectionPointLogic.getDeclaredScope(annotationElement, helper)) == null) continue;
            if (scope == null) {
                scope = declaredScope;
                continue;
            }
            if (scope.equals(declaredScope)) continue;
            throw new CdiException(NbBundle.getMessage(ParameterInjectionPointLogic.class, (String)"ERR_DefaultScopeCollision", (Object)scope, (Object)declaredScope));
        }
        if (scope != null) {
            return scope;
        }
        ClassPath cp = helper.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
        boolean jakartaInjectPresent = cp.findResource("jakarta/inject/Qualifier.class") != null;
        boolean bl = javaxInjectPresent = cp.findResource("javax/inject/Qualifier.class") != null;
        if (jakartaInjectPresent || !javaxInjectPresent) {
            return CONTEXT_DEPENDENT_ANNOTATION_JAKARTA;
        }
        return CONTEXT_DEPENDENT_ANNOTATION;
    }

    static String getDeclaredScope(Element element, AnnotationModelHelper helper) throws CdiException {
        NormalScopeChecker normalScopeChecker;
        ScopeChecker scopeChecker;
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        String scope = ParameterInjectionPointLogic.getDeclaredScope(helper, annotationMirrors, scopeChecker = ScopeChecker.get(), normalScopeChecker = NormalScopeChecker.get(), true);
        if (scope != null) {
            return scope;
        }
        annotationMirrors = helper.getCompilationController().getElements().getAllAnnotationMirrors(element);
        return ParameterInjectionPointLogic.getDeclaredScope(helper, annotationMirrors, scopeChecker, normalScopeChecker, false);
    }

    private static String getDeclaredScope(AnnotationModelHelper helper, List<? extends AnnotationMirror> annotationMirrors, ScopeChecker scopeChecker, NormalScopeChecker normalScopeChecker, boolean singleScopeRequired) throws CdiException {
        List<? extends AnnotationMirror> annotations = annotationMirrors;
        if (!singleScopeRequired) {
            annotations = new ArrayList<AnnotationMirror>(annotationMirrors);
            Collections.reverse(annotations);
        }
        String scope = null;
        for (AnnotationMirror annotationMirror : annotations) {
            String declaredScope = null;
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Element annotationElement = annotationType.asElement();
            if (!(annotationElement instanceof TypeElement)) continue;
            TypeElement annotation = (TypeElement)annotationElement;
            scopeChecker.init(annotation, helper);
            if (scopeChecker.check()) {
                declaredScope = annotation.getQualifiedName().toString();
            }
            normalScopeChecker.init(annotation, helper);
            if (normalScopeChecker.check()) {
                declaredScope = annotation.getQualifiedName().toString();
            }
            if (declaredScope == null) continue;
            if (!singleScopeRequired) {
                return declaredScope;
            }
            if (scope != null) {
                throw new CdiException(NbBundle.getMessage(ParameterInjectionPointLogic.class, (String)"ERR_SeveralScopes"));
            }
            scope = declaredScope;
        }
        return scope;
    }

    protected TypeMirror getParameterType(Element element, DeclaredType parentType, String ... interfaceFqns) {
        return ParameterInjectionPointLogic.getParameterType(this.getCompilationController(), element, parentType, interfaceFqns);
    }

    static TypeMirror getParameterType(CompilationController controller, Element element, DeclaredType parentType, String ... interfaceFqns) {
        TypeMirror elementType = null;
        elementType = parentType == null ? element.asType() : controller.getTypes().asMemberOf(parentType, element);
        return ParameterInjectionPointLogic.getParameterType(elementType, interfaceFqns);
    }

    static TypeMirror getParameterType(TypeMirror elementType, String ... interfaceFqns) {
        DeclaredType declaredType;
        Element elementDeclaredType;
        if (elementType instanceof DeclaredType && (elementDeclaredType = (declaredType = (DeclaredType)elementType).asElement()) != null && elementDeclaredType.getKind() == ElementKind.INTERFACE) {
            String typeFqn = ((TypeElement)elementDeclaredType).getQualifiedName().toString();
            for (String interfaceFqn : interfaceFqns) {
                List<? extends TypeMirror> typeArguments;
                if (!interfaceFqn.equals(typeFqn) || (typeArguments = declaredType.getTypeArguments()).size() <= 0) continue;
                return typeArguments.get(0);
            }
        }
        return null;
    }
}

