/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.web.core.palette.JspPaletteUtilities;
import org.netbeans.modules.web.core.palette.items.ChooseCustomizer;
import org.openide.text.ActiveEditorDrop;

public class Choose
implements ActiveEditorDrop {
    public static final int DEFAULT_WHENS = 1;
    private int whens = 1;
    private boolean otherwise = true;

    public boolean handleTransfer(JTextComponent targetComponent) {
        ChooseCustomizer c = new ChooseCustomizer(this, targetComponent);
        boolean accept = c.showDialog();
        if (accept) {
            String prefix = JspPaletteUtilities.findJstlPrefix(targetComponent);
            String body = this.createBody(prefix);
            try {
                JspPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody(String prefix) {
        return "<" + prefix + ":choose>\n" + this.generateChooseBody(prefix) + "</" + prefix + ":choose>\n";
    }

    private String generateChooseBody(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + prefix + ":when test=\"" + "&CARET&" + "\">\n</" + prefix + ":when>\n");
        for (int i = 1; i < this.whens; ++i) {
            sb.append("<" + prefix + ":when test=\"\">\n</" + prefix + ":when>\n");
        }
        if (this.otherwise) {
            sb.append("<" + prefix + ":otherwise>\n</" + prefix + ":otherwise>\n");
        }
        return sb.toString();
    }

    public int getWhens() {
        return this.whens;
    }

    public void setWhens(int whens) {
        this.whens = whens;
    }

    public boolean isOtherwise() {
        return this.otherwise;
    }

    public void setOtherwise(boolean otherwise) {
        this.otherwise = otherwise;
    }
}

