/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.CoreManager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.gsf.testrunner.api.UnitTestsUsage;
import org.netbeans.modules.junit.api.JUnitTestSuite;
import org.netbeans.modules.junit.api.JUnitTestcase;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.junit.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class JUnitOutputListenerProvider
implements OutputProcessor {
    private static final String TESTTYPE_UNIT = "UNIT";
    private static final String TESTTYPE_INTEGRATION = "INTEGRATION";
    private String testType;
    private String reportNameSuffix;
    private final Pattern runningPattern;
    private final Pattern outDirPattern2;
    private final Pattern outDirPattern;
    private String runningTestClass;
    private final Set<String> usedNames;
    private final long startTimeStamp;
    private static final Logger LOG = Logger.getLogger(JUnitOutputListenerProvider.class.getName());
    private final RunConfig config;
    private boolean surefireRunningInParallel = false;
    private final Map<String, Set<File>> runningTestClass2outputDirs = new HashMap<String, Set<File>>();
    private final ArrayList<String> runningTestClassesInParallel = new ArrayList();
    private final Map<Project, File> project2outputDirs = new HashMap<Project, File>();
    private final Map<File, TestSession> outputDir2sessions = new HashMap<File, TestSession>();
    private static final String GROUP_FILE_NAME = "dir";
    private static final String SECONDS_REGEX = "s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    private static final String TESTSUITE_STATS_REGEX = "Tests run: +([0-9]+), +Failures: +([0-9]+), +Errors: +([0-9]+), +Skipped: +([0-9]+), +Time elapsed: +(.+)s(?:ec(?:ond)?(?:s|\\(s\\))?)? *(?: * <+ FAILURE! *)?-+ in (.*)";
    private static final Pattern testSuiteStatsPattern = Pattern.compile("Tests run: +([0-9]+), +Failures: +([0-9]+), +Errors: +([0-9]+), +Skipped: +([0-9]+), +Time elapsed: +(.+)s(?:ec(?:ond)?(?:s|\\(s\\))?)? *(?: * <+ FAILURE! *)?-+ in (.*)");
    private static final String JAVA_ID_START_REGEX = "\\p{javaJavaIdentifierStart}";
    private static final String JAVA_ID_PART_REGEX = "\\p{javaJavaIdentifierPart}";
    private static final String JAVA_ID_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*";
    private static final String JAVA_ID_REGEX_FULL = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*";
    private static final Pattern fullJavaIdPattern = Pattern.compile("(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*");
    private static final Pattern COMPARISON_PATTERN = Pattern.compile(".*expected:<(.*)> but was:<(.*)>$");
    private static final Pattern COMPARISON_PATTERN_AFTER_65 = Pattern.compile(".*expected \\[(.*)\\] but found \\[(.*)\\]$");

    public JUnitOutputListenerProvider(RunConfig config) {
        this.runningPattern = Pattern.compile("(?:\\[(?:INFO|surefire)\\] )?Running (.*)", 32);
        this.outDirPattern = Pattern.compile("(?:\\[INFO\\] )?Surefire report directory\\: (?<dir>.*)", 32);
        this.outDirPattern2 = Pattern.compile("(?:\\[INFO\\] )?Setting reports dir\\: (?<dir>.*)", 32);
        this.config = config;
        this.usedNames = new HashSet<String>();
        this.startTimeStamp = System.currentTimeMillis();
        this.surefireRunningInParallel = this.isSurefireRunningInParallel();
    }

    private boolean isSurefireRunningInParallel() {
        String forkCount;
        String forkMode;
        String parallel;
        String string = parallel = this.config.getProperties().containsKey("parallel") ? (String)this.config.getProperties().get("parallel") : PluginPropertyUtils.getPluginProperty((MavenProject)this.config.getMavenProject(), (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin", (String)"parallel", (String)"test", (String)"parallel");
        if (parallel != null) {
            return true;
        }
        String string2 = forkMode = this.config.getProperties().containsKey("forkMode") ? (String)this.config.getProperties().get("forkMode") : PluginPropertyUtils.getPluginProperty((MavenProject)this.config.getMavenProject(), (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin", (String)"forkMode", (String)"test", (String)"forkMode");
        if ("perthread".equals(forkMode)) {
            String threadCount;
            String string3 = threadCount = this.config.getProperties().containsKey("threadCount") ? (String)this.config.getProperties().get("threadCount") : PluginPropertyUtils.getPluginProperty((MavenProject)this.config.getMavenProject(), (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin", (String)"threadCount", (String)"test", (String)"threadCount");
            if (threadCount != null && Integer.parseInt(threadCount) > 1) {
                return true;
            }
        }
        String string4 = forkCount = this.config.getProperties().containsKey("forkCount") ? (String)this.config.getProperties().get("forkCount") : PluginPropertyUtils.getPluginProperty((MavenProject)this.config.getMavenProject(), (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin", (String)"forkCount", (String)"test", (String)"forkCount");
        if (forkCount != null) {
            float forks;
            int index = forkCount.indexOf("C");
            int cpuCores = 1;
            if (index != -1) {
                forkCount = forkCount.substring(0, index);
                cpuCores = Runtime.getRuntime().availableProcessors();
            }
            try {
                forks = NumberFormat.getNumberInstance(Locale.ENGLISH).parse(forkCount).floatValue();
            }
            catch (ParseException ex) {
                LOG.log(Level.FINE, null, ex);
                forks = 1.0f;
            }
            if (forks * (float)cpuCores > 1.0f) {
                return true;
            }
        }
        return false;
    }

    public String[] getRegisteredOutputSequences() {
        return new String[]{"mojo-execute#surefire:test", "mojo-execute#failsafe:integration-test"};
    }

    public void processLine(String line, OutputVisitor visitor) {
        Matcher match = this.outDirPattern.matcher(line);
        if (match.matches()) {
            File outputDir = new File(match.group(GROUP_FILE_NAME));
            LOG.log(Level.FINER, "Line matches reports directory: {0}", outputDir);
            this.createSession(outputDir);
            return;
        }
        match = this.outDirPattern2.matcher(line);
        if (match.matches()) {
            File outputDir = new File(match.group(GROUP_FILE_NAME));
            LOG.log(Level.FINER, "Line matches reports directory: {0}", outputDir);
            this.createSession(outputDir);
            return;
        }
        if (this.outputDir2sessions.isEmpty()) {
            return;
        }
        match = this.runningPattern.matcher(line);
        if (match.matches()) {
            if (this.surefireRunningInParallel) {
                this.runningTestClassesInParallel.add(match.group(1));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Got running test: line {0}, class: {1}. Parallel run: {2}", new Object[]{line, match.group(1), this.runningTestClassesInParallel.toString()});
                }
            } else {
                if (this.runningTestClass != null) {
                    LOG.log(Level.FINE, "Got running test SINGLE: line {0}, class: {1}", new Object[]{line, match.group(1)});
                    if (!JUnitOutputListenerProvider.isFullJavaId(match.group(1))) {
                        LOG.log(Level.FINE, "Not full java id match!");
                        return;
                    }
                    this.generateTest();
                }
                this.runningTestClass = match.group(1);
            }
        }
        if ((match = testSuiteStatsPattern.matcher(line)).matches() && this.surefireRunningInParallel) {
            this.runningTestClass = match.group(6);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Got test statistics: {0}, running classes: {1}", new Object[]{match.group(6), this.runningTestClassesInParallel.toString()});
            }
            if (this.runningTestClass != null) {
                if (!JUnitOutputListenerProvider.isFullJavaId(this.runningTestClass)) {
                    return;
                }
                this.generateTest();
                this.runningTestClassesInParallel.remove(this.runningTestClass);
                this.runningTestClass = null;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Statistics done for {0}. Cleaning runnintTestClass, stillRunning: {1}", new Object[]{match.group(6), this.runningTestClassesInParallel.toString()});
                }
            }
        }
    }

    static boolean isTestSuiteStats(String line) {
        return testSuiteStatsPattern.matcher(line).matches();
    }

    static String getTestSuiteFromStats(String line) {
        Matcher matcher = testSuiteStatsPattern.matcher(line);
        return matcher.matches() ? matcher.group(6) : null;
    }

    static boolean isFullJavaId(String possibleNewRunningTestClass) {
        return fullJavaIdPattern.matcher(possibleNewRunningTestClass).matches();
    }

    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        this.reportNameSuffix = null;
        this.testType = null;
        String reportsDirectory = null;
        if ("mojo-execute#surefire:test".equals(sequenceId)) {
            if (this.usingSurefire219(this.config.getMavenProject())) {
                reportsDirectory = this.getReportsDirectory("org.apache.maven.plugins", "maven-surefire-plugin", "test", visitor, "${project.build.directory}/surefire-reports");
            }
            this.reportNameSuffix = PluginPropertyUtils.getPluginProperty((MavenProject)this.config.getMavenProject(), (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin", (String)"reportNameSuffix", (String)"test", (String)"surefire.reportNameSuffix");
            this.testType = TESTTYPE_UNIT;
        } else if ("mojo-execute#failsafe:integration-test".equals(sequenceId)) {
            reportsDirectory = this.getReportsDirectory("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test", visitor, "${project.build.directory}/failsafe-reports");
            this.reportNameSuffix = PluginPropertyUtils.getPluginProperty((MavenProject)this.config.getMavenProject(), (String)"org.apache.maven.plugins", (String)"maven-failsafe-plugin", (String)"reportNameSuffix", (String)"integration-test", (String)"surefire.reportNameSuffix");
            this.testType = TESTTYPE_INTEGRATION;
        }
        if (null != reportsDirectory) {
            File outputDir = null;
            File absoluteFile = new File(reportsDirectory);
            File relativeFile = new File(this.config.getMavenProject().getBasedir(), reportsDirectory);
            if (absoluteFile.exists() && absoluteFile.isDirectory()) {
                outputDir = absoluteFile;
            } else if (relativeFile.exists() && relativeFile.isDirectory()) {
                outputDir = relativeFile;
            } else {
                File parentFile = absoluteFile.getParentFile();
                if (parentFile.exists() && parentFile.isDirectory()) {
                    absoluteFile.mkdir();
                    if (absoluteFile.exists() && absoluteFile.isDirectory()) {
                        outputDir = absoluteFile;
                    }
                } else {
                    File parentRelativeFile = relativeFile.getParentFile();
                    if (parentRelativeFile.exists() && parentRelativeFile.isDirectory()) {
                        relativeFile.mkdir();
                        if (relativeFile.exists() && relativeFile.isDirectory()) {
                            outputDir = relativeFile;
                        }
                    }
                }
            }
            if (null != outputDir) {
                this.createSession(outputDir);
                this.project2outputDirs.put(visitor.getContext().getCurrentProject(), outputDir);
            }
        }
    }

    private String getReportsDirectory(String groupId, String artifactId, String goal, OutputVisitor visitor, String fallbackExpression) {
        String reportsDirectory;
        NbMavenProject subProject;
        MavenProject currentProject = null;
        OutputVisitor.Context context = visitor.getContext();
        if (context != null && context.getCurrentProject() != null && (subProject = (NbMavenProject)context.getCurrentProject().getLookup().lookup(NbMavenProject.class)) != null) {
            currentProject = subProject.getMavenProject();
        }
        if (currentProject == null) {
            currentProject = this.config.getMavenProject();
        }
        if ((reportsDirectory = PluginPropertyUtils.getPluginProperty((MavenProject)currentProject, (String)groupId, (String)artifactId, (String)"reportsDirectory", (String)goal, null)) == null) {
            try {
                Object defaultValue = PluginPropertyUtils.createEvaluator((MavenProject)currentProject).evaluate(fallbackExpression);
                if (defaultValue instanceof String) {
                    reportsDirectory = (String)defaultValue;
                }
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {
                // empty catch block
            }
        }
        return reportsDirectory;
    }

    private String createSessionName(String projectId) {
        String name = this.testType != null && this.testType.equals(TESTTYPE_INTEGRATION) ? Bundle.LBL_TESTTYPE_INTEGRATION(projectId) : Bundle.LBL_TESTTYPE_UNIT(projectId);
        int index = 2;
        while (this.usedNames.contains(name)) {
            name = this.testType != null && this.testType.equals(TESTTYPE_INTEGRATION) ? Bundle.LBL_TESTTYPE_INTEGRATION_INDEXED(projectId, index) : Bundle.LBL_TESTTYPE_UNIT_INDEXED(projectId, index);
            ++index;
        }
        this.usedNames.add(name);
        return name;
    }

    private CoreManager getManagerProvider() {
        Collection providers = Lookup.getDefault().lookupResult(CoreManager.class).allItems();
        for (Lookup.Item provider : providers) {
            if (!provider.getDisplayName().equals("maven".concat("_").concat("junit"))) continue;
            return (CoreManager)provider.getInstance();
        }
        return null;
    }

    private void createSession(File nonNormalizedFile) {
        if (!this.outputDir2sessions.containsKey(nonNormalizedFile)) {
            NbMavenProject mvnprj;
            File fil = FileUtil.normalizeFile((File)nonNormalizedFile);
            Project prj = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)fil));
            LOG.log(Level.FINE, "Creating session for project {0}", prj);
            if (prj != null && (mvnprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class)) != null) {
                LOG.log(Level.FINE, "Maven project instance: {0}", mvnprj);
                File projectFile = FileUtil.toFile((FileObject)prj.getProjectDirectory());
                if (projectFile != null) {
                    UnitTestsUsage.getInstance().logUnitTestUsage(Utilities.toURI((File)projectFile), this.getJUnitVersion(this.config.getMavenProject()));
                }
                TestSession.SessionType type = TestSession.SessionType.TEST;
                String action = this.config.getActionName();
                if (action != null && action.contains("debug")) {
                    type = TestSession.SessionType.DEBUG;
                }
                final TestSession.SessionType fType = type;
                CoreManager junitManager = this.getManagerProvider();
                if (junitManager != null) {
                    junitManager.registerNodeFactory();
                }
                TestSession session = new TestSession(this.createSessionName(mvnprj.getMavenProject().getId()), prj, TestSession.SessionType.TEST);
                this.outputDir2sessions.put(nonNormalizedFile, session);
                LOG.log(Level.FINE, "Created session: {0}", session);
                session.setRerunHandler(new RerunHandler(){

                    public void rerun() {
                        RunUtils.executeMaven((RunConfig)JUnitOutputListenerProvider.this.config);
                    }

                    public void rerun(Set<Testcase> tests) {
                        RunConfig brc = RunUtils.cloneRunConfig((RunConfig)JUnitOutputListenerProvider.this.config);
                        StringBuilder tst = new StringBuilder();
                        HashMap<String, ArrayList<String>> methods = new HashMap<String, ArrayList<String>>();
                        int windowslimitcount = 0;
                        for (Testcase tc : tests) {
                            if (tc.getClassName() == null) continue;
                            ArrayList<String> lst = (ArrayList<String>)methods.get(tc.getClassName());
                            if (lst == null) {
                                lst = new ArrayList<String>();
                                methods.put(tc.getClassName(), lst);
                                windowslimitcount = windowslimitcount + tc.getClassName().length() + 1;
                            }
                            lst.add(tc.getName());
                            windowslimitcount = windowslimitcount + tc.getName().length() + 1;
                        }
                        boolean exceedsWindowsLimit = Utilities.isWindows() && windowslimitcount > 6000;
                        for (Map.Entry ent : methods.entrySet()) {
                            tst.append(",");
                            if (exceedsWindowsLimit) {
                                String clazzName = (String)ent.getKey();
                                int lastDot = ((String)ent.getKey()).lastIndexOf(".");
                                if (lastDot > -1) {
                                    clazzName = clazzName.substring(lastDot + 1);
                                }
                                tst.append(clazzName);
                            } else {
                                tst.append((String)ent.getKey());
                            }
                            tst.append("#");
                            boolean first = true;
                            for (String meth : (Collection)ent.getValue()) {
                                if (!first) {
                                    tst.append("+");
                                }
                                first = false;
                                tst.append(meth);
                            }
                        }
                        if (tst.length() > 0) {
                            brc.setProperty("test", tst.substring(1));
                        }
                        RunUtils.executeMaven((RunConfig)brc);
                    }

                    public boolean enabled(RerunType type) {
                        if (fType.equals((Object)TestSession.SessionType.TEST) || fType.equals((Object)TestSession.SessionType.DEBUG)) {
                            if (RerunType.ALL.equals((Object)type)) {
                                return true;
                            }
                            if (RerunType.CUSTOM.equals((Object)type)) {
                                if (JUnitOutputListenerProvider.this.usingTestNG(JUnitOutputListenerProvider.this.config.getMavenProject())) {
                                    return JUnitOutputListenerProvider.this.usingSurefire28(JUnitOutputListenerProvider.this.config.getMavenProject());
                                }
                                if (JUnitOutputListenerProvider.this.usingJUnit4(JUnitOutputListenerProvider.this.config.getMavenProject())) {
                                    return JUnitOutputListenerProvider.this.usingSurefire2121(JUnitOutputListenerProvider.this.config.getMavenProject());
                                }
                                if (JUnitOutputListenerProvider.this.getJUnitVersion(JUnitOutputListenerProvider.this.config.getMavenProject()).equals("JUNIT5")) {
                                    return JUnitOutputListenerProvider.this.usingSurefire2220(JUnitOutputListenerProvider.this.config.getMavenProject());
                                }
                            }
                        }
                        return false;
                    }

                    public void addChangeListener(ChangeListener listener) {
                    }

                    public void removeChangeListener(ChangeListener listener) {
                    }
                });
                if (junitManager != null) {
                    junitManager.testStarted(session);
                }
            }
        } else {
            LOG.log(Level.FINE, "Session for directory {0} already opened", nonNormalizedFile);
        }
    }

    private boolean usingSurefire219(MavenProject prj) {
        String v = PluginPropertyUtils.getPluginVersion((MavenProject)prj, (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("2.19")) >= 0;
    }

    private boolean usingSurefire2121(MavenProject prj) {
        String v = PluginPropertyUtils.getPluginVersion((MavenProject)prj, (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("2.12.1")) >= 0;
    }

    private boolean usingSurefire28(MavenProject prj) {
        String v = PluginPropertyUtils.getPluginVersion((MavenProject)prj, (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("2.8")) >= 0;
    }

    private boolean usingSurefire2220(MavenProject prj) {
        String v = PluginPropertyUtils.getPluginVersion((MavenProject)prj, (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("2.22.0")) >= 0;
    }

    private boolean usingTestNG(MavenProject prj) {
        for (Artifact a : prj.getArtifacts()) {
            if (!"org.testng".equals(a.getGroupId()) || !"testng".equals(a.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private String getJUnitVersion(MavenProject prj) {
        String juVersion = "";
        for (Artifact a : prj.getArtifacts()) {
            String version;
            if ("junit".equals(a.getGroupId()) && ("junit".equals(a.getArtifactId()) || "junit-dep".equals(a.getArtifactId()))) {
                version = a.getVersion();
                if (version != null && new ComparableVersion(version).compareTo(new ComparableVersion("4.8")) >= 0) {
                    return "JUNIT4";
                }
                if (version != null && new ComparableVersion(version).compareTo(new ComparableVersion("3.8")) >= 0) {
                    return "JUNIT3";
                }
            }
            if (!"org.junit.jupiter".equals(a.getGroupId()) || !"junit-jupiter-api".equals(a.getArtifactId()) || (version = a.getVersion()) == null || new ComparableVersion(version).compareTo(new ComparableVersion("5.0")) < 0) continue;
            return "JUNIT5";
        }
        return juVersion;
    }

    private boolean usingJUnit4(MavenProject prj) {
        for (Artifact a : prj.getArtifacts()) {
            String version;
            if (!"junit".equals(a.getGroupId()) || !"junit".equals(a.getArtifactId()) && !"junit-dep".equals(a.getArtifactId()) || (version = a.getVersion()) == null || new ComparableVersion(version).compareTo(new ComparableVersion("4.8")) < 0) continue;
            return true;
        }
        return false;
    }

    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
        CoreManager junitManager;
        File outputDir;
        TestSession session;
        if (this.outputDir2sessions.isEmpty()) {
            return;
        }
        if (this.runningTestClass != null) {
            this.generateTest();
        }
        TestSession testSession = session = (outputDir = this.project2outputDirs.remove(visitor.getContext().getCurrentProject())) != null ? this.outputDir2sessions.remove(outputDir) : null;
        if (session != null && (junitManager = this.getManagerProvider()) != null) {
            junitManager.sessionFinished(session);
        }
        this.runningTestClass = null;
    }

    static Trouble constructTrouble(@NonNull String type, @NullAllowed String message, @NullAllowed String text, boolean error) {
        Trouble t = new Trouble(error);
        if (message != null) {
            Matcher match = COMPARISON_PATTERN.matcher(message);
            if (match.matches()) {
                t.setComparisonFailure(new Trouble.ComparisonFailure(match.group(1), match.group(2)));
            } else {
                match = COMPARISON_PATTERN_AFTER_65.matcher(message);
                if (match.matches()) {
                    t.setComparisonFailure(new Trouble.ComparisonFailure(match.group(1), match.group(2)));
                }
            }
        }
        if (text != null) {
            String[] strs = StringUtils.split((String)text, (String)"\n");
            ArrayList<String> lines = new ArrayList<String>();
            if (message != null) {
                lines.add(message);
            }
            lines.add(type);
            for (int i = 1; i < strs.length; ++i) {
                lines.add(strs[i]);
            }
            t.setStackTrace(lines.toArray(new String[0]));
        }
        return t;
    }

    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
        LOG.log(Level.FINE, "Got sequenceFail: {0}, line {1}", new Object[]{visitor.getContext().getCurrentProject(), visitor.getLine()});
        if (this.surefireRunningInParallel) {
            String saveRunningTestClass = this.runningTestClass;
            Project currentProject = visitor.getContext().getCurrentProject();
            for (String s : this.runningTestClassesInParallel) {
                Project outputOwner;
                File outputDir = this.locateOutputDirAndWait(s, false);
                if (outputDir == null || (outputOwner = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)outputDir))) != currentProject) continue;
                LOG.log(Level.FINE, "Found unfinished test {0} in {1}, trying to finish", new Object[]{s, currentProject});
                this.runningTestClass = s;
                if (Objects.equals(saveRunningTestClass, s)) {
                    saveRunningTestClass = null;
                }
                this.generateTest();
            }
            this.runningTestClass = saveRunningTestClass;
        }
        this.sequenceEnd(sequenceId, visitor);
    }

    private File locateOutputDirAndWait(String candidateClass, boolean consume) {
        String suffix = this.reportNameSuffix == null ? "" : "-" + this.reportNameSuffix;
        File outputDir = this.locateOutputDir(candidateClass, suffix, consume);
        if (outputDir == null && this.surefireRunningInParallel) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            outputDir = this.locateOutputDir(candidateClass, suffix, consume);
        }
        return outputDir;
    }

    private void generateTest() {
        TestSession session;
        File report;
        LOG.log(Level.FINE, "generateTest called for class {0}, ", new Object[]{this.runningTestClass});
        File outputDir = this.locateOutputDirAndWait(this.runningTestClass, true);
        if (outputDir == null) {
            LOG.log(Level.WARNING, "Output directory is not created");
        }
        String suffix = this.reportNameSuffix == null ? "" : "-" + this.reportNameSuffix;
        File file = report = outputDir != null ? new File(outputDir, "TEST-" + this.runningTestClass + suffix + ".xml") : null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Reading report file {0}, class {1}, timestamp {2}", new Object[]{report, this.runningTestClass, report == null ? Integer.valueOf(-1) : new Date(report.lastModified())});
        }
        TestSession testSession = session = outputDir != null ? this.outputDir2sessions.get(outputDir) : null;
        if (outputDir == null || report == null || session == null) {
            LOG.log(Level.FINE, "No session for outdir {0}", outputDir);
            return;
        }
        if (report.length() > 0x3200000L) {
            LOG.log(Level.INFO, "Skipping report file as size is too big (> 50MB): {0}", report.getPath());
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Document document = null;
            try {
                document = builder.build(report);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "Exception reading from file {0}", report);
                try {
                    Thread.sleep(500L);
                    document = builder.build(report);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (JDOMException ex) {
                    LOG.log(Level.WARNING, "parsing " + report, x);
                }
            }
            if (document == null) {
                LOG.log(Level.WARNING, "No document read from dir {0}", outputDir);
                return;
            }
            Element testSuite = document.getRootElement();
            assert ("testsuite".equals(testSuite.getName())) : "Root name " + testSuite.getName();
            JUnitTestSuite suite = new JUnitTestSuite(testSuite.getAttributeValue("name"), session);
            session.addSuite((TestSuite)suite);
            CoreManager junitManager = this.getManagerProvider();
            if (junitManager != null) {
                junitManager.displaySuiteRunning(session, (TestSuite)suite);
            }
            File output = new File(outputDir, this.runningTestClass + suffix + "-output.txt");
            List testcases = testSuite.getChildren("testcase");
            String nameSuffix = this.reportNameSuffix != null ? "(" + this.reportNameSuffix + ")" : "";
            for (Element testcase : testcases) {
                String classname;
                String time;
                Element skipped;
                Element error;
                String name = testcase.getAttributeValue("name");
                if (name.endsWith(nameSuffix)) {
                    name = name.substring(0, name.length() - nameSuffix.length());
                }
                String displayName = name;
                String methodName = name;
                int dotCodePoint = ".".codePointAt(0);
                for (int i = 0; i < name.length(); ++i) {
                    int codePoint = name.codePointAt(i);
                    if (Character.isJavaIdentifierPart(codePoint) || codePoint == dotCodePoint) continue;
                    methodName = methodName.substring(0, i);
                    break;
                }
                JUnitTestcase test = new JUnitTestcase(methodName, displayName, this.testType, session);
                Element stdout = testcase.getChild("system-out");
                if (!output.isFile() && stdout != null) {
                    this.logText(stdout.getText(), (Testcase)test, false);
                }
                Element failure = testcase.getChild("failure");
                Status status = Status.PASSED;
                Trouble trouble = null;
                if (failure != null) {
                    status = Status.FAILED;
                    trouble = JUnitOutputListenerProvider.constructTrouble(failure.getAttributeValue("type"), failure.getAttributeValue("message"), failure.getText(), false);
                }
                if ((error = testcase.getChild("error")) != null) {
                    status = Status.ERROR;
                    trouble = JUnitOutputListenerProvider.constructTrouble(error.getAttributeValue("type"), error.getAttributeValue("message"), error.getText(), true);
                }
                if ((skipped = testcase.getChild("skipped")) != null) {
                    status = Status.SKIPPED;
                }
                test.setStatus(status);
                if (trouble != null) {
                    test.setTrouble(trouble);
                }
                if ((time = testcase.getAttributeValue("time")) != null) {
                    float fl = NumberFormat.getNumberInstance(Locale.ENGLISH).parse(time).floatValue();
                    test.setTimeMillis((long)(fl * 1000.0f));
                }
                if ((classname = testcase.getAttributeValue("classname")) != null) {
                    if (classname.endsWith(nameSuffix)) {
                        classname = classname.substring(0, classname.length() - nameSuffix.length());
                    }
                    test.setClassName(classname);
                    test.setLocation(test.getClassName().replace('.', '/') + ".java");
                }
                session.addTestCase((Testcase)test);
            }
            String time = testSuite.getAttributeValue("time");
            float fl = NumberFormat.getNumberInstance(Locale.ENGLISH).parse(time).floatValue();
            long timeinmilis = (long)(fl * 1000.0f);
            if (junitManager != null) {
                junitManager.displayReport(session, session.getReport(timeinmilis));
            } else {
                session.getReport(timeinmilis).setCompleted(true);
            }
            session.finishSuite((TestSuite)suite);
            if (output.isFile() && junitManager != null) {
                junitManager.displayOutput(session, FileUtils.fileRead((File)output), false);
            }
        }
        catch (IOException | ParseException x) {
            LOG.log(Level.WARNING, "parsing " + report, x);
        }
    }

    private File locateOutputDir(String runningTestClass, String suffix, boolean consume) {
        Set outputDirs = this.runningTestClass2outputDirs.computeIfAbsent(runningTestClass, t -> new HashSet());
        LOG.log(Level.FINE, "trying output dirs for class {0}: {1}, sessions: {2}", new Object[]{runningTestClass, outputDirs, this.outputDir2sessions.keySet()});
        for (File outputDir : this.outputDir2sessions.keySet()) {
            if (!outputDirs.contains(outputDir)) {
                File report = new File(outputDir, "TEST-" + runningTestClass + suffix + ".xml");
                if (report.isFile() && report.lastModified() >= this.startTimeStamp) {
                    LOG.log(Level.FINE, "Adding output dir {0} for report {1}", new Object[]{outputDir, report});
                    if (consume) {
                        outputDirs.add(outputDir);
                    }
                    return outputDir;
                }
                LOG.log(Level.FINE, "Report file  {0} exists, but is old; ignoring", report);
                continue;
            }
            LOG.log(Level.FINE, "Output dir already created, not reporting again: {0}", outputDir.getAbsolutePath());
        }
        return null;
    }

    private void logText(String text, Testcase test, boolean failure) {
        StringTokenizer tokens = new StringTokenizer(text, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            lines.add(tokens.nextToken());
        }
        CoreManager junitManager = this.getManagerProvider();
        if (junitManager != null) {
            junitManager.displayOutput(test.getSession(), text, failure);
        }
        test.addOutputLines(lines);
    }
}

