/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.ObjectVersionCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListObjectVersionsResponse
extends BmcResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String opcNextPage;
    private ObjectVersionCollection objectVersionCollection;

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public ObjectVersionCollection getObjectVersionCollection() {
        return this.objectVersionCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcClientRequestId", "opcRequestId", "opcNextPage", "objectVersionCollection"})
    private ListObjectVersionsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcClientRequestId, String opcRequestId, String opcNextPage, ObjectVersionCollection objectVersionCollection) {
        super(__httpStatusCode__, headers);
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.objectVersionCollection = objectVersionCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",objectVersionCollection=").append(String.valueOf((Object)this.objectVersionCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListObjectVersionsResponse)) {
            return false;
        }
        ListObjectVersionsResponse other = (ListObjectVersionsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.objectVersionCollection, (Object)other.objectVersionCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.objectVersionCollection == null ? 43 : this.objectVersionCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListObjectVersionsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcClientRequestId;
        private String opcRequestId;
        private String opcNextPage;
        private ObjectVersionCollection objectVersionCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder objectVersionCollection(ObjectVersionCollection objectVersionCollection) {
            this.objectVersionCollection = objectVersionCollection;
            return this;
        }

        public Builder copy(ListObjectVersionsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.objectVersionCollection(o.getObjectVersionCollection());
            return this;
        }

        public ListObjectVersionsResponse build() {
            return new ListObjectVersionsResponse(this.__httpStatusCode__, this.headers, this.opcClientRequestId, this.opcRequestId, this.opcNextPage, this.objectVersionCollection);
        }
    }
}

