/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.editor.completion.PHPCompletionItem;
import org.netbeans.modules.php.editor.elements.VariableElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class PhpElementCompletionItem {
    private PhpElementCompletionItem() {
    }

    static CompletionProposal fromPhpElement(PhpBaseElement element, PHPCompletionItem.CompletionRequest request) {
        assert (element != null);
        if (element instanceof PhpVariable) {
            return new PhpVariableCompletionItem((PhpVariable)element, request);
        }
        throw new IllegalArgumentException("Unsupported PHP element type (only variables are currently supported): " + element);
    }

    private static final class PhpVariableCompletionItem
    extends PHPCompletionItem.VariableItem {
        private final PhpVariable variable;

        public PhpVariableCompletionItem(PhpVariable variable, PHPCompletionItem.CompletionRequest request) {
            super(VariableElementImpl.create(variable.getName(), variable.getOffset(), PhpVariableCompletionItem.getFileNameUrl(variable), null, Collections.emptySet(), false), request);
            this.variable = variable;
        }

        @Override
        protected String getTypeName() {
            String fullyQualifiedName = this.variable.getFullyQualifiedName();
            if (fullyQualifiedName != null) {
                return fullyQualifiedName;
            }
            return super.getTypeName();
        }

        @Override
        public boolean isSmart() {
            return true;
        }

        private static String getFileNameUrl(PhpVariable variable) {
            FileObject file = variable.getFile();
            if (file != null && file.isValid()) {
                try {
                    return Utilities.toURI((File)FileUtil.toFile((FileObject)file)).toURL().toExternalForm();
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(PhpElementCompletionItem.class.getName()).log(Level.WARNING, null, ex);
                }
            }
            return null;
        }
    }
}

