/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;

public abstract class BodyDeclaration
extends Statement
implements Attributed {
    private int modifier;
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public BodyDeclaration(int start, int end, int modifier, boolean shouldComplete, List<Attribute> attributes) {
        super(start, end);
        this.modifier = shouldComplete ? BodyDeclaration.completeModifier(modifier) : modifier;
        this.attributes.addAll(attributes);
    }

    public BodyDeclaration(int start, int end, int modifier, boolean shouldComplete) {
        this(start, end, modifier, shouldComplete, Collections.emptyList());
    }

    public BodyDeclaration(int start, int end, int modifier) {
        this(start, end, modifier, false);
    }

    public String getModifierString() {
        return Modifier.toString(this.modifier);
    }

    public int getModifier() {
        return this.modifier;
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public boolean isAttributed() {
        return !this.attributes.isEmpty();
    }

    private static int completeModifier(int mod) {
        if (!Modifier.isPrivate(mod) && !Modifier.isProtected(mod)) {
            mod |= 1;
        }
        return mod;
    }

    public static class Modifier {
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int STATIC = 8;
        public static final int FINAL = 16;
        public static final int IMPLICIT_PUBLIC = 32;
        public static final int READONLY = 64;
        public static final int PUBLIC_SET = 128;
        public static final int PRIVATE_SET = 256;
        public static final int PROTECTED_SET = 512;
        public static final int ABSTRACT = 1024;

        public static boolean isPublic(int mod) {
            return (mod & 1) != 0 || (mod & 0x20) != 0;
        }

        public static boolean isImplicitPublic(int mod) {
            return (mod & 0x20) != 0;
        }

        public static boolean isPrivate(int mod) {
            return (mod & 2) != 0;
        }

        public static boolean isProtected(int mod) {
            return (mod & 4) != 0;
        }

        public static boolean isPublicSet(int mod) {
            return (mod & 0x80) != 0;
        }

        public static boolean isPrivateSet(int mod) {
            return (mod & 0x100) != 0;
        }

        public static boolean isProtectedSet(int mod) {
            return (mod & 0x200) != 0;
        }

        public static boolean isStatic(int mod) {
            return (mod & 8) != 0;
        }

        public static boolean isFinal(int mod) {
            return (mod & 0x10) != 0;
        }

        public static boolean isAbstract(int mod) {
            return (mod & 0x400) != 0;
        }

        public static boolean isReadonly(int mod) {
            return (mod & 0x40) != 0;
        }

        public static boolean isVisibilityModifier(int modifier) {
            return Modifier.isPublic(modifier) || Modifier.isProtected(modifier) || Modifier.isPrivate(modifier);
        }

        public static boolean isSetVisibilityModifier(int modifier) {
            return Modifier.isPublicSet(modifier) || Modifier.isProtectedSet(modifier) || Modifier.isPrivateSet(modifier);
        }

        public static String toString(int mod) {
            int len;
            StringBuilder sb = new StringBuilder();
            if ((mod & 1) != 0 || (mod & 0x20) != 0) {
                sb.append("public ");
            }
            if ((mod & 4) != 0) {
                sb.append("protected ");
            }
            if ((mod & 2) != 0) {
                sb.append("private ");
            }
            if ((mod & 0x80) != 0) {
                sb.append("public(set) ");
            }
            if ((mod & 0x200) != 0) {
                sb.append("protected(set) ");
            }
            if ((mod & 0x100) != 0) {
                sb.append("private(set) ");
            }
            if ((mod & 0x40) != 0) {
                sb.append("readonly ");
            }
            if ((mod & 0x400) != 0) {
                sb.append("abstract ");
            }
            if ((mod & 8) != 0) {
                sb.append("static ");
            }
            if ((mod & 0x10) != 0) {
                sb.append("final ");
            }
            if ((len = sb.length()) > 0) {
                return sb.toString().substring(0, len - 1);
            }
            return "";
        }
    }
}

