/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class CatchClause
extends Statement {
    private final List<Expression> classNames;
    @NullAllowed
    private final Variable variable;
    private final Block body;

    public CatchClause(int start, int end, List<Expression> classNames, @NullAllowed Variable variable, Block statement) {
        super(start, end);
        assert (!classNames.isEmpty() && statement != null);
        this.classNames = classNames;
        this.variable = variable;
        this.body = statement;
    }

    public List<Expression> getClassNames() {
        return Collections.unmodifiableList(this.classNames);
    }

    @CheckForNull
    public Variable getVariable() {
        return this.variable;
    }

    public Block getBody() {
        return this.body;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        this.getClassNames().forEach(name -> {
            if (!first) {
                sb.append(" | ");
            }
            sb.append(name);
        });
        if (this.variable != null) {
            sb.append(" ").append(this.getVariable());
        }
        return "catch (" + sb.toString() + ")" + this.getBody();
    }
}

