/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class InfixExpression
extends Expression {
    private Expression left;
    private OperatorType operator;
    private Expression right;

    public InfixExpression(int start, int end, Expression left, OperatorType operator, Expression right) {
        super(start, end);
        if (right == null || left == null) {
            throw new IllegalArgumentException();
        }
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public OperatorType getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getLeft() + " " + this.getOperator() + " " + this.getRight();
    }

    public static enum OperatorType {
        IS_IDENTICAL("==="),
        IS_NOT_IDENTICAL("!=="),
        IS_EQUAL("=="),
        IS_NOT_EQUAL("!="),
        RGREATER("<"),
        IS_SMALLER_OR_EQUAL("<="),
        LGREATER(">"),
        IS_GREATER_OR_EQUAL(">="),
        SPACESHIP("<=>"),
        BOOL_OR("||"),
        BOOL_AND("&&"),
        STRING_OR("or"),
        STRING_AND("and"),
        STRING_XOR("xor"),
        OR("|"),
        AND("&"),
        XOR("^"),
        CONCAT("."),
        PLUS("+"),
        MINUS("-"),
        MUL("*"),
        DIV("/"),
        MOD("%"),
        SL("<<"),
        SR(">>"),
        POW("**");

        private final String operatorSign;

        private OperatorType(String operatorSign) {
            this.operatorSign = operatorSign;
        }

        public String toString() {
            return this.operatorSign;
        }
    }
}

