/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public abstract class PSR12Hint
extends HintRule {
    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = this.createVisitor(fileObject, context.doc);
            if (checkVisitor.needScan()) {
                phpParseResult.getProgram().accept(checkVisitor);
            }
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    protected abstract CheckVisitor createVisitor(FileObject var1, BaseDocument var2);

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }

    public static abstract class CheckVisitor
    extends DefaultVisitor {
        private final PSR12Hint psr12hint;
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final List<Hint> hints;

        public CheckVisitor(PSR12Hint psr1hint, FileObject fileObject, BaseDocument baseDocument) {
            this.psr12hint = psr1hint;
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.hints = new ArrayList<Hint>();
        }

        public List<Hint> getHints() {
            return Collections.unmodifiableList(this.hints);
        }

        protected void createHint(ASTNode node, String message) {
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            this.createHint(offsetRange, message);
        }

        protected void createHint(OffsetRange offsetRange, String message) {
            if (this.psr12hint.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)this.psr12hint, Bundle.PSR12ViolationHintText(message), this.fileObject, offsetRange, null, 500));
            }
        }

        protected boolean needScan() {
            return true;
        }
    }
}

