/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.autosave;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.Timer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.openide.LifecycleManager;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class AutoSaveController {
    public static final String KEY_ACTIVE = "autoSaveActive";
    public static final String KEY_INTERVAL = "autoSaveInterval";
    public static final String KEY_SAVE_ON_FOCUS_LOST = "autoSaveOnFocusLost";
    public static final boolean KEY_ACTIVE_DEFAULT = false;
    private static AutoSaveController controller;
    private final PropertyChangeListener listener = evt -> {
        SaveCookie saveOperation;
        Document doc;
        DataObject dobj;
        Object old;
        String name = evt.getPropertyName();
        if ("focusLost".equals(name) && (old = evt.getOldValue()) instanceof JTextComponent && (dobj = (DataObject)(doc = ((JTextComponent)old).getDocument()).getProperty("stream")) != null && (saveOperation = (SaveCookie)dobj.getCookie(SaveCookie.class)) != null) {
            try {
                saveOperation.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    };
    private Timer timer;

    public static AutoSaveController getInstance() {
        if (controller == null) {
            controller = new AutoSaveController();
        }
        return controller;
    }

    public static Preferences prefs() {
        return NbPreferences.forModule(AutoSaveController.class);
    }

    private void startTimerSave() {
        int delay = AutoSaveController.prefs().getInt(KEY_INTERVAL, 10);
        if (delay == 0 && this.timer != null) {
            this.timer.stop();
            return;
        }
        delay = delay * 1000 * 60;
        if (this.timer == null) {
            this.timer = new Timer(delay, event -> {
                if (AutoSaveController.prefs().getBoolean(KEY_ACTIVE, false)) {
                    LifecycleManager.getDefault().saveAll();
                }
            });
        } else {
            this.timer.stop();
        }
        this.timer.setInitialDelay(delay);
        this.timer.setDelay(delay);
        this.timer.start();
    }

    private void stopTimerSave() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    private void startFocusSave() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this.listener);
    }

    private void stopFocusSave() {
        EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    public void stop() {
        this.stopTimerSave();
        this.stopFocusSave();
    }

    public void synchronize() {
        if (AutoSaveController.prefs().getBoolean(KEY_ACTIVE, false)) {
            this.startTimerSave();
        } else {
            this.stopTimerSave();
        }
        if (AutoSaveController.prefs().getBoolean(KEY_SAVE_ON_FOCUS_LOST, false)) {
            this.startFocusSave();
        } else {
            this.stopFocusSave();
        }
    }

    public static class Cleanup
    implements Runnable {
        @Override
        public void run() {
            AutoSaveController.getInstance().stop();
        }
    }

    public static class InitializeMe
    implements Runnable {
        @Override
        public void run() {
            AutoSaveController.getInstance().synchronize();
        }
    }
}

