/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.problems;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.problems.Bundle;
import org.netbeans.modules.gradle.problems.PropertiesEditor;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.util.EditableProperties;
import org.openide.util.RequestProcessor;

public class ChangeOrRemovePropertyResolver
implements ProjectProblemResolver {
    private static final Logger LOG = Logger.getLogger(ChangeOrRemovePropertyResolver.class.getName());
    private static final RequestProcessor EDIT_RP = new RequestProcessor(ChangeOrRemovePropertyResolver.class);
    private final Project project;
    private final String proxyHost;
    private final PropertiesEditor editor;
    private final int proxyPort;
    private final CompletableFuture<ProjectProblemsProvider.Result> future = new CompletableFuture();
    private final NbGradleProject gp;

    public ChangeOrRemovePropertyResolver(Project project, PropertiesEditor editor, String proxyHost, int proxyPort) {
        this.project = project;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.editor = editor;
        this.gp = NbGradleProject.get(project);
    }

    public Future<ProjectProblemsProvider.Result> resolve() {
        EDIT_RP.post(() -> this.run());
        return this.future;
    }

    public void run() {
        boolean reload = this.doRun();
        if (reload) {
            this.gp.toQuality(Bundle.ReasonProxyChanged(), NbGradleProject.Quality.FULL, true);
        }
    }

    boolean doRun() {
        EditableProperties p;
        if (this.editor == null) {
            return false;
        }
        try {
            p = this.editor.open();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not load properties: {0}", this.editor.getFilePath());
            LOG.log(Level.WARNING, "Error reported", ex);
            this.future.complete(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.Error_UpdatePropertiesError(this.editor.getFilePath(), ex.getLocalizedMessage())));
            return false;
        }
        boolean updated = this.updateProperties(p);
        if (!updated) {
            if (this.proxyHost == null) {
                this.future.complete(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.Error_ProxySettingNotFound()));
                return false;
            }
            p.setProperty("systemProp.http.proxyHost", this.proxyHost);
            p.setProperty("systemProp.http.proxyPort", Integer.toString(this.proxyPort));
            p.setProperty("systemProp.https.proxyHost", this.proxyHost);
            p.setProperty("systemProp.https.proxyPort", Integer.toString(this.proxyPort));
        }
        try {
            this.editor.save();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not save updated properties: {0}", this.editor.getFilePath());
            LOG.log(Level.WARNING, "Error reported", ex);
            this.future.complete(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.Error_UpdatePropertiesError(this.editor.getFilePath(), ex.getLocalizedMessage())));
            return false;
        }
        this.future.complete(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED));
        return true;
    }

    private boolean updateProperties(EditableProperties props) {
        boolean b = this.changeProperty(props, "systemProp.http.proxyHost");
        b |= this.changeProperty(props, "systemProp.https.proxyHost");
        return b |= this.changeProperty(props, "systemProp.socks.proxyHost");
    }

    private boolean changeProperty(EditableProperties props, String k) {
        String s = props.getProperty(k);
        if (s == null) {
            return false;
        }
        if (this.proxyHost != null) {
            props.setProperty(k, this.proxyHost);
            props.setProperty(k.replace("Host", "Port"), Integer.toString(this.proxyPort));
        } else {
            props.remove((Object)k);
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.project);
        hash = 83 * hash + Objects.hashCode(this.proxyHost);
        hash = 83 * hash + this.proxyPort;
        hash = 83 * hash + this.editor.getFilePath().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeOrRemovePropertyResolver other = (ChangeOrRemovePropertyResolver)obj;
        if (this.proxyPort != other.proxyPort) {
            return false;
        }
        if (!Objects.equals(this.proxyHost, other.proxyHost)) {
            return false;
        }
        return Objects.equals(this.project, other.project);
    }
}

