/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.vars.models;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.Watch;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EvaluateOnCallFrameRequest;
import org.netbeans.lib.chrome_devtools_protocol.runtime.RemoteObject;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.ui.vars.models.VariablesModel;
import org.netbeans.modules.javascript.cdtdebug.ui.vars.tooltip.ToolTipAnnotation;
import org.netbeans.modules.javascript.cdtdebug.vars.CDTEvaluator;
import org.netbeans.modules.javascript.cdtdebug.vars.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.AbstractExpandToolTipAction;
import org.netbeans.spi.debugger.ui.PinWatchUISupport;

public class PinWatchValueProvider
implements PinWatchUISupport.ValueProvider,
CDTDebugger.Listener {
    private final CDTDebugger dbg;
    private final Map<Watch, ValueListeners> valueListeners = new HashMap<Watch, ValueListeners>();

    public PinWatchValueProvider(ContextProvider lookupProvider) {
        this.dbg = (CDTDebugger)lookupProvider.lookupFirst(null, CDTDebugger.class);
        this.dbg.addListener((CDTDebugger.Listener)this);
    }

    public String getId() {
        return "org.netbeans.modules.javascript2.debug.PIN_VALUE_PROVIDER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        return vl.valueString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEditableValue(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action[] getHeadActions(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        RemoteObject value = vl.value;
        if (value == null || VariablesModel.isLeaf2(value)) {
            return null;
        }
        Variable var = new Variable(watch.getExpression(), value);
        return new Action[]{new ExpandAction(var)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangeListener(Watch watch, PinWatchUISupport.ValueProvider.ValueChangeListener chl) {
        ValueListeners vl = new ValueListeners(chl);
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.put(watch, vl);
        }
        this.updateValue(watch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetChangeListener(Watch watch) {
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.remove(watch);
        }
    }

    public void notifySuspended(boolean suspended) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCurrentFrame(CallFrame cf) {
        if (cf != null) {
            Map<Watch, ValueListeners> map = this.valueListeners;
            synchronized (map) {
                for (Map.Entry<Watch, ValueListeners> wvl : this.valueListeners.entrySet()) {
                    ValueListeners vl = wvl.getValue();
                    vl.value = null;
                    vl.valueString = this.getEvaluatingText();
                    vl.valueOnlyString = null;
                    Watch w = wvl.getKey();
                    vl.listener.valueChanged(w);
                    this.updateValue(w);
                }
            }
        }
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            for (Map.Entry<Watch, ValueListeners> wvl : this.valueListeners.entrySet()) {
                ValueListeners vl = wvl.getValue();
                vl.value = null;
                vl.valueString = null;
                vl.valueOnlyString = null;
                vl.listener.valueChanged(wvl.getKey());
            }
        }
    }

    public void notifyFinished() {
    }

    void updateValue(Watch watch) {
        if (!this.dbg.isSuspended()) {
            return;
        }
        this.dbg.getConnection().getDebugger().evaluateOnCallFrame(new EvaluateOnCallFrameRequest(this.dbg.getCurrentFrame().getCallFrameId(), watch.getExpression())).handle((eocfr, thr) -> {
            ValueListeners vl;
            Map<Watch, ValueListeners> map = this.valueListeners;
            synchronized (map) {
                vl = this.valueListeners.get(watch);
            }
            if (vl != null && eocfr != null && eocfr.getResult() != null) {
                String strValue;
                vl.value = eocfr.getResult();
                vl.valueString = strValue = CDTEvaluator.getStringValue((RemoteObject)vl.value);
                vl.valueOnlyString = strValue;
                vl.listener.valueChanged(watch);
            }
            return null;
        });
    }

    private static final class ValueListeners {
        volatile String valueString = null;
        volatile RemoteObject value = null;
        volatile String valueOnlyString = null;
        PinWatchUISupport.ValueProvider.ValueChangeListener listener;

        ValueListeners(PinWatchUISupport.ValueProvider.ValueChangeListener listener) {
            this.listener = listener;
        }
    }

    private class ExpandAction
    extends AbstractExpandToolTipAction {
        private final Variable var;

        ExpandAction(Variable var) {
            this.var = var;
        }

        protected void openTooltipView() {
            ToolTipSupport tts = this.openTooltipView(this.var.getName(), this.var);
            if (tts != null) {
                ToolTipAnnotation.handleToolTipClose(PinWatchValueProvider.this.dbg, tts);
            }
        }
    }
}

