/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.File;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.netbeans.modules.subversion.config.KVFile;
import org.netbeans.modules.subversion.config.SVNCredentialFile;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.filesystems.FileUtil;

public class CertificateFile
extends SVNCredentialFile {
    private static final KVFile.Key CERT = new KVFile.Key(0, "ascii_cert");
    private static final KVFile.Key FAILURES = new KVFile.Key(1, "failures");
    private static final KVFile.Key REALMSTRING = new KVFile.Key(2, "svn:realmstring");
    private static final String NEWLINE = System.getProperty("line.separator");

    public CertificateFile(X509Certificate cert, String realmString, int failures, boolean temporarily) throws CertificateEncodingException {
        super(CertificateFile.getNBCertFile(realmString));
        this.setCert(cert);
        this.setFailures(failures);
        this.setRealmString(realmString);
        if (temporarily) {
            this.getFile().deleteOnExit();
        }
    }

    private void setCert(X509Certificate cert) throws CertificateEncodingException {
        String encodedCert = Base64.getEncoder().encodeToString(cert.getEncoded());
        this.setValue(this.getCertKey(), encodedCert.getBytes());
    }

    @Override
    protected void setRealmString(String realm) {
        this.setValue(this.getRealmstringKey(), realm);
    }

    @Override
    protected String getRealmString() {
        return this.getStringValue(this.getRealmstringKey());
    }

    private void setFailures(int failures) {
        this.setValue(this.getFailuresKey(), String.valueOf(failures));
    }

    public static File getSystemCertFile(String realmString) {
        File file = new File(SvnConfigFiles.getUserConfigPath() + "auth/svn.ssl.server/" + CertificateFile.getFileName(realmString));
        return FileUtil.normalizeFile((File)file);
    }

    public static File getNBCertFile(String realmString) {
        File file = new File(SvnConfigFiles.getNBConfigPath() + "auth/svn.ssl.server/" + CertificateFile.getFileName(realmString));
        return FileUtil.normalizeFile((File)file);
    }

    private KVFile.Key getCertKey() {
        return this.getKey(CERT);
    }

    private KVFile.Key getFailuresKey() {
        return this.getKey(FAILURES);
    }

    private KVFile.Key getRealmstringKey() {
        return this.getKey(REALMSTRING);
    }
}

