/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.hyperlink;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lsp.HyperlinkLocation;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.spi.lsp.HyperlinkLocationProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautJavaHyperlinkProvider
implements HyperlinkProviderExt {
    private static final Pattern INJECT = Pattern.compile("\\$\\{(\\S+)(:\\S*)?}");

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        int[] span = new int[2];
        MicronautConfigUtilities.Usage usage = MicronautJavaHyperlinkProvider.resolve(doc, offset, span);
        return (int[])(usage != null ? span : null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        MicronautConfigUtilities.Usage usage = MicronautJavaHyperlinkProvider.resolve(doc, offset, null);
        if (usage == null || !UiUtils.open((FileObject)usage.getFileObject(), (int)usage.getStartOffset())) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        MicronautConfigUtilities.Usage usage = MicronautJavaHyperlinkProvider.resolve(doc, offset, null);
        return usage != null ? usage.getText() : null;
    }

    private static MicronautConfigUtilities.Usage resolve(Document doc, int offset, int[] span) {
        Project project;
        FileObject fo = EditorDocumentUtils.getFileObject((Document)doc);
        if (fo != null && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && MicronautConfigProperties.hasConfigMetadata(project)) {
            SourceGroup[] sourceGroups;
            for (SourceGroup sourceGroup : sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("resources")) {
                JavaSource source;
                FileObject rootFolder = sourceGroup.getRootFolder();
                ArrayList<FileObject> configFiles = new ArrayList<FileObject>();
                for (FileObject chldFo : rootFolder.getChildren()) {
                    if (!MicronautConfigUtilities.isMicronautConfigFile(chldFo)) continue;
                    configFiles.add(chldFo);
                }
                if (configFiles.isEmpty() || (source = JavaSource.forDocument((Document)doc)) == null) continue;
                try {
                    String propertyName = MicronautJavaHyperlinkProvider.getPropertyName(doc, offset, span);
                    ConfigurationMetadataProperty property = MicronautConfigProperties.getProperties(project).get(propertyName);
                    if (property == null) continue;
                    ArrayList usages = new ArrayList();
                    for (FileObject configFile : configFiles) {
                        MicronautConfigUtilities.collectUsages(configFile, propertyName, usage -> usages.add(usage));
                    }
                    if (usages.isEmpty()) continue;
                    return (MicronautConfigUtilities.Usage)usages.get(0);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return null;
    }

    private static String getPropertyName(Document doc, int offset, int[] span) throws IOException {
        String[] ret = new String[1];
        JavaSource source = JavaSource.forDocument((Document)doc);
        if (source != null) {
            source.runUserActionTask(controller -> {
                Element el;
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TreeUtilities tu = controller.getTreeUtilities();
                SourcePositions sp = controller.getTrees().getSourcePositions();
                TreePath path = tu.pathFor(offset);
                LiteralTree literal = null;
                AnnotationTree annotation = null;
                if (path.getLeaf().getKind() == Tree.Kind.STRING_LITERAL) {
                    literal = (LiteralTree)path.getLeaf();
                    TreePath annPath = tu.getPathElementOfKind(Tree.Kind.ANNOTATION, path);
                    annotation = annPath != null ? (AnnotationTree)annPath.getLeaf() : null;
                } else if (path.getLeaf().getKind() == Tree.Kind.ANNOTATION) {
                    annotation = (AnnotationTree)path.getLeaf();
                    for (ExpressionTree expressionTree : annotation.getArguments()) {
                        ExpressionTree expression;
                        if (expressionTree.getKind() != Tree.Kind.ASSIGNMENT || (expression = ((AssignmentTree)expressionTree).getExpression()).getKind() != Tree.Kind.STRING_LITERAL || sp.getStartPosition(path.getCompilationUnit(), expression) >= (long)offset || sp.getEndPosition(path.getCompilationUnit(), expression) < (long)offset) continue;
                        literal = (LiteralTree)expression;
                    }
                }
                if (literal != null && annotation != null && (el = controller.getTrees().getElement(new TreePath(path, annotation.getAnnotationType()))) != null && el.asType().getKind() == TypeKind.DECLARED) {
                    String value;
                    Matcher matcher;
                    Name name = ((TypeElement)((DeclaredType)el.asType()).asElement()).getQualifiedName();
                    if ("io.micronaut.context.annotation.Property".contentEquals(name)) {
                        ret[0] = (String)literal.getValue();
                        if (span != null) {
                            span[0] = (int)sp.getStartPosition(path.getCompilationUnit(), literal) + 1;
                            span[1] = (int)sp.getEndPosition(path.getCompilationUnit(), literal) - 1;
                        }
                    } else if ("io.micronaut.context.annotation.Value".contentEquals(name) && (matcher = INJECT.matcher(value = (String)literal.getValue())).find()) {
                        ret[0] = matcher.group(1);
                        if (span != null) {
                            span[0] = (int)sp.getStartPosition(path.getCompilationUnit(), literal) + matcher.start(1) + 1;
                            span[1] = (int)sp.getStartPosition(path.getCompilationUnit(), literal) + matcher.end(1) + 1;
                        }
                    }
                }
            }, true);
        }
        return ret[0];
    }

    public static class LocationProvider
    implements HyperlinkLocationProvider {
        public CompletableFuture<HyperlinkLocation> getHyperlinkLocation(Document doc, int offset) {
            MicronautConfigUtilities.Usage usage = MicronautJavaHyperlinkProvider.resolve(doc, offset, null);
            return CompletableFuture.completedFuture(usage != null ? HyperlinkLocationProvider.createHyperlinkLocation((FileObject)usage.getFileObject(), (int)usage.getStartOffset(), (int)usage.getEndOffset()) : null);
        }
    }
}

