/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerationManager;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.ui.CodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SoapServiceClientEditorDrop
implements ActiveEditorDrop {
    private final WsdlSaas service;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;
    private List<WsdlSaasMethod> methods;

    public SoapServiceClientEditorDrop(WsdlSaas service) {
        this.service = service;
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        this.doHandleTransfer(targetComponent);
        return true;
    }

    private List<WsdlSaasMethod> getMethods() {
        if (this.methods == null) {
            this.methods = new ArrayList<WsdlSaasMethod>();
            List ports = this.service.getPorts();
            for (WsdlSaasPort port : ports) {
                this.methods.addAll(port.getWsdlMethods());
            }
        }
        return this.methods;
    }

    private boolean doHandleTransfer(final JTextComponent targetComponent) {
        final Document targetDoc = targetComponent.getDocument();
        this.targetFO = SoapServiceClientEditorDrop.getTargetFile(targetComponent);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList errors = new ArrayList();
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){
            ProgressDialog[] dialog = new ProgressDialog[1];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (final WsdlSaasMethod method : SoapServiceClientEditorDrop.this.getMethods()) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                dialog[0] = new ProgressDialog(NbBundle.getMessage(SoapServiceClientEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)method.getName()));
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    try {
                        String displayName = method.getName();
                        SaasClientCodeGenerator codegen = (SaasClientCodeGenerator)SaasClientCodeGenerationManager.lookup((SaasMethod)method, targetDoc);
                        codegen.init((SaasMethod)method, targetDoc);
                        codegen.setDropLocation(targetComponent);
                        SoapClientSaasBean bean = (SoapClientSaasBean)codegen.getBean();
                        ArrayList<ParameterInfo> allParams = new ArrayList<ParameterInfo>(bean.getHeaderParameters());
                        if (bean.getInputParameters() != null) {
                            allParams.addAll(bean.getInputParameters());
                        }
                        if (!allParams.isEmpty()) {
                            boolean showParamTypes = Util.isJava(targetDoc) || Util.isJsp(targetDoc);
                            CodeSetupPanel panel = new CodeSetupPanel(allParams, showParamTypes);
                            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(SoapServiceClientEditorDrop.class, (String)"LBL_CustomizeSaasService", (Object)displayName));
                            Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                            if (response.equals(NotifyDescriptor.CANCEL_OPTION)) {
                                return;
                            }
                        }
                        try {
                            codegen.initProgressReporting(this.dialog[0].getProgressHandle());
                            codegen.generate();
                        }
                        catch (IOException ex) {
                            if (ex.getMessage().equals("ScanningInProgress")) continue;
                            errors.add(ex);
                        }
                    }
                    catch (Exception ioe) {
                        errors.add(ioe);
                    }
                    finally {
                        this.dialog[0].close();
                    }
                }
                this.dialog[0].open();
            }
        });
        this.generatorTask.schedule(50);
        if (errors.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)errors.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(JTextComponent targetComponent) {
        if (targetComponent == null) {
            return null;
        }
        DataObject d = NbEditorUtilities.getDataObject((Document)targetComponent.getDocument());
        if (d == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
        if (ec == null || ec.getOpenedPanes() == null) {
            return null;
        }
        return d.getPrimaryFile();
    }
}

