/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.j2se;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class LaunchAntListener
extends AntLogger {
    private static final Logger LOG = Logger.getLogger(LaunchAntListener.class.getName());
    private String[] MONITOR_TARGETS = new String[]{"do-debug-test-single", "debug-test-single-nb", "do-debug-test-main", "debug-test-main-nb", "debug-test-with-main", "debug-single", "debug", "run"};
    private ShellLaunchManager mgr;

    private ShellLaunchManager getManager() {
        if (this.mgr == null) {
            this.mgr = (ShellLaunchManager)Lookup.getDefault().lookup(ShellLaunchManager.class);
            if (this.mgr == null) {
                throw new IllegalStateException("Could not find launch manager");
            }
        }
        return this.mgr;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return this.MONITOR_TARGETS;
    }

    public void targetStarted(AntEvent event) {
        if (!Arrays.asList(this.MONITOR_TARGETS).contains(event.getTargetName())) {
            return;
        }
        super.targetStarted(event);
        InputOutput io = event.getSession().getIO();
        String authKey = ShellLaunchManager.getAuthKey(event.evaluate("${run.jvmargs.ide}"));
        String authKey2 = ShellLaunchManager.getAuthKey(event.evaluate("${run.jvmargs}"));
        if (authKey == null && authKey2 == null) {
            return;
        }
        String dispName = event.getSession().getDisplayName();
        this.getManager().attachInputOutput(authKey, io, dispName);
        this.getManager().attachInputOutput(authKey2, io, dispName);
    }

    public boolean interestedInSession(AntSession session) {
        LOG.log(Level.FINE, "Checking interestInSession: " + session);
        String s = (String)session.getProperties().get("run.jvmargs");
        return s != null && s.contains("jshell-probe.jar");
    }

    public void buildFinished(AntEvent event) {
        LOG.log(Level.FINE, "Got build finished: " + event);
        this.destroyAgent(event);
    }

    private void destroyAgent(AntEvent event) {
        String authKey = ShellLaunchManager.getAuthKey(event.evaluate("${run.jvmargs.ide}"));
        String authKey2 = ShellLaunchManager.getAuthKey(event.evaluate("${run.jvmargs}"));
        RequestProcessor.getDefault().post(() -> {
            this.getManager().destroyAgent(authKey);
            this.getManager().destroyAgent(authKey2);
        });
    }

    public void buildInitializationFailed(AntEvent event) {
        LOG.log(Level.FINE, "Got build init failed: " + event);
        this.destroyAgent(event);
    }
}

