/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;

public abstract class EditorToolbar
extends JComponent
implements MouseInputListener,
KeyListener {
    static final int BUTTON_WIDTH = 27;
    static final int BUTTON_HEIGHT = 32;
    static final int BUTTON_GAP = 5;
    static final int BUTTON_IMAGE_SIZE = 33;
    static final int INACTIVE = 0;
    static final int ROLLOVER = 1;
    static final int ACTIVE = 2;
    protected Base base;
    protected Editor editor;
    protected Mode mode;
    Image offscreen;
    int width;
    int height;
    Color bgcolor;
    protected Button rollover;
    static final int TOP = 0;
    static final int BOTTOM = 32;
    Font statusFont;
    Color statusColor;
    boolean shiftPressed;
    Color modeButtonColor;
    Font modeTextFont;
    Color modeTextColor;
    String modeTitle;
    int modeX1;
    int modeY1;
    int modeX2;
    int modeY2;
    JMenu modeMenu;
    protected ArrayList<Button> buttons;

    public EditorToolbar(Editor editor, Base base) {
        this.editor = editor;
        this.base = base;
        this.buttons = new ArrayList();
        this.rollover = null;
        this.mode = editor.getMode();
        this.bgcolor = this.mode.getColor("buttons.bgcolor");
        this.statusFont = this.mode.getFont("buttons.status.font");
        this.statusColor = this.mode.getColor("buttons.status.color");
        this.modeTitle = this.mode.getTitle().toUpperCase();
        this.modeTextFont = this.mode.getFont("mode.button.font");
        this.modeButtonColor = this.mode.getColor("mode.button.color");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public abstract void init();

    public Image[][] loadImages() {
        Image allButtons = this.mode.loadImage("theme/buttons.gif");
        int count = allButtons.getWidth(this) / 27;
        Image[][] buttonImages = new Image[count][3];
        for (int i = 0; i < count; ++i) {
            for (int state = 0; state < 3; ++state) {
                Image image = this.createImage(27, 32);
                Graphics g = image.getGraphics();
                g.drawImage(allButtons, -(i * 33) - 3, (-2 + state) * 33, null);
                buttonImages[i][state] = image;
            }
        }
        return buttonImages;
    }

    public void paintComponent(Graphics screen) {
        if (this.buttons.size() == 0) {
            this.init();
        }
        Dimension size = this.getSize();
        if (this.offscreen == null || size.width != this.width || size.height != this.height) {
            this.offscreen = this.createImage(size.width, size.height);
            this.width = size.width;
            this.height = size.height;
            int offsetX = 3;
            for (Button b : this.buttons) {
                b.left = offsetX;
                if (b.gap) {
                    b.left += 5;
                }
                offsetX = b.right = b.left + 27;
            }
        }
        Graphics g = this.offscreen.getGraphics();
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, this.width, this.height);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (Button b : this.buttons) {
            g.drawImage(b.stateImage, b.left, 0, null);
        }
        g.setColor(this.statusColor);
        g.setFont(this.statusFont);
        if (this.rollover != null) {
            int statusY = (32 + g.getFontMetrics().getAscent()) / 2;
            String status = this.shiftPressed ? this.rollover.titleShift : this.rollover.title;
            g.drawString(status, this.buttons.size() * 27 + 15, statusY);
        }
        g.setFont(this.modeTextFont);
        FontMetrics metrics = g.getFontMetrics();
        int modeH = metrics.getAscent();
        int modeW = metrics.stringWidth(this.modeTitle);
        int modeGapH = 6;
        int modeGapV = 3;
        this.modeX2 = this.getWidth() - 16;
        this.modeX1 = this.modeX2 - (6 + modeW + 6);
        this.modeY1 = (this.getHeight() - modeH) / 2 - 3;
        this.modeY2 = this.modeY1 + modeH + 6;
        g.setColor(this.modeButtonColor);
        g.drawRect(this.modeX1, this.modeY1, this.modeX2 - this.modeX1, this.modeY2 - this.modeY1);
        g.drawString(this.modeTitle, this.modeX1 + 6, this.modeY2 - 3);
        screen.drawImage(this.offscreen, 0, 0, null);
        if (!this.isEnabled()) {
            screen.setColor(new Color(0, 0, 0, 100));
            screen.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void checkRollover(int x, int y) {
        Button over = this.findSelection(x, y);
        if (over != null && over.state != 2) {
            over.setState(1, true);
            this.rollover = over;
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.offscreen == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.rollover != null) {
            if (y > 0 && y < 32 && x > this.rollover.left && x < this.rollover.right) {
                return;
            }
            this.rollover.setState(0, true);
            this.rollover = null;
        }
        this.checkRollover(x, y);
    }

    public void mouseDragged(MouseEvent e) {
    }

    private Button findSelection(int x, int y) {
        if (this.offscreen != null && y > 0 && y < 32) {
            for (Button b : this.buttons) {
                if (x <= b.left || x >= b.right) continue;
                return b;
            }
        }
        return null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (e.getComponent() != this) {
            return;
        }
        if (this.rollover != null) {
            this.rollover.setState(0, true);
            this.rollover = null;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.isEnabled()) {
            int x = e.getX();
            int y = e.getY();
            if (x > this.modeX1 && x < this.modeX2 && y > this.modeY1 && y < this.modeY2) {
                JPopupMenu popup = this.editor.getModeMenu().getPopupMenu();
                popup.show(this, x, y);
            }
            this.checkRollover(x, y);
            if (this.rollover != null) {
                this.handlePressed(e, this.buttons.indexOf(this.rollover));
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public abstract void handlePressed(MouseEvent var1, int var2);

    public void activate(int what) {
        this.buttons.get(what).setState(2, true);
    }

    public void deactivate(int what) {
        this.buttons.get(what).setState(0, true);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension((this.buttons.size() + 1) * 27, 32);
    }

    public Dimension getMaximumSize() {
        return new Dimension(3000, 32);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = true;
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = false;
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void addButton(String title, String shiftTitle, Image[] images, boolean gap) {
        Button b = new Button(title, shiftTitle, images, gap);
        this.buttons.add(b);
    }

    public class Button {
        String title;
        String titleShift;
        Image[] images;
        int state;
        Image stateImage;
        int left;
        int right;
        boolean gap;

        public Button(String title, String titleShift, Image[] images, boolean gap) {
            this.title = title;
            this.titleShift = titleShift;
            this.images = images;
            this.gap = gap;
            this.state = 0;
            this.stateImage = images[0];
        }

        public void setState(int newState, boolean updateAfter) {
            this.state = newState;
            this.stateImage = this.images[newState];
            if (updateAfter) {
                EditorToolbar.this.repaint();
            }
        }
    }
}

