/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    protected long pos;
    protected long markedPos = -1L;
    protected InputStream stream;

    public CountingInputStream(InputStream istream) {
        this.stream = istream;
    }

    public synchronized int read() throws IOException {
        int ret = this.stream.read();
        if (ret != -1) {
            ++this.pos;
        }
        return ret;
    }

    public synchronized int read(byte[] b) throws IOException {
        int ret = this.stream.read(b);
        if (ret >= 0) {
            this.pos += (long)ret;
        }
        return ret;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int ret = this.stream.read(b, off, len);
        if (ret > 0) {
            this.pos += (long)ret;
        }
        return ret;
    }

    public synchronized long skip(long n) throws IOException {
        long ret = this.stream.skip(n);
        if (ret > 0L) {
            this.pos += ret;
        }
        return ret;
    }

    public synchronized int available() throws IOException {
        return this.stream.available();
    }

    public synchronized void close() throws IOException {
        this.stream.close();
    }

    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
        this.markedPos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.stream.reset();
        this.pos = this.markedPos;
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    public long getPos() {
        return this.pos;
    }
}

