/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.statusrequestv2.RequestItemV2;
import de.rub.nds.tlsattacker.core.protocol.message.extension.statusrequestv2.ResponderId;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ResponderIdParser;
import java.util.LinkedList;

public class RequestItemV2Parser
extends Parser<RequestItemV2> {
    public RequestItemV2Parser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public RequestItemV2 parse() {
        RequestItemV2 item = new RequestItemV2();
        item.setRequestType(this.parseIntField(1));
        item.setRequestLength(this.parseIntField(2));
        item.setResponderIdListLength(this.parseIntField(2));
        item.setResponderIdListBytes(this.parseByteArrayField((Integer)item.getResponderIdListLength().getValue()));
        item.setRequestExtensionsLength(this.parseIntField(2));
        item.setRequestExtensions(this.parseByteArrayField((Integer)item.getRequestExtensionsLength().getValue()));
        int position = 0;
        LinkedList<ResponderId> resonderIds = new LinkedList<ResponderId>();
        while (position < ((byte[])item.getResponderIdListBytes().getValue()).length) {
            ResponderIdParser parser = new ResponderIdParser(position, (byte[])item.getResponderIdListBytes().getValue());
            resonderIds.add(parser.parse());
            if (position == parser.getPointer()) {
                throw new ParserException("Ran into infinite Loop while parsing ResponderId");
            }
            position = parser.getPointer();
        }
        item.setResponderIdList(resonderIds);
        return item;
    }
}

