/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupportedVersionsExtensionParser
extends ExtensionParser<SupportedVersionsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SupportedVersionsExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(SupportedVersionsExtensionMessage msg) {
        LOGGER.debug("Parsing SupportedVersionsExtensionMessage");
        if ((Integer)msg.getExtensionLength().getValue() == 2) {
            msg.setSupportedVersions(this.parseByteArrayField(2));
        } else {
            this.parseSupportedVersionLength(msg);
            this.parseSupportedVersion(msg);
        }
    }

    @Override
    protected SupportedVersionsExtensionMessage createExtensionMessage() {
        return new SupportedVersionsExtensionMessage();
    }

    private void parseSupportedVersionLength(SupportedVersionsExtensionMessage msg) {
        msg.setSupportedVersionsLength(this.parseIntField(1));
        LOGGER.debug("SupportedVersionsLength: " + msg.getSupportedVersionsLength().getValue());
    }

    private void parseSupportedVersion(SupportedVersionsExtensionMessage msg) {
        msg.setSupportedVersions(this.parseByteArrayField((Integer)msg.getSupportedVersionsLength().getValue()));
        LOGGER.debug("SupportedVersions: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSupportedVersions().getValue())));
    }
}

